/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.sax;

import com.fasterxml.aalto.sax.SAXFeature;
import com.fasterxml.aalto.sax.SAXParserImpl;
import com.fasterxml.aalto.sax.SAXUtil;
import com.fasterxml.aalto.stax.InputFactoryImpl;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SAXParserFactoryImpl
extends SAXParserFactory {
    final InputFactoryImpl mStaxFactory = new InputFactoryImpl();

    public static SAXParserFactory newInstance() {
        return new SAXParserFactoryImpl();
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAXFeature stdFeat = SAXUtil.findStdFeature(name);
        if (stdFeat != null) {
            Boolean b = SAXUtil.getFixedStdFeatureValue(stdFeat);
            if (b != null) {
                return b;
            }
            switch (stdFeat) {
                case IS_STANDALONE: {
                    return true;
                }
            }
        } else if (name.equals("com.fasterxml.aalto.retainAttributeGeneralEntities")) {
            return Boolean.TRUE.equals(this.mStaxFactory.getProperty("com.fasterxml.aalto.retainAttributeGeneralEntities"));
        }
        SAXUtil.reportUnknownFeature(name);
        return false;
    }

    @Override
    public SAXParser newSAXParser() {
        return new SAXParserImpl(this.mStaxFactory);
    }

    @Override
    public void setFeature(String name, boolean enabled) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAXFeature stdFeat = SAXUtil.findStdFeature(name);
        if (stdFeat != null) {
            boolean ok;
            switch (stdFeat) {
                case EXTERNAL_GENERAL_ENTITIES: {
                    ok = !enabled;
                    break;
                }
                case EXTERNAL_PARAMETER_ENTITIES: {
                    ok = !enabled;
                    break;
                }
                case IS_STANDALONE: {
                    ok = true;
                    break;
                }
                case LEXICAL_HANDLER_PARAMETER_ENTITIES: {
                    ok = true;
                    break;
                }
                case NAMESPACES: {
                    ok = enabled;
                    break;
                }
                case NAMESPACE_PREFIXES: {
                    ok = !enabled;
                    break;
                }
                case RESOLVE_DTD_URIS: {
                    ok = true;
                    break;
                }
                case STRING_INTERNING: {
                    ok = true;
                    break;
                }
                case UNICODE_NORMALIZATION_CHECKING: {
                    ok = false;
                    break;
                }
                case USE_ATTRIBUTES2: 
                case USE_LOCATOR2: 
                case USE_ENTITY_RESOLVER2: {
                    ok = true;
                    break;
                }
                case VALIDATION: {
                    ok = !enabled;
                    break;
                }
                case XMLNS_URIS: {
                    ok = true;
                    break;
                }
                case XML_1_1: {
                    ok = !enabled;
                    break;
                }
                default: {
                    ok = false;
                }
            }
            if (!ok) {
                throw new SAXNotSupportedException("Setting std feature " + (Object)((Object)stdFeat) + " to " + enabled + " not supported");
            }
            return;
        }
        if (name.equals("com.fasterxml.aalto.retainAttributeGeneralEntities")) {
            this.mStaxFactory.setProperty("com.fasterxml.aalto.retainAttributeGeneralEntities", enabled);
            return;
        }
        SAXUtil.reportUnknownFeature(name);
    }

    @Override
    public void setNamespaceAware(boolean awareness) {
        if (!awareness) {
            throw new IllegalArgumentException("Non-namespace-aware mode not implemented");
        }
        super.setNamespaceAware(awareness);
    }

    @Override
    public void setValidating(boolean value) {
        if (value) {
            throw new IllegalArgumentException("Validating mode not implemented");
        }
        super.setValidating(value);
    }
}

