/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.renderkit.html;

import java.io.IOException;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectMany;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.component.html.HtmlSelectManyCheckbox;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class HtmlCheckboxRendererBase
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog(HtmlCheckboxRendererBase.class);
    private static final String PAGE_DIRECTION = "pageDirection";
    private static final String LINE_DIRECTION = "lineDirection";
    private static final String EXTERNAL_TRUE_VALUE = "true";

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UISelectBoolean) {
            Boolean value = RendererUtils.getBooleanValue(uiComponent);
            boolean isChecked = value != null ? value : false;
            this.renderCheckbox(facesContext, uiComponent, EXTERNAL_TRUE_VALUE, false, isChecked, true, null);
        } else if (uiComponent instanceof UISelectMany) {
            this.renderCheckboxList(facesContext, (UISelectMany)uiComponent);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
        }
    }

    public void renderCheckboxList(FacesContext facesContext, UISelectMany selectMany) throws IOException {
        boolean useSubmittedValues;
        Converter converter;
        String layout = this.getLayout(selectMany);
        boolean pageDirectionLayout = false;
        if (layout != null) {
            if (layout.equals(PAGE_DIRECTION)) {
                pageDirectionLayout = true;
            } else if (layout.equals(LINE_DIRECTION)) {
                pageDirectionLayout = false;
            } else {
                log.error((Object)("Wrong layout attribute for component " + selectMany.getClientId(facesContext) + ": " + layout));
            }
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", (UIComponent)selectMany);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)selectMany, HTML.SELECT_TABLE_PASSTHROUGH_ATTRIBUTES);
        HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)selectMany, facesContext);
        if (!pageDirectionLayout) {
            writer.startElement("tr", (UIComponent)selectMany);
        }
        try {
            converter = RendererUtils.findUISelectManyConverter(facesContext, selectMany);
        }
        catch (FacesException e) {
            log.error((Object)("Error finding Converter for component with id " + selectMany.getClientId(facesContext)));
            converter = null;
        }
        Set lookupSet = RendererUtils.getSubmittedValuesAsSet(facesContext, (UIComponent)selectMany, converter, selectMany);
        boolean bl = useSubmittedValues = lookupSet != null;
        if (!useSubmittedValues) {
            lookupSet = RendererUtils.getSelectedValuesAsSet(facesContext, (UIComponent)selectMany, converter, selectMany);
        }
        int itemNum = 0;
        for (SelectItem selectItem : RendererUtils.getSelectItemList(selectMany)) {
            this.renderGroupOrItemCheckbox(facesContext, (UIComponent)selectMany, selectItem, useSubmittedValues, lookupSet, converter, pageDirectionLayout, new Integer(itemNum));
            ++itemNum;
        }
        if (!pageDirectionLayout) {
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    protected String getLayout(UISelectMany selectMany) {
        if (selectMany instanceof HtmlSelectManyCheckbox) {
            return ((HtmlSelectManyCheckbox)selectMany).getLayout();
        }
        return (String)selectMany.getAttributes().get("layout");
    }

    protected void renderGroupOrItemCheckbox(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, boolean useSubmittedValues, Set lookupSet, Converter converter, boolean pageDirectionLayout, Integer itemNum) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean isSelectItemGroup = selectItem instanceof SelectItemGroup;
        Object itemValue = selectItem.getValue();
        UISelectMany selectMany = (UISelectMany)uiComponent;
        String itemStrValue = RendererUtils.getConvertedStringValue(facesContext, (UIComponent)selectMany, converter, itemValue);
        if (isSelectItemGroup) {
            if (pageDirectionLayout) {
                writer.startElement("tr", (UIComponent)selectMany);
            }
            writer.startElement("td", (UIComponent)selectMany);
            if (selectItem.isEscape()) {
                writer.writeText((Object)selectItem.getLabel(), "label");
            } else {
                writer.write(selectItem.getLabel());
            }
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
                writer.startElement("tr", (UIComponent)selectMany);
            }
            writer.startElement("td", (UIComponent)selectMany);
            writer.startElement("table", (UIComponent)selectMany);
            writer.writeAttribute("border", (Object)"0", null);
            SelectItemGroup group = (SelectItemGroup)selectItem;
            SelectItem[] selectItems = group.getSelectItems();
            for (int i = 0; i < selectItems.length; ++i) {
                this.renderGroupOrItemCheckbox(facesContext, (UIComponent)selectMany, selectItems[i], useSubmittedValues, lookupSet, converter, pageDirectionLayout, new Integer(i));
            }
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("table");
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
            }
        } else {
            writer.write("\t\t");
            if (pageDirectionLayout) {
                writer.startElement("tr", (UIComponent)selectMany);
            }
            writer.startElement("td", (UIComponent)selectMany);
            boolean checked = lookupSet.contains(itemStrValue);
            boolean disabled = selectItem.isDisabled();
            String itemId = this.renderCheckbox(facesContext, (UIComponent)selectMany, itemStrValue, disabled, checked, false, itemNum);
            boolean componentDisabled = this.isDisabled(facesContext, (UIComponent)selectMany);
            boolean itemDisabled = componentDisabled || disabled;
            HtmlRendererUtils.renderLabel(writer, (UIComponent)selectMany, itemId, selectItem, itemDisabled);
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
            }
        }
    }

    @Deprecated
    protected void renderCheckbox(FacesContext facesContext, UIComponent uiComponent, String value, String label, boolean disabled, boolean checked, boolean renderId) throws IOException {
        this.renderCheckbox(facesContext, uiComponent, value, disabled, checked, renderId, 0);
    }

    protected String renderCheckbox(FacesContext facesContext, UIComponent uiComponent, String value, boolean disabled, boolean checked, boolean renderId, Integer itemNum) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        String itemId = itemNum == null ? null : clientId + ':' + itemNum;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        if (itemId != null) {
            writer.writeAttribute("id", (Object)itemId, null);
        }
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (renderId) {
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        }
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (value != null && value.length() > 0) {
            writer.writeAttribute("value", (Object)value, null);
        }
        if (uiComponent instanceof UISelectBoolean) {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE);
        }
        if (this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        writer.endElement("input");
        return itemId;
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent component) {
        if (component instanceof HtmlSelectBooleanCheckbox) {
            return ((HtmlSelectBooleanCheckbox)component).isDisabled();
        }
        if (component instanceof HtmlSelectManyCheckbox) {
            return ((HtmlSelectManyCheckbox)component).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(component, "disabled", false);
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        RendererUtils.checkParamValidity(facesContext, component, null);
        if (component instanceof UISelectBoolean) {
            HtmlRendererUtils.decodeUISelectBoolean(facesContext, component);
        } else if (component instanceof UISelectMany) {
            HtmlRendererUtils.decodeUISelectMany(facesContext, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, component, null);
        if (component instanceof UISelectBoolean) {
            return submittedValue;
        }
        if (component instanceof UISelectMany) {
            return RendererUtils.getConvertedUISelectManyValue(facesContext, (UISelectMany)component, submittedValue);
        }
        throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
    }
}

