/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;
import org.apache.myfaces.custom.schedule.DefaultScheduleEntryRenderer;
import org.apache.myfaces.custom.schedule.HtmlSchedule;
import org.apache.myfaces.custom.schedule.ScheduleEntryRenderer;
import org.apache.myfaces.custom.schedule.ScheduleMouseEvent;
import org.apache.myfaces.custom.schedule.UIScheduleBase;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.util.ScheduleEntryComparator;
import org.apache.myfaces.custom.schedule.util.ScheduleUtil;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;

public abstract class AbstractScheduleRenderer
extends Renderer
implements Serializable {
    protected static final ScheduleEntryComparator comparator = new ScheduleEntryComparator();
    protected static final String LAST_CLICKED_DATE = "_last_clicked_date";
    protected static final String LAST_CLICKED_Y = "_last_clicked_y";
    private static final String CSS_RESOURCE = "css/schedule.css";
    public static final String DEFAULT_THEME = "default";
    public static final String OUTLOOK_THEME = "outlookxp";
    public static final String EVOLUTION_THEME = "evolution";

    public void decode(FacesContext context, UIComponent component) {
        HtmlSchedule schedule = (HtmlSchedule)component;
        boolean queueAction = false;
        if (ScheduleUtil.canModifyValue(component)) {
            Map parameters = context.getExternalContext().getRequestParameterMap();
            String selectedEntryId = (String)parameters.get(schedule.getClientId(context));
            String lastClickedDateId = (String)parameters.get(schedule.getClientId(context) + LAST_CLICKED_DATE);
            String lastClickedY = (String)parameters.get(schedule.getClientId(context) + LAST_CLICKED_Y);
            ScheduleMouseEvent mouseEvent = null;
            if (selectedEntryId != null && selectedEntryId.length() > 0) {
                ScheduleEntry entry = schedule.findEntry(selectedEntryId);
                schedule.setSubmittedEntry(entry);
                mouseEvent = new ScheduleMouseEvent(schedule, 3);
                queueAction = true;
            }
            if (schedule.isSubmitOnClick()) {
                schedule.resetMouseEvents();
                if (lastClickedY != null && lastClickedY.length() > 0) {
                    schedule.setLastClickedDateAndTime(this.determineLastClickedDate(schedule, lastClickedDateId, lastClickedY));
                    mouseEvent = new ScheduleMouseEvent(schedule, 1);
                    queueAction = true;
                } else if (lastClickedDateId != null && lastClickedDateId.length() > 0) {
                    schedule.setLastClickedDateAndTime(this.determineLastClickedDate(schedule, lastClickedDateId, "0"));
                    mouseEvent = new ScheduleMouseEvent(schedule, 2);
                    queueAction = true;
                } else if (mouseEvent == null) {
                    mouseEvent = new ScheduleMouseEvent(schedule, 0);
                }
            }
            if (mouseEvent != null) {
                schedule.queueEvent(mouseEvent);
            }
        }
        if (queueAction) {
            schedule.queueEvent((FacesEvent)new ActionEvent((UIComponent)schedule));
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlSchedule schedule = (HtmlSchedule)component;
        ResponseWriter writer = context.getResponseWriter();
        AddResource addResource = AddResourceFactory.getInstance(context);
        String theme = schedule.getTheme();
        if (DEFAULT_THEME.equals(theme) || OUTLOOK_THEME.equals(theme) || EVOLUTION_THEME.equals(theme)) {
            addResource.addStyleSheet(context, AddResource.HEADER_BEGIN, HtmlSchedule.class, CSS_RESOURCE);
        }
        addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, HtmlSchedule.class, "javascript/schedule.js");
        if (schedule.isTooltip()) {
            addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, HtmlSchedule.class, "javascript/alphaAPI.js");
            addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, HtmlSchedule.class, "javascript/domLib.js");
            addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, HtmlSchedule.class, "javascript/domTT.js");
            addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, HtmlSchedule.class, "javascript/fadomatic.js");
        }
        writer.startElement("input", (UIComponent)schedule);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)schedule.getClientId(context), "clientId");
        writer.endElement("input");
        writer.startElement("input", (UIComponent)schedule);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)(schedule.getClientId(context) + LAST_CLICKED_DATE), "clicked_date");
        writer.endElement("input");
        writer.startElement("input", (UIComponent)schedule);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)(schedule.getClientId(context) + LAST_CLICKED_Y), "clicked_y");
        writer.endElement("input");
    }

    protected String getDateString(FacesContext context, UIScheduleBase schedule, Date date) {
        return AbstractScheduleRenderer.getDateFormat(context, schedule, schedule.getHeaderDateFormat(), date).format(date);
    }

    protected static DateFormat getDateFormat(FacesContext context, UIScheduleBase schedule, String pattern) {
        Locale viewLocale = context.getViewRoot().getLocale();
        DateFormat format = pattern != null && pattern.length() > 0 ? new SimpleDateFormat(pattern, viewLocale) : DateFormat.getDateInstance(2, viewLocale);
        format.setTimeZone(schedule.getModel().getTimeZone());
        return format;
    }

    protected static DateFormat getDateFormat(FacesContext context, UIScheduleBase schedule, String pattern, Date date) {
        Locale viewLocale = context.getViewRoot().getLocale();
        if (pattern != null && pattern.indexOf("d'th'") >= 0) {
            pattern = pattern.replaceAll("d'th'", "d'" + AbstractScheduleRenderer.daySuffix(schedule, date, viewLocale) + "'");
        }
        return AbstractScheduleRenderer.getDateFormat(context, schedule, pattern);
    }

    private static String daySuffix(UIScheduleBase schedule, Date date, Locale locale) {
        String language = locale.getLanguage();
        Calendar calendar = ScheduleUtil.getCalendarInstance(date, schedule.getModel().getTimeZone());
        int dayOfMonth = calendar.get(5);
        if (Locale.ENGLISH.getLanguage().equals(language)) {
            switch (dayOfMonth) {
                case 1: 
                case 21: 
                case 31: {
                    return "st";
                }
                case 2: 
                case 22: {
                    return "nd";
                }
                case 3: 
                case 23: {
                    return "rd";
                }
            }
            return "th";
        }
        if (Locale.GERMAN.getLanguage().equals(language)) {
            return ".";
        }
        return "";
    }

    protected String getStyleClass(UIComponent component, String className) {
        String value;
        ValueBinding binding = component.getValueBinding(className);
        if (binding != null && (value = (String)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        Map attributes = component.getAttributes();
        String returnValue = (String)attributes.get(className + "Class");
        return returnValue == null ? className : returnValue;
    }

    protected ScheduleEntryRenderer getEntryRenderer(HtmlSchedule schedule) {
        Object entryRenderer = schedule.getEntryRenderer();
        if (entryRenderer instanceof ScheduleEntryRenderer) {
            return (ScheduleEntryRenderer)entryRenderer;
        }
        return new DefaultScheduleEntryRenderer();
    }

    protected abstract int getDefaultRowHeight();

    protected abstract int getRowHeight(UIScheduleBase var1);

    protected abstract Date determineLastClickedDate(HtmlSchedule var1, String var2, String var3);

    public boolean getRendersChildren() {
        return true;
    }

    protected Calendar getCalendarInstance(UIScheduleBase schedule, Date date) {
        return ScheduleUtil.getCalendarInstance(date, schedule.getModel().getTimeZone());
    }
}

