/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.date;

import java.io.IOException;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.calendar.DateBusinessConverter;
import org.apache.myfaces.custom.calendar.DefaultDateBusinessConverter;
import org.apache.myfaces.custom.calendar.FunctionCallProvider;
import org.apache.myfaces.custom.calendar.HtmlCalendarRenderer;
import org.apache.myfaces.custom.date.AbstractHtmlInputDate;
import org.apache.myfaces.custom.date.HtmlInputDate;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared_tomahawk.util.MessageUtils;

public class HtmlDateRenderer
extends HtmlRenderer {
    public static final String DATE_MESSAGE_ID = "org.apache.myfaces.Date.INVALID";
    private static final String ID_DAY_POSTFIX = ".day";
    private static final String ID_MONTH_POSTFIX = ".month";
    private static final String ID_YEAR_POSTFIX = ".year";
    private static final String ID_HOURS_POSTFIX = ".hours";
    private static final String ID_MINUTES_POSTFIX = ".minutes";
    private static final String ID_SECONDS_POSTFIX = ".seconds";
    private static final String ID_AMPM_POSTFIX = ".ampm";

    public static String getClientIdForDaySubcomponent(String clientId) {
        return clientId + ID_DAY_POSTFIX;
    }

    protected boolean isDisabled(FacesContext facesContext, HtmlInputDate inputDate) {
        if (!UserRoleUtils.isEnabledOnUserRole((UIComponent)inputDate)) {
            return false;
        }
        return inputDate.isDisabled();
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, HtmlInputDate.class);
        HtmlInputDate inputDate = (HtmlInputDate)uiComponent;
        Locale currentLocale = facesContext.getViewRoot().getLocale();
        AbstractHtmlInputDate.UserData userData = null;
        String type = inputDate.getType();
        boolean ampm = inputDate.isAmpm();
        String clientId = uiComponent.getClientId(facesContext);
        if (null == inputDate.getConverter()) {
            userData = (AbstractHtmlInputDate.UserData)inputDate.getSubmittedValue();
            if (userData == null) {
                userData = inputDate.getUserData(currentLocale);
            }
        } else {
            String value = RendererUtils.getStringValue(facesContext, (UIComponent)inputDate);
            userData = inputDate.getUserData(currentLocale);
            if (null != value) {
                StringTokenizer st = new StringTokenizer(value, "\n");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.startsWith("year=")) {
                        userData.setYear(token.substring(5));
                    }
                    if (token.startsWith("month=")) {
                        userData.setMonth(token.substring(6));
                    }
                    if (token.startsWith("day=")) {
                        userData.setDay(token.substring(4));
                    }
                    if (token.startsWith("hours=")) {
                        userData.setHours(token.substring(6));
                    }
                    if (token.startsWith("minutes=")) {
                        userData.setMinutes(token.substring(8));
                    }
                    if (token.startsWith("seconds=")) {
                        userData.setSeconds(token.substring(8));
                    }
                    if (!token.startsWith("ampm=")) continue;
                    userData.setAmpm(token.substring(5));
                }
            }
        }
        boolean disabled = this.isDisabled(facesContext, inputDate);
        boolean readonly = inputDate.isReadonly();
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        if (!type.equals("time") && !type.equals("short_time")) {
            this.encodeInputDay((UIComponent)inputDate, writer, clientId, userData, disabled, readonly);
            this.encodeInputMonth((UIComponent)inputDate, writer, clientId, userData, currentLocale, disabled, readonly);
            this.encodeInputYear((UIComponent)inputDate, writer, clientId, userData, disabled, readonly);
            if (inputDate.isPopupCalendar() && !disabled && !readonly) {
                this.encodePopupCalendarButton(facesContext, uiComponent, writer, clientId, currentLocale);
            }
        }
        if (type.equals("both") || type.equals("full")) {
            writer.write(" ");
        }
        if (!type.equals("date")) {
            this.encodeInputHours(uiComponent, writer, clientId, userData, disabled, readonly);
            writer.write(":");
            this.encodeInputMinutes(uiComponent, writer, clientId, userData, disabled, readonly);
            if (type.equals("full") || type.equals("time")) {
                writer.write(":");
                this.encodeInputSeconds(uiComponent, writer, clientId, userData, disabled, readonly);
            }
            if (ampm) {
                this.encodeInputAmpm(uiComponent, writer, clientId, userData, disabled, readonly, currentLocale);
            }
        }
        writer.endElement("span");
    }

    protected void encodeInputField(UIComponent uiComponent, ResponseWriter writer, String id, String value, int size, boolean disabled, boolean readonly) throws IOException {
        writer.startElement("input", uiComponent);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.UNIVERSAL_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.EVENT_HANDLER_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_FIELD_EVENT_ATTRIBUTES);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        if (readonly) {
            writer.writeAttribute("readonly", (Object)Boolean.TRUE, null);
        }
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("size", (Object)Integer.toString(size), null);
        writer.writeAttribute("maxlength", (Object)Integer.toString(size), null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.endElement("input");
    }

    protected void encodeInputDay(UIComponent uiComponent, ResponseWriter writer, String clientId, AbstractHtmlInputDate.UserData userData, boolean disabled, boolean readonly) throws IOException {
        this.encodeInputField(uiComponent, writer, HtmlDateRenderer.getClientIdForDaySubcomponent(clientId), userData.getDay(), 2, disabled, readonly);
    }

    protected void encodeInputMonth(UIComponent uiComponent, ResponseWriter writer, String clientId, AbstractHtmlInputDate.UserData userData, Locale currentLocale, boolean disabled, boolean readonly) throws IOException {
        writer.startElement("select", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + ID_MONTH_POSTFIX), null);
        writer.writeAttribute("name", (Object)(clientId + ID_MONTH_POSTFIX), null);
        writer.writeAttribute("size", (Object)"1", null);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.UNIVERSAL_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.EVENT_HANDLER_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_FIELD_EVENT_ATTRIBUTES);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        if (readonly) {
            writer.writeAttribute("readonly", (Object)Boolean.TRUE, null);
        }
        int selectedMonth = userData.getMonth() == null ? -1 : Integer.parseInt(userData.getMonth()) - 1;
        String[] months = HtmlCalendarRenderer.mapMonths(new DateFormatSymbols(currentLocale));
        this.encodeEmptyInputMonthSelection(uiComponent, writer, selectedMonth);
        for (int i = 0; i < months.length; ++i) {
            String monthName = months[i];
            String monthNumber = Integer.toString(i + 1);
            writer.write("\t\t");
            writer.startElement("option", uiComponent);
            writer.writeAttribute("value", (Object)monthNumber, null);
            if (i == selectedMonth) {
                writer.writeAttribute("selected", (Object)"selected", null);
            }
            writer.writeText((Object)monthName, null);
            writer.endElement("option");
        }
        writer.writeText((Object)"", null);
        writer.endElement("select");
    }

    protected void encodeEmptyInputMonthSelection(UIComponent component, ResponseWriter writer, int selectedMonth) throws IOException {
        writer.startElement("option", component);
        writer.writeAttribute("value", (Object)"-1", null);
        if (selectedMonth == -1) {
            writer.writeAttribute("selected", (Object)"selected", null);
        }
        writer.writeText((Object)((HtmlInputDate)component).getEmptyMonthSelection(), null);
        writer.endElement("option");
    }

    protected void encodeInputYear(UIComponent uiComponent, ResponseWriter writer, String clientId, AbstractHtmlInputDate.UserData userData, boolean disabled, boolean readonly) throws IOException {
        this.encodeInputField(uiComponent, writer, clientId + ID_YEAR_POSTFIX, userData.getYear(), 4, disabled, readonly);
    }

    protected void encodeInputHours(UIComponent uiComponent, ResponseWriter writer, String clientId, AbstractHtmlInputDate.UserData userData, boolean disabled, boolean readonly) throws IOException {
        this.encodeInputField(uiComponent, writer, clientId + ID_HOURS_POSTFIX, userData.getHours(), 2, disabled, readonly);
    }

    protected void encodeInputMinutes(UIComponent uiComponent, ResponseWriter writer, String clientId, AbstractHtmlInputDate.UserData userData, boolean disabled, boolean readonly) throws IOException {
        this.encodeInputField(uiComponent, writer, clientId + ID_MINUTES_POSTFIX, userData.getMinutes(), 2, disabled, readonly);
    }

    protected void encodeInputSeconds(UIComponent uiComponent, ResponseWriter writer, String clientId, AbstractHtmlInputDate.UserData userData, boolean disabled, boolean readonly) throws IOException {
        this.encodeInputField(uiComponent, writer, clientId + ID_SECONDS_POSTFIX, userData.getSeconds(), 2, disabled, readonly);
    }

    protected void encodeAmpmChoice(DateFormatSymbols symbols, UIComponent uiComponent, ResponseWriter writer, int calendar_ampm, int selected) throws IOException {
        String[] ampm_choices = symbols.getAmPmStrings();
        writer.write("\t\t");
        writer.startElement("option", uiComponent);
        writer.writeAttribute("value", (Object)new Integer(calendar_ampm), null);
        if (calendar_ampm == selected) {
            writer.writeAttribute("selected", (Object)"selected", null);
        }
        writer.writeText((Object)ampm_choices[calendar_ampm], null);
        writer.endElement("option");
    }

    protected void encodeInputAmpm(UIComponent uiComponent, ResponseWriter writer, String clientId, AbstractHtmlInputDate.UserData userData, boolean disabled, boolean readonly, Locale currentLocale) throws IOException {
        writer.startElement("select", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + ID_AMPM_POSTFIX), null);
        writer.writeAttribute("name", (Object)(clientId + ID_AMPM_POSTFIX), null);
        writer.writeAttribute("size", (Object)"1", null);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.UNIVERSAL_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.EVENT_HANDLER_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_FIELD_EVENT_ATTRIBUTES);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        if (readonly) {
            writer.writeAttribute("readonly", (Object)Boolean.TRUE, null);
        }
        DateFormatSymbols symbols = new DateFormatSymbols(currentLocale);
        int selectedAmpm = userData.getAmpm() == null ? -1 : Integer.parseInt(userData.getAmpm());
        this.encodeEmtypAmpmChoice(uiComponent, writer, selectedAmpm);
        this.encodeAmpmChoice(symbols, uiComponent, writer, 0, selectedAmpm);
        this.encodeAmpmChoice(symbols, uiComponent, writer, 1, selectedAmpm);
        writer.writeText((Object)"", null);
        writer.endElement("select");
    }

    protected void encodeEmtypAmpmChoice(UIComponent component, ResponseWriter writer, int selectedAmpm) throws IOException {
        writer.startElement("option", component);
        writer.writeAttribute("value", (Object)"-1", null);
        if (selectedAmpm == -1) {
            writer.writeAttribute("selected", (Object)"selected", null);
        }
        writer.writeText((Object)((HtmlInputDate)component).getEmptyAmpmSelection(), null);
        writer.endElement("option");
    }

    protected void encodePopupCalendarButton(FacesContext facesContext, UIComponent uiComponent, ResponseWriter writer, String clientId, Locale currentLocale) throws IOException {
        DateFormatSymbols symbols = new DateFormatSymbols(currentLocale);
        HtmlCalendarRenderer.addScriptAndCSSResources(facesContext, uiComponent);
        String calendarVar = JavascriptUtils.getValidJavascriptName(uiComponent.getClientId(facesContext) + "CalendarVar", false);
        String dateFormat = HtmlCalendarRenderer.CalendarDateTimeConverter.createJSPopupFormat(facesContext, null);
        String localizedLanguageScript = HtmlCalendarRenderer.getLocalizedLanguageScript(facesContext, symbols, Calendar.getInstance(currentLocale).getFirstDayOfWeek(), uiComponent, calendarVar);
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)(uiComponent.getClientId(facesContext) + "Span"), "id");
        writer.endElement("span");
        writer.startElement("script", uiComponent);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)("var " + calendarVar + "=new org_apache_myfaces_PopupCalendar();\n"), null);
        writer.write(localizedLanguageScript);
        writer.writeText((Object)(calendarVar + ".init(document.getElementById('" + uiComponent.getClientId(facesContext) + "Span" + "'));\n"), null);
        writer.endElement("script");
        HtmlCalendarRenderer.getScriptBtn(writer, facesContext, uiComponent, dateFormat, "...", new FunctionCallProvider(){

            public String getFunctionCall(FacesContext facesContext, UIComponent uiComponent, String dateFormat) {
                String clientId = uiComponent.getClientId(facesContext);
                String clientVar = JavascriptUtils.getValidJavascriptName(clientId + "CalendarVar", true);
                return clientVar + "._popUpCalendarForInputDate('" + clientId + "','" + dateFormat + "');";
            }
        });
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, HtmlInputDate.class);
        HtmlInputDate inputDate = (HtmlInputDate)uiComponent;
        if (this.isDisabled(facesContext, inputDate)) {
            return;
        }
        if (null != inputDate.getConverter()) {
            String clientId = inputDate.getClientId(facesContext);
            String type = inputDate.getType();
            Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
            StringBuffer submittedValue = new StringBuffer();
            if (!type.equals("time") && !type.equals("short_time")) {
                submittedValue.append("year=");
                submittedValue.append((String)requestMap.get(clientId + ID_YEAR_POSTFIX));
                submittedValue.append("\n");
                submittedValue.append("month=");
                submittedValue.append((String)requestMap.get(clientId + ID_MONTH_POSTFIX));
                submittedValue.append("\n");
                submittedValue.append("day=");
                submittedValue.append((String)requestMap.get(HtmlDateRenderer.getClientIdForDaySubcomponent(clientId)));
                submittedValue.append("\n");
            }
            if (!type.equals("date")) {
                submittedValue.append("hours=");
                submittedValue.append((String)requestMap.get(clientId + ID_HOURS_POSTFIX));
                submittedValue.append("\n");
                submittedValue.append("minutes=");
                submittedValue.append((String)requestMap.get(clientId + ID_MINUTES_POSTFIX));
                submittedValue.append("\n");
                if (type.equals("full") || type.equals("time")) {
                    submittedValue.append("seconds=");
                    submittedValue.append((String)requestMap.get(clientId + ID_SECONDS_POSTFIX));
                    submittedValue.append("\n");
                }
                if (inputDate.isAmpm()) {
                    submittedValue.append("ampm=");
                    submittedValue.append((String)requestMap.get(clientId + ID_AMPM_POSTFIX));
                    submittedValue.append("\n");
                }
            }
            if (submittedValue.charAt(submittedValue.length() - 1) == '\n') {
                submittedValue.deleteCharAt(submittedValue.length() - 1);
            }
            inputDate.setSubmittedValue(submittedValue.toString());
        } else {
            Locale currentLocale = facesContext.getViewRoot().getLocale();
            AbstractHtmlInputDate.UserData userData = (AbstractHtmlInputDate.UserData)inputDate.getSubmittedValue();
            if (userData == null) {
                userData = inputDate.getUserData(currentLocale);
            }
            String clientId = inputDate.getClientId(facesContext);
            String type = inputDate.getType();
            Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
            if (!type.equals("time") && !type.equals("short_time")) {
                userData.setDay((String)requestMap.get(HtmlDateRenderer.getClientIdForDaySubcomponent(clientId)));
                userData.setMonth((String)requestMap.get(clientId + ID_MONTH_POSTFIX));
                userData.setYear((String)requestMap.get(clientId + ID_YEAR_POSTFIX));
            }
            if (!type.equals("date")) {
                userData.setHours((String)requestMap.get(clientId + ID_HOURS_POSTFIX));
                userData.setMinutes((String)requestMap.get(clientId + ID_MINUTES_POSTFIX));
                if (type.equals("full") || type.equals("time")) {
                    userData.setSeconds((String)requestMap.get(clientId + ID_SECONDS_POSTFIX));
                }
                if (inputDate.isAmpm()) {
                    userData.setAmpm((String)requestMap.get(clientId + ID_AMPM_POSTFIX));
                }
            }
            inputDate.setSubmittedValue(userData);
        }
    }

    private DateBusinessConverter getDateBusinessConverter(AbstractHtmlInputDate component) {
        DateBusinessConverter dateBusinessConverter = component.getDateBusinessConverter();
        if (dateBusinessConverter == null) {
            dateBusinessConverter = new DefaultDateBusinessConverter();
        }
        return dateBusinessConverter;
    }

    public Object getConvertedValue(FacesContext context, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        HtmlInputDate inputDate = (HtmlInputDate)uiComponent;
        if (inputDate.getConverter() == null) {
            AbstractHtmlInputDate.UserData userData = (AbstractHtmlInputDate.UserData)submittedValue;
            Date date = null;
            try {
                date = userData.parse();
            }
            catch (ParseException e) {
                Object[] args = new Object[]{uiComponent.getId()};
                throw new ConverterException(MessageUtils.getMessage("org.apache.myfaces.tomahawk.Messages", FacesMessage.SEVERITY_ERROR, DATE_MESSAGE_ID, args, context));
            }
            return this.getDateBusinessConverter(inputDate).getBusinessValue(context, (UIComponent)inputDate, date);
        }
        if (submittedValue != null && !(submittedValue instanceof String)) {
            if (RendererUtils.NOTHING.equals(submittedValue)) {
                return null;
            }
            throw new IllegalArgumentException("Submitted value of type String for component : " + RendererUtils.getPathToComponent((UIComponent)inputDate) + "expected");
        }
        return inputDate.getConverter().getAsObject(context, (UIComponent)inputDate, (String)submittedValue);
    }
}

