/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.inputHtml;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.ext.HtmlInputText;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.util._ComponentUtils;

public class InputHtml
extends HtmlInputText {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.InputHtml";
    public static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.InputHtml";
    private static final Log log = LogFactory.getLog((Class)HtmlInputText.class);
    private String _fallback;
    private String _type;
    private Boolean _allowEditSource;
    private Boolean _allowExternalLinks;
    private Boolean _addKupuLogo;
    private Boolean _showAllToolBoxes;
    private Boolean _showPropertiesToolBox;
    private Boolean _showLinksToolBox;
    private Boolean _showImagesToolBox;
    private Boolean _showTablesToolBox;
    private Boolean _showCleanupExpressionsToolBox;
    private Boolean _showDebugToolBox;

    public InputHtml() {
        this.setRendererType("org.apache.myfaces.InputHtml");
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[4];
        values[0] = super.saveState(context);
        String[] types = new String[]{this._fallback, this._type};
        values[1] = types;
        Boolean[] toolBarButtons = new Boolean[]{this._allowEditSource, this._allowExternalLinks, this._addKupuLogo};
        values[2] = toolBarButtons;
        Boolean[] toolBoxes = new Boolean[]{this._showAllToolBoxes, this._showPropertiesToolBox, this._showLinksToolBox, this._showImagesToolBox, this._showTablesToolBox, this._showCleanupExpressionsToolBox, this._showDebugToolBox};
        values[3] = toolBoxes;
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        String[] types = (String[])values[1];
        this._fallback = types[0];
        this._type = types[1];
        Boolean[] toolBarButtons = (Boolean[])values[2];
        this._allowEditSource = toolBarButtons[0];
        this._allowExternalLinks = toolBarButtons[1];
        this._addKupuLogo = toolBarButtons[2];
        Boolean[] toolBoxes = (Boolean[])values[3];
        this._showAllToolBoxes = toolBoxes[0];
        this._showPropertiesToolBox = toolBoxes[1];
        this._showLinksToolBox = toolBoxes[2];
        this._showImagesToolBox = toolBoxes[3];
        this._showTablesToolBox = toolBoxes[4];
        this._showCleanupExpressionsToolBox = toolBoxes[5];
        this._showDebugToolBox = toolBoxes[6];
    }

    public String getFallback() {
        if (this._fallback != null) {
            return this._fallback;
        }
        ValueBinding vb = this.getValueBinding("fallback");
        return vb != null ? vb.getValue(this.getFacesContext()).toString() : "false";
    }

    public void setFallback(String _fallback) {
        this._fallback = _fallback;
    }

    public String getType() {
        if (this._type != null) {
            return this._type;
        }
        ValueBinding vb = this.getValueBinding("type");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : "fragment";
    }

    public void setType(String _type) {
        this._type = _type;
    }

    public boolean isTypeDocument() {
        return this.getType().equals("document");
    }

    public boolean isAllowEditSource() {
        if (this._allowEditSource != null) {
            return this._allowEditSource;
        }
        ValueBinding vb = this.getValueBinding("allowEditSource");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : true;
    }

    public void setAllowEditSource(boolean allowEditSource) {
        this._allowEditSource = allowEditSource;
    }

    public boolean isAllowExternalLinks() {
        if (this._allowExternalLinks != null) {
            return this._allowExternalLinks;
        }
        ValueBinding vb = this.getValueBinding("allowExternalLinks");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : true;
    }

    public void setAllowExternalLinks(boolean allowExternalLinks) {
        this._allowExternalLinks = allowExternalLinks;
    }

    public boolean isAddKupuLogo() {
        if (this._addKupuLogo != null) {
            return this._addKupuLogo;
        }
        ValueBinding vb = this.getValueBinding("addKupuLogo");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : true;
    }

    public void setAddKupuLogo(boolean addKupuLogo) {
        this._addKupuLogo = addKupuLogo;
    }

    public boolean isShowAllToolBoxes() {
        if (this._showAllToolBoxes != null) {
            return this._showAllToolBoxes;
        }
        ValueBinding vb = this.getValueBinding("showAllToolBoxes");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setShowAllToolBoxes(boolean showAllToolBoxes) {
        this._showAllToolBoxes = showAllToolBoxes;
    }

    public boolean isShowPropertiesToolBox() {
        if (this.isShowAllToolBoxes()) {
            return true;
        }
        if (this._showPropertiesToolBox != null) {
            return this._showPropertiesToolBox;
        }
        ValueBinding vb = this.getValueBinding("showPropertiesToolBox");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setShowPropertiesToolBox(boolean showPropertiesToolBox) {
        this._showPropertiesToolBox = showPropertiesToolBox;
    }

    public boolean isShowLinksToolBox() {
        if (this.isShowAllToolBoxes()) {
            return true;
        }
        if (this._showLinksToolBox != null) {
            return this._showLinksToolBox;
        }
        ValueBinding vb = this.getValueBinding("showLinksToolBox");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setShowLinksToolBox(boolean showLinksToolBox) {
        this._showLinksToolBox = showLinksToolBox;
    }

    public boolean isShowImagesToolBox() {
        if (this.isShowAllToolBoxes()) {
            return true;
        }
        if (this._showImagesToolBox != null) {
            return this._showImagesToolBox;
        }
        ValueBinding vb = this.getValueBinding("showImagesToolBox");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setShowImagesToolBox(boolean showImagesToolBox) {
        this._showImagesToolBox = showImagesToolBox;
    }

    public boolean isShowTablesToolBox() {
        if (this.isShowAllToolBoxes()) {
            return true;
        }
        if (this._showTablesToolBox != null) {
            return this._showTablesToolBox;
        }
        ValueBinding vb = this.getValueBinding("showTablesToolBox");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setShowTablesToolBox(boolean showTablesToolBox) {
        this._showTablesToolBox = showTablesToolBox;
    }

    public boolean isShowCleanupExpressionsToolBox() {
        if (this.isShowAllToolBoxes()) {
            return true;
        }
        if (this._showCleanupExpressionsToolBox != null) {
            return this._showCleanupExpressionsToolBox;
        }
        ValueBinding vb = this.getValueBinding("showCleanupExpressionsToolBox");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setShowCleanupExpressionsToolBox(boolean showCleanupExpressionsToolBox) {
        this._showCleanupExpressionsToolBox = showCleanupExpressionsToolBox;
    }

    public boolean isShowDebugToolBox() {
        if (this.isShowAllToolBoxes()) {
            return true;
        }
        if (this._showDebugToolBox != null) {
            return this._showDebugToolBox;
        }
        ValueBinding vb = this.getValueBinding("showDebugToolBox");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setShowDebugToolBox(boolean showTablesToolBox) {
        this._showDebugToolBox = showTablesToolBox;
    }

    public boolean isShowAnyToolBox() {
        return this.isShowAllToolBoxes() || this.isShowPropertiesToolBox() || this.isShowLinksToolBox() || this.isShowImagesToolBox() || this.isShowTablesToolBox() || this.isShowCleanupExpressionsToolBox() || this.isShowDebugToolBox();
    }

    public String getValueAsHtmlDocument(FacesContext context) {
        String val = RendererUtils.getStringValue(context, (UIComponent)this);
        if (InputHtml.isHtmlDocument(val)) {
            return val;
        }
        return "<html><body>" + (val == null ? "" : val) + "</body></html>";
    }

    private static boolean isHtmlDocument(String text) {
        if (text == null) {
            return false;
        }
        return text.indexOf("<body>") != -1 || text.indexOf("<body ") != -1 || text.indexOf("<BODY>") != -1 || text.indexOf("<BODY ") != -1;
    }

    public String getValueFromDocument(String text) {
        if (text == null) {
            return "";
        }
        if (this.isTypeDocument()) {
            return text.trim();
        }
        if (!InputHtml.isHtmlDocument(text)) {
            return text.trim();
        }
        String fragment = this.getHtmlBody(text);
        if (fragment.endsWith("<br />")) {
            return fragment.substring(0, fragment.length() - 6);
        }
        return fragment;
    }

    String getHtmlBody(String html) {
        if ((html = html.trim()).length() == 0) {
            return "";
        }
        String lcText = html.toLowerCase();
        int textLength = lcText.length();
        int bodyStartIndex = -1;
        while (bodyStartIndex < textLength) {
            char c;
            ++bodyStartIndex;
            if ((bodyStartIndex = lcText.indexOf("<body", bodyStartIndex)) == -1 || (c = lcText.charAt(bodyStartIndex += 5)) == '>') break;
            if (c != ' ' && c != '\t') continue;
            bodyStartIndex = lcText.indexOf(62, bodyStartIndex);
            break;
        }
        int bodyEndIndex = lcText.lastIndexOf("</body>") - 1;
        if (++bodyStartIndex < 0 || bodyEndIndex < 0 || bodyStartIndex > bodyEndIndex || bodyStartIndex >= textLength || bodyEndIndex >= textLength) {
            if (lcText.indexOf("<body/>") != -1 || lcText.indexOf("<body />") != -1) {
                return "";
            }
            int htmlStartIndex = lcText.indexOf("<html>");
            int htmlEndIndex = lcText.indexOf("</html>");
            if (htmlStartIndex != -1 && htmlEndIndex > htmlStartIndex) {
                return html.substring(htmlStartIndex + 6, htmlEndIndex);
            }
            if (this.isTypeDocument()) {
                log.warn((Object)("Couldn't extract HTML body from :\n" + html));
            }
            return html.trim();
        }
        return html.substring(bodyStartIndex, bodyEndIndex + 1).trim();
    }
}

