/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.StateHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;

public class MockValueBinding
extends ValueBinding
implements StateHolder {
    private transient Application application;
    private String ref;
    private boolean transientFlag = false;

    public MockValueBinding() {
        this(null, null);
    }

    public MockValueBinding(Application application, String ref) {
        this.application = application;
        if (ref != null && ref.startsWith("#{") && ref.endsWith("}")) {
            ref = ref.substring(2, ref.length() - 1);
        }
        this.ref = ref;
    }

    public String ref() {
        return this.ref;
    }

    public Object getValue(FacesContext context) throws EvaluationException, PropertyNotFoundException {
        if (context == null) {
            throw new NullPointerException();
        }
        List names = this.parse(this.ref);
        VariableResolver vr = this.application().getVariableResolver();
        String name = (String)names.get(0);
        Object base = vr.resolveVariable(context, name);
        if (names.size() < 2) {
            return base;
        }
        PropertyResolver pr = this.application().getPropertyResolver();
        for (int i = 1; i < names.size(); ++i) {
            base = pr.getValue(base, (Object)((String)names.get(i)));
        }
        return base;
    }

    public void setValue(FacesContext context, Object value) throws EvaluationException, PropertyNotFoundException {
        if (context == null) {
            throw new NullPointerException();
        }
        List names = this.parse(this.ref);
        VariableResolver vr = this.application().getVariableResolver();
        String name = (String)names.get(0);
        Object base = vr.resolveVariable(context, name);
        if (names.size() < 2) {
            if ("applicationScope".equals(name) || "requestScope".equals(name) || "sessionScope".equals(name)) {
                throw new ReferenceSyntaxException("Cannot set '" + name + "'");
            }
            Map map = this.econtext().getRequestMap();
            if (map.containsKey(name)) {
                map.put(name, value);
                return;
            }
            map = this.econtext().getSessionMap();
            if (map != null && map.containsKey(name)) {
                map.put(name, value);
                return;
            }
            map = this.econtext().getApplicationMap();
            if (map.containsKey(name)) {
                map.put(name, value);
                return;
            }
            this.econtext().getRequestMap().put(name, value);
            return;
        }
        PropertyResolver pr = this.application().getPropertyResolver();
        for (int i = 1; i < names.size() - 1; ++i) {
            base = pr.getValue(base, (Object)((String)names.get(i)));
        }
        pr.setValue(base, (Object)((String)names.get(names.size() - 1)), value);
    }

    public boolean isReadOnly(FacesContext context) throws PropertyNotFoundException {
        if (context == null) {
            throw new NullPointerException();
        }
        List names = this.parse(this.ref);
        VariableResolver vr = this.application().getVariableResolver();
        String name = (String)names.get(0);
        Object base = vr.resolveVariable(context, name);
        if (names.size() < 2) {
            return true;
        }
        PropertyResolver pr = this.application().getPropertyResolver();
        for (int i = 1; i < names.size() - 1; ++i) {
            base = pr.getValue(base, (Object)((String)names.get(i)));
        }
        return pr.isReadOnly(base, (Object)((String)names.get(names.size() - 1)));
    }

    public Class getType(FacesContext context) throws PropertyNotFoundException {
        if (context == null) {
            throw new NullPointerException();
        }
        List names = this.parse(this.ref);
        VariableResolver vr = this.application().getVariableResolver();
        String name = (String)names.get(0);
        Object base = vr.resolveVariable(context, name);
        if (names.size() < 2) {
            return base.getClass();
        }
        PropertyResolver pr = this.application().getPropertyResolver();
        for (int i = 1; i < names.size() - 1; ++i) {
            base = pr.getValue(base, (Object)((String)names.get(i)));
        }
        return pr.getType(base, (Object)((String)names.get(names.size() - 1)));
    }

    public String getExpressionString() {
        return "#{" + this.ref + "}";
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.ref};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.ref = (String)values[0];
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    private Application application() {
        if (this.application == null) {
            this.application = FacesContext.getCurrentInstance().getApplication();
        }
        return this.application;
    }

    private ExternalContext econtext() {
        return FacesContext.getCurrentInstance().getExternalContext();
    }

    private List parse(String ref) {
        int i;
        ArrayList<String> names = new ArrayList<String>();
        StringBuffer expr = new StringBuffer(ref);
        boolean isBlockOn = false;
        for (i = expr.length() - 1; i > -1; --i) {
            if (expr.charAt(i) == ' ') {
                expr.deleteCharAt(i);
                continue;
            }
            if (expr.charAt(i) == ']') {
                expr.deleteCharAt(i);
                continue;
            }
            if (expr.charAt(i) == '[') {
                expr.deleteCharAt(i);
                continue;
            }
            if (expr.charAt(i) == '\'') {
                if (!isBlockOn) {
                    expr.deleteCharAt(i);
                } else {
                    names.add(0, expr.substring(i + 1));
                    expr.delete(i, expr.length());
                }
                isBlockOn = !isBlockOn;
                continue;
            }
            if (expr.charAt(i) != '.' || isBlockOn) continue;
            names.add(0, expr.substring(i + 1));
            expr.delete(i, expr.length());
        }
        if (expr.length() > 0) {
            names.add(0, expr.toString());
        }
        if (names.size() < 1) {
            throw new ReferenceSyntaxException("No expression in '" + ref + "'");
        }
        for (i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            if (name.length() >= 1) continue;
            throw new ReferenceSyntaxException("Invalid expression '" + ref + "'");
        }
        return names;
    }
}

