/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.core.ExtValContextInternals;
import org.apache.myfaces.extensions.validator.core.ExtValContextInvocationOrderAwareInternals;
import org.apache.myfaces.extensions.validator.core.ExtValModuleConfiguration;
import org.apache.myfaces.extensions.validator.core.ExtValModuleConfigurationResolver;
import org.apache.myfaces.extensions.validator.core.InformationProviderBean;
import org.apache.myfaces.extensions.validator.core.JsfProjectStage;
import org.apache.myfaces.extensions.validator.core.ValidationModuleKey;
import org.apache.myfaces.extensions.validator.core.factory.DefaultFactoryFinder;
import org.apache.myfaces.extensions.validator.core.factory.FactoryFinder;
import org.apache.myfaces.extensions.validator.core.initializer.component.ComponentInitializer;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfiguration;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfigurationNames;
import org.apache.myfaces.extensions.validator.core.interceptor.MetaDataExtractionInterceptor;
import org.apache.myfaces.extensions.validator.core.interceptor.PropertyValidationInterceptor;
import org.apache.myfaces.extensions.validator.core.interceptor.RendererInterceptor;
import org.apache.myfaces.extensions.validator.core.interceptor.ValidationExceptionInterceptor;
import org.apache.myfaces.extensions.validator.core.interceptor.ViewRootInterceptor;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.recorder.ProcessedInformationRecorder;
import org.apache.myfaces.extensions.validator.core.validation.SkipValidationEvaluator;
import org.apache.myfaces.extensions.validator.core.validation.parameter.ViolationSeverityInterpreter;
import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;
import org.apache.myfaces.extensions.validator.util.WebXmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.API})
public class ExtValContext {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static ExtValContext extValContext;
    private static final String CUSTOM_EXTVAL_CONTEXT_CLASS_NAME;
    private static final String CUSTOM_EXTVAL_MODULE_CONFIGURATION_RESOLVER_CLASS_NAME;
    private ViolationSeverityInterpreter violationSeverityInterpreter;
    private FactoryFinder factoryFinder = DefaultFactoryFinder.getInstance();
    private Map<String, RendererInterceptor> rendererInterceptors = new ConcurrentHashMap<String, RendererInterceptor>();
    private List<String> deniedInterceptors = new CopyOnWriteArrayList<String>();
    private List<ProcessedInformationRecorder> processedInformationRecorders = new CopyOnWriteArrayList<ProcessedInformationRecorder>();
    private SkipValidationEvaluator skipValidationEvaluator;
    private List<RendererInterceptor> rendererInterceptorCache = null;
    private Map<String, Object> globalProperties = new HashMap<String, Object>();
    private Map<Class<? extends ExtValModuleConfiguration>, ExtValModuleConfiguration> extValConfig = new ConcurrentHashMap<Class<? extends ExtValModuleConfiguration>, ExtValModuleConfiguration>();
    private ExtValModuleConfigurationResolver defaultModuleConfigurationResolver;
    private Map<StaticConfigurationNames, List<StaticConfiguration<String, String>>> staticConfigMap = new HashMap<StaticConfigurationNames, List<StaticConfiguration<String, String>>>();
    private ExtValContextInternals contextHelper = new ExtValContextInternals();
    private ExtValContextInvocationOrderAwareInternals invocationOrderAwareContextHelper = new ExtValContextInvocationOrderAwareInternals(this.contextHelper);

    protected ExtValContext() {
        this.retrieveModuleConfigurationResolver();
    }

    private void retrieveModuleConfigurationResolver() {
        String customExtValModuleConfigurationResolverClassName;
        Object customExtValModuleConfigurationResolver = ClassUtils.tryToInstantiateClassForName(CUSTOM_EXTVAL_MODULE_CONFIGURATION_RESOLVER_CLASS_NAME);
        if (customExtValModuleConfigurationResolver instanceof ExtValModuleConfigurationResolver) {
            this.defaultModuleConfigurationResolver = (ExtValModuleConfigurationResolver)customExtValModuleConfigurationResolver;
        }
        if ((customExtValModuleConfigurationResolverClassName = WebXmlUtils.getInitParameter(null, ExtValModuleConfigurationResolver.class.getName())) != null && (customExtValModuleConfigurationResolver = ClassUtils.tryToInstantiateClassForName(customExtValModuleConfigurationResolverClassName)) instanceof ExtValModuleConfigurationResolver) {
            this.defaultModuleConfigurationResolver = (ExtValModuleConfigurationResolver)customExtValModuleConfigurationResolver;
        }
    }

    public static ExtValContext getContext() {
        if (extValContext == null) {
            extValContext = new ExtValContext();
            ExtValContext.tryToCreateCustomExtValContext();
        }
        return extValContext;
    }

    private static void tryToCreateCustomExtValContext() {
        Object customExtValContext = ClassUtils.tryToInstantiateClassForName(CUSTOM_EXTVAL_CONTEXT_CLASS_NAME);
        if (customExtValContext instanceof ExtValContext) {
            extValContext = (ExtValContext)customExtValContext;
        }
    }

    public void setViolationSeverityInterpreter(ViolationSeverityInterpreter violationSeverityInterpreter) {
        this.setViolationSeverityInterpreter(violationSeverityInterpreter, true);
    }

    public void setViolationSeverityInterpreter(ViolationSeverityInterpreter violationSeverityInterpreter, boolean forceOverride) {
        if (this.violationSeverityInterpreter == null || forceOverride) {
            if (violationSeverityInterpreter != null) {
                this.logger.info(violationSeverityInterpreter.getClass() + " is used");
            }
            this.violationSeverityInterpreter = violationSeverityInterpreter;
        }
    }

    public ViolationSeverityInterpreter getViolationSeverityInterpreter() {
        ViolationSeverityInterpreter requestScopedInterpreter = this.contextHelper.getRequestScopedViolationSeverityInterpreter();
        if (requestScopedInterpreter != null) {
            return requestScopedInterpreter;
        }
        return this.violationSeverityInterpreter;
    }

    public FactoryFinder getFactoryFinder() {
        return this.factoryFinder;
    }

    public void setFactoryFinder(FactoryFinder factoryFinder) {
        if (factoryFinder != null) {
            this.factoryFinder = factoryFinder;
        }
    }

    public void setSkipValidationEvaluator(SkipValidationEvaluator skipValidationEvaluator) {
        this.setSkipValidationEvaluator(skipValidationEvaluator, true);
    }

    public void setSkipValidationEvaluator(SkipValidationEvaluator skipValidationEvaluator, boolean forceOverride) {
        if (this.skipValidationEvaluator == null || forceOverride) {
            if (skipValidationEvaluator != null) {
                this.logger.info(skipValidationEvaluator.getClass() + " is used");
            }
            this.skipValidationEvaluator = skipValidationEvaluator;
        }
    }

    public SkipValidationEvaluator getSkipValidationEvaluator() {
        if (this.skipValidationEvaluator == null) {
            return new SkipValidationEvaluator(){

                public boolean skipValidation(FacesContext facesContext, UIComponent uiComponent, ValidationStrategy validationStrategy, MetaDataEntry entry) {
                    return false;
                }
            };
        }
        return this.skipValidationEvaluator;
    }

    public List<RendererInterceptor> getRendererInterceptors() {
        if (this.rendererInterceptorCache == null) {
            this.rendererInterceptorCache = new ArrayList<RendererInterceptor>(this.rendererInterceptors.values());
        }
        return this.rendererInterceptorCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerRendererInterceptor(RendererInterceptor rendererInterceptor) {
        Class<ExtValContext> clazz = ExtValContext.class;
        synchronized (ExtValContext.class) {
            if (this.deniedInterceptors.contains(rendererInterceptor.getInterceptorId())) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            this.rendererInterceptors.put(rendererInterceptor.getInterceptorId(), rendererInterceptor);
            this.rendererInterceptorCache = new ArrayList<RendererInterceptor>(this.rendererInterceptors.values());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterRendererInterceptor(Class<? extends RendererInterceptor> rendererInterceptorClass) {
        RendererInterceptor rendererInterceptor = ClassUtils.tryToInstantiateClass(rendererInterceptorClass);
        Class<ExtValContext> clazz = ExtValContext.class;
        synchronized (ExtValContext.class) {
            this.rendererInterceptors.remove(rendererInterceptor.getInterceptorId());
            this.rendererInterceptorCache = new ArrayList<RendererInterceptor>(this.rendererInterceptors.values());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void denyRendererInterceptor(Class<? extends RendererInterceptor> rendererInterceptorClass) {
        RendererInterceptor rendererInterceptor = ClassUtils.tryToInstantiateClass(rendererInterceptorClass);
        Class<ExtValContext> clazz = ExtValContext.class;
        synchronized (ExtValContext.class) {
            if (!this.deniedInterceptors.contains(rendererInterceptor.getInterceptorId())) {
                this.deniedInterceptors.add(rendererInterceptor.getInterceptorId());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.deregisterRendererInterceptor(rendererInterceptorClass);
            return;
        }
    }

    public void addComponentInitializer(ComponentInitializer componentInitializer) {
        this.invocationOrderAwareContextHelper.lazyInitComponentInitializers();
        this.invocationOrderAwareContextHelper.addComponentInitializer(componentInitializer);
    }

    public List<ComponentInitializer> getComponentInitializers() {
        this.invocationOrderAwareContextHelper.lazyInitComponentInitializers();
        return this.invocationOrderAwareContextHelper.getComponentInitializers();
    }

    public void addValidationExceptionInterceptor(ValidationExceptionInterceptor validationExceptionInterceptor) {
        this.invocationOrderAwareContextHelper.lazyInitValidationExceptionInterceptors();
        this.invocationOrderAwareContextHelper.addValidationExceptionInterceptor(validationExceptionInterceptor);
    }

    public List<ValidationExceptionInterceptor> getValidationExceptionInterceptors() {
        this.invocationOrderAwareContextHelper.lazyInitValidationExceptionInterceptors();
        return this.invocationOrderAwareContextHelper.getValidationExceptionInterceptors();
    }

    public void addPropertyValidationInterceptor(PropertyValidationInterceptor propertyValidationInterceptor) {
        this.invocationOrderAwareContextHelper.lazyInitPropertyValidationInterceptors();
        this.invocationOrderAwareContextHelper.addPropertyValidationInterceptor(propertyValidationInterceptor);
    }

    public List<PropertyValidationInterceptor> getPropertyValidationInterceptors() {
        this.invocationOrderAwareContextHelper.lazyInitPropertyValidationInterceptors();
        return this.invocationOrderAwareContextHelper.getPropertyValidationInterceptors();
    }

    public List<PropertyValidationInterceptor> getPropertyValidationInterceptorsFor(Class moduleKey) {
        this.invocationOrderAwareContextHelper.lazyInitPropertyValidationInterceptors();
        return this.invocationOrderAwareContextHelper.getPropertyValidationInterceptorsFor(moduleKey);
    }

    public void addMetaDataExtractionInterceptor(MetaDataExtractionInterceptor metaDataExtractionInterceptor) {
        this.invocationOrderAwareContextHelper.lazyInitMetaDataExtractionInterceptors();
        this.invocationOrderAwareContextHelper.addMetaDataExtractionInterceptor(metaDataExtractionInterceptor);
    }

    public List<MetaDataExtractionInterceptor> getMetaDataExtractionInterceptors() {
        this.invocationOrderAwareContextHelper.lazyInitMetaDataExtractionInterceptors();
        return this.invocationOrderAwareContextHelper.getMetaDataExtractionInterceptors();
    }

    public List<MetaDataExtractionInterceptor> getMetaDataExtractionInterceptorsFor(Class moduleKey) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (moduleKey != null) {
            properties.put(ValidationModuleKey.class.getName(), moduleKey);
        }
        return this.getMetaDataExtractionInterceptorsWith(properties);
    }

    public List<MetaDataExtractionInterceptor> getMetaDataExtractionInterceptorsWith(Map<String, Object> properties) {
        this.invocationOrderAwareContextHelper.lazyInitMetaDataExtractionInterceptors();
        return this.invocationOrderAwareContextHelper.getMetaDataExtractionInterceptorsWith(properties);
    }

    public List<ProcessedInformationRecorder> getProcessedInformationRecorders() {
        return this.processedInformationRecorders;
    }

    public void addProcessedInformationRecorder(ProcessedInformationRecorder processedInformationRecorder) {
        this.processedInformationRecorders.add(processedInformationRecorder);
    }

    public InformationProviderBean getInformationProviderBean() {
        return this.contextHelper.getInformationProviderBean();
    }

    public List<StaticConfiguration<String, String>> getStaticConfiguration(StaticConfigurationNames name) {
        if (!this.staticConfigMap.containsKey((Object)name)) {
            ArrayList staticConfigList = new ArrayList();
            this.staticConfigMap.put(name, staticConfigList);
        }
        return this.staticConfigMap.get((Object)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStaticConfiguration(StaticConfigurationNames name, StaticConfiguration<String, String> staticConfig) {
        ExtValContext extValContext = this;
        synchronized (extValContext) {
            if (!this.staticConfigMap.containsKey((Object)name)) {
                ArrayList staticConfigList = new ArrayList();
                this.staticConfigMap.put(name, staticConfigList);
            }
            this.staticConfigMap.get((Object)name).add(staticConfig);
        }
    }

    public boolean addGlobalProperty(String name, Object value) {
        return this.addGlobalProperty(name, value, true);
    }

    public boolean addGlobalProperty(String name, Object value, boolean forceOverride) {
        if (this.globalProperties.containsKey(name)) {
            if (!forceOverride) {
                return false;
            }
            this.logger.info("override global property '" + name + "'");
        }
        if (JsfProjectStage.is(JsfProjectStage.Development)) {
            this.logger.info("global property [" + name + "] added");
        }
        this.globalProperties.put(name, value);
        return true;
    }

    public Object getGlobalProperty(String name) {
        return this.globalProperties.get(name);
    }

    public void addViewRootInterceptor(ViewRootInterceptor viewRootInterceptor) {
        this.invocationOrderAwareContextHelper.lazyInitViewRootInterceptors();
        this.invocationOrderAwareContextHelper.addViewRootInterceptor(viewRootInterceptor);
    }

    public List<ViewRootInterceptor> getViewRootInterceptors() {
        this.invocationOrderAwareContextHelper.lazyInitViewRootInterceptors();
        return this.invocationOrderAwareContextHelper.getViewRootInterceptors();
    }

    public <T extends ExtValModuleConfiguration> T getModuleConfiguration(Class<T> targetType) {
        ExtValModuleConfiguration result = this.extValConfig.get(targetType);
        return (T)result;
    }

    public boolean addModuleConfiguration(Class<? extends ExtValModuleConfiguration> key, ExtValModuleConfiguration extValConfig) {
        return this.addModuleConfiguration(key, extValConfig, true);
    }

    public boolean addModuleConfiguration(Class<? extends ExtValModuleConfiguration> key, ExtValModuleConfiguration config, boolean forceOverride) {
        if (this.extValConfig.containsKey(key)) {
            if (!forceOverride) {
                return false;
            }
            this.logger.info("override config for key '" + config.getClass() + "'");
        }
        if (!config.getClass().isAnonymousClass()) {
            config = this.tryToLoadCustomConfigImplementation(config);
        }
        this.extValConfig.put(key, config);
        if (JsfProjectStage.is(JsfProjectStage.Development)) {
            this.logger.info("config for key [" + config.getClass() + "] added");
        }
        return true;
    }

    private ExtValModuleConfiguration tryToLoadCustomConfigImplementation(ExtValModuleConfiguration config) {
        Object customConfig;
        String customConfigClassName;
        Class<?> configClass = config.getClass().getSuperclass();
        if (!ExtValModuleConfiguration.class.isAssignableFrom(configClass)) {
            return config;
        }
        Class<?> configDefinitionClass = configClass;
        if (this.defaultModuleConfigurationResolver != null) {
            config = this.defaultModuleConfigurationResolver.getCustomConfiguration(configDefinitionClass);
        }
        if ((customConfigClassName = WebXmlUtils.getInitParameter(null, configDefinitionClass.getName())) != null && (customConfig = ClassUtils.tryToInstantiateClassForName(customConfigClassName)) instanceof ExtValModuleConfiguration) {
            return (ExtValModuleConfiguration)customConfig;
        }
        return config;
    }

    static {
        CUSTOM_EXTVAL_CONTEXT_CLASS_NAME = ExtValContext.class.getName().replace(".core.", ".custom.");
        CUSTOM_EXTVAL_MODULE_CONFIGURATION_RESOLVER_CLASS_NAME = ExtValModuleConfigurationResolver.class.getName().replace(".core.", ".custom.");
    }
}

