/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.validation.strategy;

import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.logging.Level;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.validation.message.resolver.MessageResolver;
import org.apache.myfaces.extensions.validator.core.validation.strategy.AbstractValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL, UsageCategory.REUSE})
public abstract class AbstractAnnotationValidationStrategy<A extends Annotation>
extends AbstractValidationStrategy {
    protected static final String DETAIL_MESSAGE_KEY_POSTFIX = "_detail";
    private MessageResolver messageResolver;

    protected String resolveMessage(String key) {
        Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        return this.messageResolver != null ? this.messageResolver.getMessage(key, locale) : ExtValUtils.getMessageResolverForValidationStrategy(this).getMessage(key, locale);
    }

    protected String getErrorMessageSummary(A annotation) {
        return this.resolveMessage(this.getValidationErrorMsgKey(annotation));
    }

    @ToDo(value=Priority.MEDIUM, description="just log it in case of project stage development")
    protected String getErrorMessageDetail(A annotation) {
        try {
            String key = this.getValidationErrorMsgKey(annotation);
            return key != null ? this.resolveMessage(key + DETAIL_MESSAGE_KEY_POSTFIX) : null;
        }
        catch (MissingResourceException e) {
            this.logger.log(Level.WARNING, "couldn't find key " + this.getValidationErrorMsgKey(annotation) + DETAIL_MESSAGE_KEY_POSTFIX, e);
            return null;
        }
    }

    protected FacesMessage getValidationErrorFacesMessage(A annotation) {
        return ExtValUtils.createFacesMessage(this.getErrorMessageSummary(annotation), this.getErrorMessageDetail(annotation));
    }

    protected abstract String getValidationErrorMsgKey(A var1);

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    @Override
    protected boolean processAfterValidatorException(FacesContext facesContext, UIComponent uiComponent, MetaDataEntry metaDataEntry, Object convertedObject, ValidatorException validatorException) {
        metaDataEntry.setProperty("label", this.getLabel(facesContext, uiComponent, metaDataEntry));
        return super.processAfterValidatorException(facesContext, uiComponent, metaDataEntry, convertedObject, validatorException);
    }

    protected String getLabel(FacesContext facesContext, UIComponent uiComponent, MetaDataEntry metaDataEntry) {
        return null;
    }
}

