/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core;

import java.util.Map;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.ExtValInformation;
import org.apache.myfaces.extensions.validator.core.CustomInformation;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.NullValueAwareConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.API, UsageCategory.CUSTOMIZABLE})
public class InformationProviderBean {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String BEAN_NAME = ExtValInformation.EXTENSIONS_VALIDATOR_BASE_PACKAGE_NAME + "." + InformationProviderBean.class.getSimpleName();
    public static final String CUSTOM_BEAN = ExtValInformation.EXTENSIONS_VALIDATOR_BASE_PACKAGE_NAME + ".custom." + InformationProviderBean.class.getSimpleName();
    private Map<CustomInformation, String> customizableInfos = new NullValueAwareConcurrentHashMap<CustomInformation, String>(String.class);

    public InformationProviderBean() {
        this.logger.fine(this.getClass().getName() + " instantiated");
        this.setupCustomizableInformation();
        this.applyCustomValues(this.customizableInfos);
    }

    private void setupCustomizableInformation() {
        String basePackage = ExtValCoreConfiguration.get().customBasePackage();
        if (basePackage == null) {
            basePackage = ExtValInformation.EXTENSIONS_VALIDATOR_BASE_PACKAGE_NAME + ".custom.";
        }
        if (!basePackage.endsWith(".")) {
            basePackage = basePackage + ".";
        }
        this.customizableInfos.put(CustomInformation.BASE_PACKAGE, basePackage);
        this.customizableInfos.put(CustomInformation.COMPONENT_META_DATA_EXTRACTOR, "ComponentMetaDataExtractor");
        this.customizableInfos.put(CustomInformation.VALIDATION_PARAMETER_EXTRACTOR, "ValidationParameterExtractor");
        this.customizableInfos.put(CustomInformation.VALIDATION_STRATEGY_POSTFIX, "ValidationStrategy");
        this.customizableInfos.put(CustomInformation.META_DATA_TRANSFORMER_POSTFIX, "MetaDataTransformer");
        this.customizableInfos.put(CustomInformation.VALIDATION_ERROR_MESSAGE_RESOLVER_POSTFIX, "ValidationErrorMessageResolver");
        this.customizableInfos.put(CustomInformation.COMPONENT_INITIALIZER, "ComponentInitializer");
        this.customizableInfos.put(CustomInformation.VALIDATION_EXCEPTION_INTERCEPTOR, "ValidationExceptionInterceptor");
        this.customizableInfos.put(CustomInformation.PROPERTY_VALIDATION_INTERCEPTOR, "PropertyValidationInterceptor");
        this.customizableInfos.put(CustomInformation.META_DATA_EXTRACTION_INTERCEPTOR, "MetaDataExtractionInterceptor");
        this.customizableInfos.put(CustomInformation.VALIDATION_STRATEGY_TO_MSG_RESOLVER_NAME_MAPPER, "ValidationStrategyToMsgResolverNameMapper");
        this.customizableInfos.put(CustomInformation.META_DATA_TO_VALIDATION_STRATEGY_NAME_MAPPER, "MetaDataToValidationStrategyNameMapper");
        this.customizableInfos.put(CustomInformation.VALIDATION_STRATEGY_TO_META_DATA_TRANSFORMER_NAME_MAPPER, "ValidationStrategyToMetaDataTransformerNameMapper");
        this.customizableInfos.put(CustomInformation.STARTUP_LISTENER, "StartupListener");
        this.customizableInfos.put(CustomInformation.MESSAGE_RESOLVER_FACTORY, "MessageResolverFactory");
        this.customizableInfos.put(CustomInformation.VALIDATION_STRATEGY_FACTORY, "ValidationStrategyFactory");
        this.customizableInfos.put(CustomInformation.COMPONENT_META_DATA_EXTRACTOR_FACTORY, "ComponentMetaDataExtractorFactory");
        this.customizableInfos.put(CustomInformation.VALIDATION_PARAMETER_EXTRACTOR_FACTORY, "ValidationParameterExtractorFactory");
        this.customizableInfos.put(CustomInformation.VALIDATION_PARAMETER_FACTORY, "ValidationParameterFactory");
        this.customizableInfos.put(CustomInformation.META_DATA_TRANSFORMER_FACTORY, "MetaDataTransformerFactory");
        this.customizableInfos.put(CustomInformation.FACES_MESSAGE_FACTORY, "FacesMessageFactory");
        this.customizableInfos.put(CustomInformation.STORAGE_MANAGER_FACTORY, "StorageManagerFactory");
        this.customizableInfos.put(CustomInformation.MESSAGE_BUNDLE_NAME, "validation_messages");
        this.customizableInfos.put(CustomInformation.STATIC_STRATEGY_MAPPING_SOURCE, "strategy_mappings");
        this.customizableInfos.put(CustomInformation.META_DATA_STORAGE_FILTER, "MetaDataStorageFilter");
    }

    protected void applyCustomValues(Map<CustomInformation, String> map) {
    }

    public final String get(CustomInformation customInformation) {
        String value = this.customizableInfos.get((Object)customInformation);
        switch (customInformation) {
            case BASE_PACKAGE: {
                return value;
            }
            case VALIDATION_STRATEGY_POSTFIX: {
                return value;
            }
            case VALIDATION_ERROR_MESSAGE_RESOLVER_POSTFIX: {
                return value;
            }
            case META_DATA_TRANSFORMER_POSTFIX: {
                return value;
            }
        }
        return this.customizableInfos.get((Object)CustomInformation.BASE_PACKAGE) + value;
    }
}

