/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.trinidad.initializer.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.core.InvocationOrder;
import org.apache.myfaces.extensions.validator.core.initializer.component.ComponentInitializer;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.trinidad.initializer.component.DoubleRangeInitializer;
import org.apache.myfaces.extensions.validator.trinidad.initializer.component.LengthInitializer;
import org.apache.myfaces.extensions.validator.trinidad.initializer.component.LongRangeInitializer;
import org.apache.myfaces.extensions.validator.trinidad.initializer.component.PatternInitializer;
import org.apache.myfaces.extensions.validator.trinidad.initializer.component.RequiredInitializer;
import org.apache.myfaces.extensions.validator.trinidad.storage.TrinidadClientValidatorStorage;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.trinidad.context.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InvocationOrder(value=300)
@UsageInformation(value={UsageCategory.INTERNAL})
public class TrinidadComponentInitializer
implements ComponentInitializer {
    private static final String TRINIDAD_CORE_INPUT_TEXT = "org.apache.myfaces.trinidad.component.core.input.CoreInputText";
    private static final String TRINIDAD_CORE_INPUT_DATE = "org.apache.myfaces.trinidad.component.core.input.CoreInputDate";
    private static List<TrinidadComponentInitializer> componentInitializers = new ArrayList<TrinidadComponentInitializer>();

    @ToDo(value=Priority.LOW, description="check ppr issue")
    public final void configureComponent(FacesContext facesContext, UIComponent uiComponent, Map<String, Object> metaData) {
        TrinidadClientValidatorStorage storage = (TrinidadClientValidatorStorage)ExtValUtils.getStorage(TrinidadClientValidatorStorage.class, (String)TrinidadClientValidatorStorage.class.getName());
        for (TrinidadComponentInitializer componentInitializer : componentInitializers) {
            if (!componentInitializer.configureTrinidadComponent(facesContext, uiComponent, metaData)) continue;
            storage.addComponent(uiComponent);
            this.updateComponent(facesContext, uiComponent);
        }
    }

    protected boolean configureTrinidadComponent(FacesContext facesContext, UIComponent uiComponent, Map<String, Object> metaData) {
        return false;
    }

    protected boolean processComponent(UIComponent uiComponent) {
        return TRINIDAD_CORE_INPUT_TEXT.equals(uiComponent.getClass().getName()) || TRINIDAD_CORE_INPUT_DATE.equals(uiComponent.getClass().getName());
    }

    private void updateComponent(FacesContext facesContext, UIComponent uiComponent) {
        if (RequestContext.getCurrentInstance().isPartialRequest(facesContext)) {
            RequestContext.getCurrentInstance().addPartialTarget(uiComponent.getParent());
        }
    }

    static {
        componentInitializers.add(new RequiredInitializer());
        componentInitializers.add(new LengthInitializer());
        componentInitializers.add(new LongRangeInitializer());
        componentInitializers.add(new DoubleRangeInitializer());
        componentInitializers.add(new PatternInitializer());
    }
}

