/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.application;

import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import java.io.IOException;

public abstract class StateManager {
    public static final String STATE_SAVING_METHOD_PARAM_NAME = "jakarta.faces.STATE_SAVING_METHOD";
    public static final String STATE_SAVING_METHOD_CLIENT = "client";
    public static final String STATE_SAVING_METHOD_SERVER = "server";
    public static final String FULL_STATE_SAVING_VIEW_IDS_PARAM_NAME = "jakarta.faces.FULL_STATE_SAVING_VIEW_IDS";
    public static final String PARTIAL_STATE_SAVING_PARAM_NAME = "jakarta.faces.PARTIAL_STATE_SAVING";
    private Boolean _savingStateInClient = null;
    public static final String IS_BUILDING_INITIAL_STATE = "jakarta.faces.IS_BUILDING_INITIAL_STATE";
    public static final String IS_SAVING_STATE = "jakarta.faces.IS_SAVING_STATE";
    public static final String SERIALIZE_SERVER_STATE_PARAM_NAME = "jakarta.faces.SERIALIZE_SERVER_STATE";

    @Deprecated
    public SerializedView saveSerializedView(FacesContext context) {
        Object[] structureAndState;
        Object savedView = this.saveView(context);
        if (savedView != null && savedView instanceof Object[] && (structureAndState = (Object[])savedView).length == 2) {
            return new SerializedView(structureAndState[0], structureAndState[1]);
        }
        return null;
    }

    @Deprecated
    public Object saveView(FacesContext context) {
        SerializedView serializedView = this.saveSerializedView(context);
        if (serializedView == null) {
            return null;
        }
        Object[] structureAndState = new Object[]{serializedView.getStructure(), serializedView.getState()};
        return structureAndState;
    }

    @Deprecated
    protected Object getTreeStructureToSave(FacesContext context) {
        return null;
    }

    @Deprecated
    protected Object getComponentStateToSave(FacesContext context) {
        return null;
    }

    @Deprecated
    public void writeState(FacesContext context, SerializedView state) throws IOException {
        if (state != null) {
            this.writeState(context, new Object[]{state.getStructure(), state.getState()});
        }
    }

    public void writeState(FacesContext context, Object state) throws IOException {
        if (!(state instanceof Object[])) {
            return;
        }
        Object[] structureAndState = (Object[])state;
        if (structureAndState.length < 2) {
            return;
        }
        this.writeState(context, new SerializedView(structureAndState[0], structureAndState[1]));
    }

    public String getViewState(FacesContext context) {
        return context.getRenderKit().getResponseStateManager().getViewState(context, this.saveView(context));
    }

    @Deprecated
    public abstract UIViewRoot restoreView(FacesContext var1, String var2, String var3);

    @Deprecated
    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        return null;
    }

    @Deprecated
    protected void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
    }

    public boolean isSavingStateInClient(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this._savingStateInClient != null) {
            return this._savingStateInClient;
        }
        String stateSavingMethod = context.getExternalContext().getInitParameter(STATE_SAVING_METHOD_PARAM_NAME);
        if (stateSavingMethod == null) {
            this._savingStateInClient = Boolean.FALSE;
            context.getExternalContext().log("No state saving method defined, assuming default server state saving");
        } else if (stateSavingMethod.equalsIgnoreCase(STATE_SAVING_METHOD_CLIENT)) {
            this._savingStateInClient = Boolean.TRUE;
        } else if (stateSavingMethod.equalsIgnoreCase(STATE_SAVING_METHOD_SERVER)) {
            this._savingStateInClient = Boolean.FALSE;
        } else {
            this._savingStateInClient = Boolean.FALSE;
            context.getExternalContext().log("Illegal state saving method '" + stateSavingMethod + "', default server state saving will be used");
        }
        return this._savingStateInClient;
    }

    @Deprecated
    public class SerializedView {
        private Object _structure;
        private Object _state;

        public SerializedView(Object structure, Object state) {
            this._structure = structure;
            this._state = state;
        }

        public Object getStructure() {
            return this._structure;
        }

        public Object getState() {
            return this._state;
        }
    }
}

