/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.validator;

import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;

public class MethodExpressionValidator
implements Validator,
StateHolder {
    private MethodExpression methodExpression;
    private boolean isTransient = false;

    public MethodExpressionValidator() {
    }

    public MethodExpressionValidator(MethodExpression methodExpression) {
        if (methodExpression == null) {
            throw new NullPointerException("methodExpression can not be null.");
        }
        this.methodExpression = methodExpression;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        Object[] params = new Object[]{context, component, value};
        try {
            this.methodExpression.invoke(context.getELContext(), params);
        }
        catch (ELException e) {
            Throwable cause = e.getCause();
            ValidatorException vex = null;
            if (cause != null) {
                do {
                    if (cause == null || !(cause instanceof ValidatorException)) continue;
                    vex = (ValidatorException)cause;
                    break;
                } while ((cause = cause.getCause()) != null);
            }
            if (vex != null) {
                throw vex;
            }
            throw e;
        }
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.methodExpression = (MethodExpression)state;
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return this.methodExpression;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }
}

