/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.ldap;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.naming.NamingException;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.ldap.LdapAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class LdapPublickeyAuthenticator
extends LdapAuthenticator
implements PublickeyAuthenticator {
    public static final String DEFAULT_SEARCH_FILTER_PATTERN = "uid={0}";
    public static final String DEFAULT_PUBKEY_ATTR_NAME = "sshPublicKey";
    private String keyAttributeName = "sshPublicKey";

    public LdapPublickeyAuthenticator() {
        this.setSearchFilterPattern(DEFAULT_SEARCH_FILTER_PATTERN);
        this.setRetrievedAttributes(DEFAULT_PUBKEY_ATTR_NAME);
        this.setAccumulateMultiValues(true);
    }

    public String getKeyAttributeName() {
        return this.keyAttributeName;
    }

    public void setKeyAttributeName(String keyAttributeName) {
        this.keyAttributeName = ValidateUtils.checkNotNullAndNotEmpty((String)keyAttributeName, (String)"No attribute name");
    }

    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        try {
            Map<String, Object> attrs = this.resolveAttributes(username, null, session);
            return this.authenticate(username, key, session, attrs);
        }
        catch (IOException | RuntimeException | GeneralSecurityException | NamingException e) {
            this.warn("authenticate({}@{}) failed ({}) to query: {}", username, session, e.getClass().getSimpleName(), e.getMessage(), e);
            return false;
        }
    }

    protected boolean authenticate(String username, PublicKey expected, ServerSession session, Map<String, ?> attrs) throws GeneralSecurityException, IOException {
        String attrName = this.getKeyAttributeName();
        List<PublicKey> keys = this.recoverPublicKeys(username, expected, session, attrs, attrs.get(attrName));
        return this.authenticate(username, expected, session, attrs, keys);
    }

    protected boolean authenticate(String username, PublicKey expected, ServerSession session, Map<String, ?> attrs, Collection<? extends PublicKey> keys) {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (GenericUtils.isEmpty(keys)) {
            if (debugEnabled) {
                this.log.debug("authenticate({}@{}) no registered keys", (Object)username, (Object)session);
            }
            return false;
        }
        if (debugEnabled) {
            this.log.debug("authenticate({}@{}) check {} registered keys", new Object[]{username, session, keys.size()});
        }
        boolean traceEnabled = this.log.isTraceEnabled();
        for (PublicKey publicKey : keys) {
            if (traceEnabled) {
                this.log.trace("authenticate({}@{}) expected={}-{}, actual={}-{}", new Object[]{username, session, KeyUtils.getKeyType((Key)expected), KeyUtils.getFingerPrint((PublicKey)expected), KeyUtils.getKeyType((Key)publicKey), KeyUtils.getFingerPrint((PublicKey)publicKey)});
            }
            if (!KeyUtils.compareKeys((PublicKey)expected, (PublicKey)publicKey)) continue;
            return true;
        }
        if (debugEnabled) {
            this.log.debug("authenticate({}@{}) no matching keys", (Object)username, (Object)session);
        }
        return false;
    }

    protected List<PublicKey> recoverPublicKeys(String username, PublicKey expected, ServerSession session, Map<String, ?> attrs, Object keyData) throws GeneralSecurityException, IOException {
        if (keyData instanceof Collection) {
            Collection values = (Collection)keyData;
            ArrayList<PublicKey> keys = new ArrayList<PublicKey>(values.size());
            for (Object v : values) {
                PublicKey k = this.parsePublicKeyValue(username, expected, session, attrs, v);
                if (k == null) continue;
                keys.add(k);
            }
            return keys;
        }
        PublicKey k = this.parsePublicKeyValue(username, expected, session, attrs, keyData);
        return k == null ? Collections.emptyList() : Collections.singletonList(k);
    }

    protected PublicKey parsePublicKeyValue(String username, PublicKey expected, ServerSession session, Map<String, ?> attrs, Object keyData) throws GeneralSecurityException, IOException {
        if (keyData == null) {
            return null;
        }
        AuthorizedKeyEntry entry = AuthorizedKeyEntry.parseAuthorizedKeyEntry((String)Objects.toString(keyData, null));
        PublicKey key = Objects.requireNonNull(entry, "No key extracted").resolvePublicKey((SessionContext)session, PublicKeyEntryResolver.FAILING);
        if (this.log.isTraceEnabled()) {
            this.log.trace("parsePublicKeyValue({}@{}) {}-{}", new Object[]{username, session, KeyUtils.getKeyType((Key)key), KeyUtils.getFingerPrint((PublicKey)key)});
        }
        return key;
    }
}

