/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.filesystem.nativefs.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.usermanager.impl.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeFtpFile
implements FtpFile {
    private final Logger LOG = LoggerFactory.getLogger(NativeFtpFile.class);
    private final String fileName;
    private final File file;
    private final User user;

    protected NativeFtpFile(String fileName, File file, User user) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName can not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file can not be null");
        }
        if (fileName.length() == 0) {
            throw new IllegalArgumentException("fileName can not be empty");
        }
        if (fileName.charAt(0) != '/') {
            throw new IllegalArgumentException("fileName must be an absolut path");
        }
        this.fileName = fileName;
        this.file = file;
        this.user = user;
    }

    public String getAbsolutePath() {
        String fullName = this.fileName;
        int filelen = fullName.length();
        if (filelen != 1 && fullName.charAt(filelen - 1) == '/') {
            fullName = fullName.substring(0, filelen - 1);
        }
        return fullName;
    }

    public String getName() {
        int slashIndex;
        if (this.fileName.equals("/")) {
            return "/";
        }
        String shortName = this.fileName;
        int filelen = this.fileName.length();
        if (shortName.charAt(filelen - 1) == '/') {
            shortName = shortName.substring(0, filelen - 1);
        }
        if ((slashIndex = shortName.lastIndexOf(47)) != -1) {
            shortName = shortName.substring(slashIndex + 1);
        }
        return shortName;
    }

    public boolean isHidden() {
        return this.file.isHidden();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public boolean doesExist() {
        return this.file.exists();
    }

    public long getSize() {
        return this.file.length();
    }

    public String getOwnerName() {
        return "user";
    }

    public String getGroupName() {
        return "group";
    }

    public int getLinkCount() {
        return this.file.isDirectory() ? 3 : 1;
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public boolean setLastModified(long time) {
        return this.file.setLastModified(time);
    }

    public boolean isReadable() {
        return this.file.canRead();
    }

    public boolean isWritable() {
        this.LOG.debug("Checking authorization for " + this.getAbsolutePath());
        if (this.user.authorize((AuthorizationRequest)new WriteRequest(this.getAbsolutePath())) == null) {
            this.LOG.debug("Not authorized");
            return false;
        }
        this.LOG.debug("Checking if file exists");
        if (this.file.exists()) {
            this.LOG.debug("Checking can write: " + this.file.canWrite());
            return this.file.canWrite();
        }
        this.LOG.debug("Authorized");
        return true;
    }

    public boolean isRemovable() {
        if ("/".equals(this.fileName)) {
            return false;
        }
        String fullName = this.getAbsolutePath();
        if (this.user.authorize((AuthorizationRequest)new WriteRequest(fullName)) == null) {
            return false;
        }
        int indexOfSlash = fullName.lastIndexOf(47);
        String parentFullName = indexOfSlash == 0 ? "/" : fullName.substring(0, indexOfSlash);
        NativeFtpFile parentObject = new NativeFtpFile(parentFullName, this.file.getAbsoluteFile().getParentFile(), this.user);
        return parentObject.isWritable();
    }

    public boolean delete() {
        boolean retVal = false;
        if (this.isRemovable()) {
            retVal = this.file.delete();
        }
        return retVal;
    }

    public boolean move(FtpFile dest) {
        boolean retVal = false;
        if (dest.isWritable() && this.isReadable()) {
            File destFile = ((NativeFtpFile)dest).file;
            retVal = destFile.exists() ? false : this.file.renameTo(destFile);
        }
        return retVal;
    }

    public boolean mkdir() {
        boolean retVal = false;
        if (this.isWritable()) {
            retVal = this.file.mkdir();
        }
        return retVal;
    }

    public File getPhysicalFile() {
        return this.file;
    }

    public List<FtpFile> listFiles() {
        if (!this.file.isDirectory()) {
            return null;
        }
        File[] files = this.file.listFiles();
        if (files == null) {
            return null;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        String virtualFileStr = this.getAbsolutePath();
        if (virtualFileStr.charAt(virtualFileStr.length() - 1) != '/') {
            virtualFileStr = virtualFileStr + '/';
        }
        FtpFile[] virtualFiles = new FtpFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            File fileObj = files[i];
            String fileName = virtualFileStr + fileObj.getName();
            virtualFiles[i] = new NativeFtpFile(fileName, fileObj, this.user);
        }
        return Collections.unmodifiableList(Arrays.asList(virtualFiles));
    }

    public OutputStream createOutputStream(long offset) throws IOException {
        if (!this.isWritable()) {
            throw new IOException("No write permission : " + this.file.getName());
        }
        final RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        raf.setLength(offset);
        raf.seek(offset);
        return new FileOutputStream(raf.getFD()){

            @Override
            public void close() throws IOException {
                super.close();
                raf.close();
            }
        };
    }

    public InputStream createInputStream(long offset) throws IOException {
        if (!this.isReadable()) {
            throw new IOException("No read permission : " + this.file.getName());
        }
        final RandomAccessFile raf = new RandomAccessFile(this.file, "r");
        raf.seek(offset);
        return new FileInputStream(raf.getFD()){

            @Override
            public void close() throws IOException {
                super.close();
                raf.close();
            }
        };
    }

    public boolean equals(Object obj) {
        if (obj instanceof NativeFtpFile) {
            String otherCanonicalPath;
            String thisCanonicalPath;
            try {
                thisCanonicalPath = this.file.getCanonicalPath();
                otherCanonicalPath = ((NativeFtpFile)obj).file.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get the canonical path", e);
            }
            return thisCanonicalPath.equals(otherCanonicalPath);
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.file.getCanonicalPath().hashCode();
        }
        catch (IOException e) {
            return 0;
        }
    }
}

