/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.coverage.j2d.ColorsForRange;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.ScaledColorSpace;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public final class Colorizer {
    public static final ColorModel NULL_COLOR_MODEL = null;
    private static final int MAX_VALUE = 255;
    public static final int TYPE_COMPACT = 0;
    public static final Function<Category, Color[]> GRAYSCALE = category -> {
        Color[] colorArray;
        if (category.isQuantitative()) {
            Color[] colorArray2 = new Color[2];
            colorArray2[0] = Color.BLACK;
            colorArray = colorArray2;
            colorArray2[1] = Color.WHITE;
        } else {
            colorArray = null;
        }
        return colorArray;
    };
    public static final Function<Category, Color[]> BELL = category -> {
        Color[] colorArray;
        if (category.isQuantitative()) {
            Color[] colorArray2 = new Color[5];
            colorArray2[0] = Color.BLUE;
            colorArray2[1] = Color.CYAN;
            colorArray2[2] = Color.WHITE;
            colorArray2[3] = Color.YELLOW;
            colorArray = colorArray2;
            colorArray2[4] = Color.RED;
        } else {
            colorArray = null;
        }
        return colorArray;
    };
    private final Function<Category, Color[]> colors;
    private ColorsForRange[] entries;
    private SampleDimension source;
    private SampleDimension target;

    public Colorizer(Collection<Map.Entry<NumberRange<?>, Color[]>> collection) {
        ArgumentChecks.ensureNonNull("colors", collection);
        this.entries = ColorsForRange.list(collection);
        this.colors = null;
    }

    public Colorizer(Function<Category, Color[]> function) {
        this.colors = function != null ? function : GRAYSCALE;
    }

    private void checkInitializationStatus(boolean bl) {
        if (this.entries != null != bl) {
            throw new IllegalStateException(Errors.format(bl ? (short)189 : 188, this.getClass()));
        }
    }

    private static boolean isAlreadyScaled(NumberRange<?> numberRange) {
        return numberRange.getMinDouble(true) == 0.0 && numberRange.getMaxDouble(true) == 255.0;
    }

    public boolean initialize(SampleDimension sampleDimension) {
        this.checkInitializationStatus(false);
        if (sampleDimension != null) {
            this.source = sampleDimension;
            List<Category> list = sampleDimension.getCategories();
            if (!list.isEmpty()) {
                this.entries = new ColorsForRange[list.size()];
                for (int i = 0; i < this.entries.length; ++i) {
                    Category category = list.get(i);
                    this.entries[i] = new ColorsForRange(category, category.getSampleRange(), this.colors.apply(category));
                }
                return true;
            }
        }
        return false;
    }

    public boolean initialize(SampleModel sampleModel, int n) {
        this.checkInitializationStatus(false);
        if (ImageUtilities.isIntegerType(sampleModel)) {
            long l = 0L;
            long l2 = Numerics.bitmask(sampleModel.getSampleSize(n)) - 1L;
            if (!ImageUtilities.isUnsignedType(sampleModel)) {
                l = (l2 >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            this.initialize(l, l2);
            return true;
        }
        return false;
    }

    public boolean initialize(ColorModel colorModel) {
        ColorSpace colorSpace;
        this.checkInitializationStatus(false);
        if (colorModel != null && (colorSpace = colorModel.getColorSpace()) instanceof ScaledColorSpace) {
            ScaledColorSpace scaledColorSpace = (ScaledColorSpace)colorSpace;
            this.initialize(scaledColorSpace.offset, scaledColorSpace.maximum);
            return true;
        }
        return false;
    }

    public void initialize(double d, double d2) {
        this.checkInitializationStatus(false);
        ArgumentChecks.ensureFinite("minimum", d);
        ArgumentChecks.ensureFinite("maximum", d2);
        this.target = new SampleDimension.Builder().mapQualitative(null, 0, Float.NaN).addQuantitative((CharSequence)Vocabulary.formatInternational((short)47), NumberRange.create(1, true, 255, true), NumberRange.create(d, true, d2, true)).build();
        this.source = this.target.forConvertedValues(true);
        List<Category> list = this.source.getCategories();
        this.entries = new ColorsForRange[list.size()];
        for (int i = 0; i < this.entries.length; ++i) {
            Category category = list.get(i);
            this.entries[i] = new ColorsForRange(category, category.forConvertedValues(false).getSampleRange(), this.colors.apply(category));
        }
    }

    public void rescaleMainRange(ColorModel colorModel) {
        ColorSpace colorSpace;
        this.checkInitializationStatus(true);
        if (colorModel != null && (colorSpace = colorModel.getColorSpace()) instanceof ScaledColorSpace) {
            ScaledColorSpace scaledColorSpace = (ScaledColorSpace)colorSpace;
            double d = scaledColorSpace.offset;
            double d2 = scaledColorSpace.maximum;
            ColorsForRange colorsForRange = null;
            double d3 = 0.0;
            for (ColorsForRange colorsForRange2 : this.entries) {
                double d4 = Math.min(colorsForRange2.sampleRange.getMaxDouble(), d2) - Math.max(colorsForRange2.sampleRange.getMinDouble(), d);
                if (!(d4 > d3)) continue;
                d3 = d4;
                colorsForRange = colorsForRange2;
            }
            if (colorsForRange != null && d3 != colorsForRange.sampleRange.getSpan()) {
                colorsForRange.sampleRange = NumberRange.create(d, true, d2, false);
                this.target = null;
            }
        }
    }

    private void compact() {
        int n;
        block18: {
            if (this.target != null) {
                return;
            }
            if (this.source != null) {
                this.target = this.source.forConvertedValues(false);
                if (this.target.getSampleRange().filter(Colorizer::isAlreadyScaled).isPresent()) {
                    int n2;
                    if (this.target == this.source) {
                        return;
                    }
                    HashMap hashMap = new HashMap();
                    for (Category category : this.target.getCategories()) {
                        if (hashMap.put(category.forConvertedValues(true).getSampleRange(), category.getSampleRange()) == null) continue;
                        break block18;
                    }
                    NumberRange[] numberRangeArray = new NumberRange[this.entries.length];
                    for (n2 = 0; n2 < this.entries.length; ++n2) {
                        numberRangeArray[n2] = (NumberRange)hashMap.remove(this.entries[n2].sampleRange);
                        if (numberRangeArray[n2] != null) {
                            continue;
                        }
                        break block18;
                    }
                    for (n2 = 0; n2 < this.entries.length; ++n2) {
                        this.entries[n2].sampleRange = numberRangeArray[n2];
                    }
                    return;
                }
            }
        }
        Arrays.sort(this.entries);
        double d = 0.0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.entries.length;
        HashMap<NumberRange<Integer>, ColorsForRange> hashMap = new HashMap<NumberRange<Integer>, ColorsForRange>();
        SampleDimension.Builder builder = new SampleDimension.Builder();
        for (n = 0; n < n5; ++n) {
            ColorsForRange colorsForRange = this.entries[n];
            double d2 = colorsForRange.sampleRange.getSpan();
            if (Double.isNaN(d2)) {
                NumberRange<Integer> object2;
                if (n3 >= 255) {
                    throw new IllegalArgumentException(Resources.format((short)62));
                }
                if (hashMap.put(object2 = NumberRange.create(n3++, true, n3, false), colorsForRange) != null) continue;
                builder.mapQualitative(colorsForRange.name(), object2, (float)d2);
                continue;
            }
            if (d2 > 0.0) {
                d += d2;
                System.arraycopy(this.entries, n4, this.entries, n4 + 1, n - n4);
                this.entries[n4++] = colorsForRange;
                continue;
            }
            System.arraycopy(this.entries, n + 1, this.entries, n, --n5 - n);
            this.entries[n5] = null;
        }
        n = n3;
        double d3 = (double)(256 - n) / d;
        d = 0.0;
        for (int i = 0; i < n4; ++i) {
            ColorsForRange colorsForRange = this.entries[i];
            if (colorsForRange == null) continue;
            int n2 = Math.toIntExact(Math.round((d += colorsForRange.sampleRange.getSpan()) * d3) + (long)n);
            if (n2 <= n3) {
                throw new IllegalArgumentException(Resources.format((short)62));
            }
            NumberRange<Integer> numberRange = NumberRange.create(n3, true, n2, false);
            if (hashMap.put(numberRange, colorsForRange) == null) {
                builder.addQuantitative(colorsForRange.name(), numberRange, colorsForRange.sampleRange);
            }
            n3 = n2;
        }
        if (this.source != null) {
            builder.setName(this.source.getName());
        } else {
            builder.setName(Vocabulary.format((short)221));
        }
        this.target = builder.build();
        for (Category category : this.target.getCategories()) {
            NumberRange<?> numberRange = category.getSampleRange();
            ((ColorsForRange)hashMap.get(numberRange)).sampleRange = numberRange;
        }
    }

    public ColorModel createColorModel(int n, int n2, int n3) {
        this.checkInitializationStatus(true);
        ArgumentChecks.ensureStrictlyPositive("numBands", n2);
        ArgumentChecks.ensureBetween("visibleBand", 0, n2 - 1, n3);
        return ColorModelFactory.createPiecewise(n, n2, n3, this.entries);
    }

    public ColorModel compactColorModel(int n, int n2) {
        this.checkInitializationStatus(true);
        this.compact();
        return this.createColorModel(0, n, n2);
    }

    public MathTransform1D getSampleToIndexValues() throws NoninvertibleTransformException {
        this.checkInitializationStatus(true);
        return this.target != null ? this.target.getTransferFunction().orElseGet(Colorizer::identity).inverse() : Colorizer.identity();
    }

    private static MathTransform1D identity() {
        return (MathTransform1D)MathTransforms.identity((int)1);
    }
}

