/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.iosp.IndexChunker;
import ucar.nc2.iosp.Layout;

public class LayoutRegular
implements Layout {
    private IndexChunker chunker;
    private long startPos;
    private int elemSize;

    public LayoutRegular(long startPos, int elemSize, int[] varShape, Section wantSection) throws InvalidRangeException {
        assert (startPos >= 0L);
        assert (elemSize > 0);
        this.startPos = startPos;
        this.elemSize = elemSize;
        this.chunker = new IndexChunker(varShape, wantSection);
    }

    @Override
    public long getTotalNelems() {
        return this.chunker.getTotalNelems();
    }

    @Override
    public int getElemSize() {
        return this.elemSize;
    }

    @Override
    public boolean hasNext() {
        return this.chunker.hasNext();
    }

    @Override
    public Layout.Chunk next() {
        IndexChunker.Chunk chunk = this.chunker.next();
        chunk.setSrcPos(this.startPos + chunk.getSrcElem() * (long)this.elemSize);
        return chunk;
    }
}

