/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler;

import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class DefineRepositoryConnection {
    public static final String _rcsid = "@(#)$Id: DefineRepositoryConnection.java 988245 2010-08-23 18:39:35Z kwright $";

    private DefineRepositoryConnection() {
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            System.err.println("Usage: DefineRepositoryConnection <connection_name> <description> <connector_class> <authority_name> <pool_max> <param1>=<value1> ...");
            System.exit(1);
        }
        String connectionName = args[0];
        String description = args[1];
        String connectorClass = args[2];
        String authorityName = args[3];
        String poolMax = args[4];
        try {
            IThreadContext tc = ThreadContextFactory.make();
            ManifoldCF.initializeEnvironment(tc);
            IRepositoryConnectionManager mgr = RepositoryConnectionManagerFactory.make(tc);
            IRepositoryConnection conn = mgr.create();
            conn.setName(connectionName);
            conn.setDescription(description);
            conn.setClassName(connectorClass);
            if (authorityName.length() > 0) {
                conn.setACLAuthority(authorityName);
            }
            conn.setMaxConnections(new Integer(poolMax));
            ConfigParams x = conn.getConfigParams();
            int i = 5;
            while (i < args.length) {
                String arg;
                int pos;
                if ((pos = (arg = args[i++]).indexOf("=")) == -1) {
                    throw new ManifoldCFException("Argument missing =");
                }
                String name = arg.substring(0, pos);
                String value = arg.substring(pos + 1);
                if (name.endsWith("assword")) {
                    x.setObfuscatedParameter(name, value);
                    continue;
                }
                x.setParameter(name, value);
            }
            mgr.save(conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

