/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.api.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;

public final class ProfileUtil {
    private static final String SPRING_PROFILE = "spring.profiles.active";

    private ProfileUtil() {
    }

    public static void setActiveProfile(ServletContext servletContext) {
        Properties props;
        String activeProfile;
        String springProfile = System.getProperty(SPRING_PROFILE);
        if (springProfile == null) {
            springProfile = System.getenv(SPRING_PROFILE);
        }
        if (springProfile == null) {
            springProfile = servletContext.getInitParameter(SPRING_PROFILE);
        }
        if (springProfile == null && (activeProfile = (props = ProfileUtil.loadProperties(servletContext)).getProperty(SPRING_PROFILE)) == null) {
            servletContext.setInitParameter(SPRING_PROFILE, "eclipseLink");
        }
    }

    private static Properties loadProperties(ServletContext servletContext) {
        Properties props = new Properties();
        String env = System.getProperty("env");
        if (env == null) {
            env = System.getenv("env");
        }
        StringBuilder sb = new StringBuilder("catalog-");
        if (env != null) {
            sb.append(env);
        }
        sb.append("config.properties");
        InputStream is = ProfileUtil.class.getClassLoader().getResourceAsStream(sb.toString());
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException ioe) {
                servletContext.log("Unable to load " + sb.toString() + ": " + ioe.getMessage());
            }
        }
        return props;
    }
}

