/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.converter;

import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.api.Attribute;
import org.apache.logging.log4j.catalog.api.Constraint;
import org.apache.logging.log4j.catalog.jpa.model.AttributeModel;
import org.apache.logging.log4j.catalog.jpa.model.ConstraintModel;
import org.apache.logging.log4j.catalog.jpa.service.AttributeService;
import org.apache.logging.log4j.util.Supplier;
import org.modelmapper.AbstractConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttributeConverter
extends AbstractConverter<Attribute, AttributeModel> {
    private static Logger LOGGER = LogManager.getLogger(AttributeConverter.class);
    @Autowired
    private AttributeService attributeService;

    public AttributeModel convert(Attribute attribute) {
        LOGGER.traceEntry(attribute.getName(), new Supplier[0]);
        AttributeModel model = attribute.getId() != null ? this.attributeService.getAttribute(attribute.getId()).orElseGet(AttributeModel::new) : new AttributeModel();
        model.setName(attribute.getName());
        model.setAliases(attribute.getAliases());
        model.setDescription(attribute.getDescription());
        model.setDisplayName(attribute.getDisplayName());
        model.setDataType(attribute.getDataType());
        model.setId(attribute.getId());
        model.setCatalogId(attribute.getCatalogId());
        model.setIndexed(attribute.isIndexed());
        model.setRequestContext(attribute.isRequestContext());
        model.setRequired(attribute.isRequired());
        model.setSortable(attribute.isSortable());
        model.setExamples(attribute.getExamples());
        HashSet<ConstraintModel> constraintModels = model.getConstraints() != null ? model.getConstraints() : new HashSet<ConstraintModel>();
        Map constraintMap = constraintModels.stream().collect(Collectors.toMap(ConstraintModel::getId, Function.identity()));
        if (attribute.getConstraints() != null) {
            constraintModels.removeIf(a -> attribute.getConstraints().stream().noneMatch(b -> b.getId().equals(a.getId())));
            for (Constraint constraint : attribute.getConstraints()) {
                ConstraintModel constraintModel;
                if (constraint.getId() != null) {
                    constraintModel = (ConstraintModel)constraintMap.get(constraint.getId());
                    constraintModel.setConstraintType(constraint.getConstraintType().getName());
                    constraintModel.setValue(constraint.getValue());
                    continue;
                }
                constraintModel = new ConstraintModel();
                constraintModel.setConstraintType(constraint.getConstraintType().getName());
                constraintModel.setValue(constraint.getValue());
                constraintModels.add(constraintModel);
            }
        }
        model.setConstraints(constraintModels);
        return (AttributeModel)LOGGER.traceExit((Object)model);
    }
}

