/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.apache.log4j.chainsaw.JSortTable;
import org.apache.log4j.chainsaw.SortArrowIcon;

public class SortHeaderRenderer
extends DefaultTableCellRenderer {
    public static final Icon NONSORTED = new SortArrowIcon(0);
    public static final Icon ASCENDING = new SortArrowIcon(2);
    public static final Icon DECENDING = new SortArrowIcon(1);

    public SortHeaderRenderer() {
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        JTableHeader header;
        int index = -1;
        boolean ascending = true;
        if (table instanceof JSortTable) {
            JSortTable sortTable = (JSortTable)table;
            index = sortTable.getSortedColumnIndex();
            ascending = sortTable.isSortedColumnAscending();
        }
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            Font font = header.getFont();
            if (col == index) {
                this.setFont(new Font(font.getName(), 1, font.getSize()));
            } else {
                this.setFont(font);
            }
        }
        Icon icon = ascending ? ASCENDING : DECENDING;
        this.setIcon(col == index ? icon : NONSORTED);
        this.setText(value == null ? "" : value.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }
}

