/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.chainsaw.CommonActions;
import org.apache.log4j.chainsaw.CopyEventsToClipboardAction;
import org.apache.log4j.chainsaw.ExpressionRuleContext;
import org.apache.log4j.chainsaw.FileMenu;
import org.apache.log4j.chainsaw.JTextComponentFormatter;
import org.apache.log4j.chainsaw.LogPanel;
import org.apache.log4j.chainsaw.LogUI;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.SmallToggleButton;
import org.apache.log4j.chainsaw.filter.FilterModel;
import org.apache.log4j.chainsaw.help.HelpManager;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.osx.OSXIntegration;
import org.apache.log4j.chainsaw.receivers.ReceiversHelper;

class ChainsawToolBarAndMenus
implements ChangeListener {
    private final SmallToggleButton showReceiversButton;
    private final Action changeModelAction;
    private final Action clearAction;
    private final Action toggleWelcomeVisibleAction;
    private final Action findPreviousColorizedEventAction;
    private final Action findNextColorizedEventAction;
    private final Action findNextMarkerAction;
    private final Action findPreviousMarkerAction;
    private final Action toggleMarkerAction;
    private final Action clearAllMarkersAction;
    private final Action pauseAction;
    private final Action showPreferencesAction;
    private final Action showColorPanelAction;
    private final Action showReceiversAction;
    private final Action toggleLogTreeAction;
    private final Action toggleScrollToBottomAction;
    private final Action scrollToTopAction;
    private final Action toggleDetailPaneAction;
    private final Action toggleToolbarAction;
    private final Action undockAction;
    private final Action customExpressionPanelAction;
    private final Collection lookAndFeelMenus = new ArrayList();
    private final JCheckBoxMenuItem toggleShowReceiversCheck = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem toggleLogTreeMenuItem = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem toggleScrollToBottomMenuItem = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem toggleDetailMenuItem = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem toggleCyclicMenuItem = new JCheckBoxMenuItem();
    private final FileMenu fileMenu;
    private final JCheckBoxMenuItem toggleStatusBarCheck = new JCheckBoxMenuItem();
    private final JMenu viewMenu = new JMenu("View");
    private final JMenuBar menuBar;
    private final JCheckBoxMenuItem menuShowWelcome = new JCheckBoxMenuItem();
    private final JToolBar toolbar;
    private final LogUI logui;
    private final SmallButton clearButton = new SmallButton();
    private final SmallToggleButton detailPaneButton = new SmallToggleButton();
    private final SmallToggleButton logTreePaneButton = new SmallToggleButton();
    private final SmallToggleButton scrollToBottomButton = new SmallToggleButton();
    private final SmallToggleButton pauseButton = new SmallToggleButton();
    private final SmallToggleButton toggleCyclicButton = new SmallToggleButton();
    private final Action[] logPanelSpecificActions;
    private final JMenu activeTabMenu = new JMenu("Current tab");

    ChainsawToolBarAndMenus(LogUI logui) {
        this.logui = logui;
        this.toolbar = new JToolBar(0);
        this.menuBar = new JMenuBar();
        this.fileMenu = new FileMenu(logui);
        this.toggleWelcomeVisibleAction = this.toggleWelcomeVisibleAction();
        this.changeModelAction = this.createChangeModelAction();
        this.findNextMarkerAction = this.createFindNextMarkerAction();
        this.findPreviousColorizedEventAction = this.getFindPreviousColorizedEventAction();
        this.findNextColorizedEventAction = this.getFindNextColorizedEventAction();
        this.findPreviousMarkerAction = this.createFindPreviousMarkerAction();
        this.toggleMarkerAction = this.createToggleMarkerAction();
        this.clearAllMarkersAction = this.createClearAllMarkersAction();
        this.customExpressionPanelAction = this.createCustomExpressionPanelAction();
        this.showPreferencesAction = this.createShowPreferencesAction();
        this.showColorPanelAction = this.createShowColorPanelAction();
        this.toggleToolbarAction = this.createToggleToolbarAction();
        this.toggleLogTreeAction = this.createToggleLogTreeAction();
        this.toggleScrollToBottomAction = this.createScrollToBottomAction();
        this.scrollToTopAction = this.createScrollToTopAction();
        this.pauseAction = this.createPauseAction();
        this.clearAction = this.createClearAction();
        this.undockAction = this.createUndockAction();
        this.showReceiversAction = this.createShowReceiversAction();
        this.showReceiversButton = new SmallToggleButton(this.showReceiversAction);
        this.toggleDetailPaneAction = this.createToggleDetailPaneAction();
        this.createMenuBar();
        this.createToolbar();
        this.logPanelSpecificActions = new Action[]{this.pauseAction, this.findNextColorizedEventAction, this.findPreviousColorizedEventAction, this.findNextMarkerAction, this.findPreviousMarkerAction, this.toggleMarkerAction, this.clearAllMarkersAction, this.scrollToTopAction, this.clearAction, this.fileMenu.getFileSaveAction(), this.toggleDetailPaneAction, this.showPreferencesAction, this.showColorPanelAction, this.undockAction, this.toggleLogTreeAction, this.toggleScrollToBottomAction, this.changeModelAction};
        logui.getApplicationPreferenceModel().addPropertyChangeListener("statusBar", evt -> {
            boolean value = (Boolean)evt.getNewValue();
            this.toggleStatusBarCheck.setSelected(value);
        });
        logui.getApplicationPreferenceModel().addPropertyChangeListener("receivers", evt -> {
            boolean value = (Boolean)evt.getNewValue();
            this.showReceiversButton.setSelected(value);
            this.toggleShowReceiversCheck.setSelected(value);
        });
    }

    private Action createChangeModelAction() {
        AbstractAction action = new AbstractAction("Use Cyclic", new ImageIcon(ChainsawIcons.REFRESH)){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                logPanel.toggleCyclic();
                ChainsawToolBarAndMenus.this.scanState();
            }
        };
        action.putValue("ShortDescription", "Changes between Cyclic and Unlimited mode.");
        return action;
    }

    private Action createToggleLogTreeAction() {
        AbstractAction action = new AbstractAction("Toggle the Logger Tree Pane"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().toggleLogTreeVisible();
                }
            }
        };
        action.putValue("ShortDescription", "Toggles the Logger Tree Pane");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", 84);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.WINDOW_ICON));
        return action;
    }

    private Action createScrollToBottomAction() {
        AbstractAction action = new AbstractAction("Toggle Scroll to Bottom"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().toggleScrollToBottom();
                }
            }
        };
        action.putValue("ShortDescription", "Toggles Scroll to Bottom");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", 66);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.SCROLL_TO_BOTTOM));
        return action;
    }

    private Action createScrollToTopAction() {
        AbstractAction action = new AbstractAction("Scroll to top"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().scrollToTop();
                }
            }
        };
        action.putValue("ShortDescription", "Scroll to top");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", 84);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        return action;
    }

    private Action createFindNextMarkerAction() {
        AbstractAction action = new AbstractAction("Find next marker"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().findNextMarker();
                }
            }
        };
        action.putValue("ShortDescription", "Find the next marker from the current location");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", 78);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F2"));
        return action;
    }

    private Action createFindPreviousMarkerAction() {
        AbstractAction action = new AbstractAction("Find previous marker"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().findPreviousMarker();
                }
            }
        };
        action.putValue("ShortDescription", "Find the previous marker from the current location");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", 80);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 1));
        return action;
    }

    private Action createToggleMarkerAction() {
        AbstractAction action = new AbstractAction("Toggle marker"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().toggleMarker();
                }
            }
        };
        action.putValue("ShortDescription", "Toggle marker for selected row");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", 84);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        return action;
    }

    private Action createClearAllMarkersAction() {
        AbstractAction action = new AbstractAction("Clear all markers"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().clearAllMarkers();
                }
            }
        };
        action.putValue("ShortDescription", "Removes all markers");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", 82);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        return action;
    }

    public void stateChange() {
        this.scanState();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.scanState();
    }

    JMenuBar getMenubar() {
        return this.menuBar;
    }

    JToolBar getToolbar() {
        return this.toolbar;
    }

    private Action createClearAction() {
        AbstractAction action = new AbstractAction("Clear"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel == null) {
                    return;
                }
                logPanel.clearEvents();
            }
        };
        action.putValue("MnemonicKey", 67);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        action.putValue("ShortDescription", "Removes all the events from the current view");
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.DELETE));
        return action;
    }

    private Action toggleWelcomeVisibleAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChainsawToolBarAndMenus.this.toggleWelcomeVisibleAction.putValue("Name", "Welcome tab");
                if (ChainsawToolBarAndMenus.this.menuShowWelcome.isSelected()) {
                    ChainsawToolBarAndMenus.this.logui.addWelcomePanel();
                } else {
                    ChainsawToolBarAndMenus.this.logui.removeWelcomePanel();
                }
            }
        };
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F1"));
        action.putValue("ShortDescription", "Toggles the Welcome tab");
        action.putValue("MnemonicKey", 67);
        action.putValue("Name", "Welcome tab");
        return action;
    }

    private void createMenuBar() {
        JMenuItem menuItemUseRightMouse = new JMenuItem("Other options available via panel's right mouse button popup menu");
        menuItemUseRightMouse.setEnabled(false);
        this.viewMenu.setMnemonic('V');
        JCheckBoxMenuItem showToolbarCheck = new JCheckBoxMenuItem(this.toggleToolbarAction);
        showToolbarCheck.setSelected(this.logui.getApplicationPreferenceModel().isToolbar());
        this.logui.getApplicationPreferenceModel().addPropertyChangeListener("toolbar", evt -> {
            boolean value = (Boolean)evt.getNewValue();
            showToolbarCheck.setSelected(value);
        });
        this.menuShowWelcome.setAction(this.toggleWelcomeVisibleAction);
        JCheckBoxMenuItem pause = new JCheckBoxMenuItem(this.pauseAction);
        JMenuItem menuPrefs = new JMenuItem(this.showPreferencesAction);
        menuPrefs.setText(this.showPreferencesAction.getValue("ShortDescription").toString());
        JMenuItem menuCustomExpressionPanel = new JMenuItem(this.customExpressionPanelAction);
        menuCustomExpressionPanel.setText(this.customExpressionPanelAction.getValue("ShortDescription").toString());
        JMenuItem menuShowColor = new JMenuItem(this.showColorPanelAction);
        menuShowColor.setText(this.showColorPanelAction.getValue("ShortDescription").toString());
        JMenuItem menuUndock = new JMenuItem(this.undockAction);
        JMenuItem showAppPrefs = new JMenuItem("Show Application-wide Preferences...");
        showAppPrefs.addActionListener(e -> this.logui.showApplicationPreferences());
        this.toggleDetailMenuItem.setAction(this.toggleDetailPaneAction);
        this.toggleDetailMenuItem.setSelected(true);
        this.toggleCyclicMenuItem.setAction(this.changeModelAction);
        this.toggleCyclicMenuItem.setSelected(true);
        this.toggleLogTreeMenuItem.setAction(this.toggleLogTreeAction);
        this.toggleLogTreeMenuItem.setSelected(true);
        this.toggleScrollToBottomMenuItem.setAction(this.toggleScrollToBottomAction);
        AbstractAction toggleStatusBarAction = new AbstractAction("Show Status bar"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ChainsawToolBarAndMenus.this.logui.getApplicationPreferenceModel().setStatusBar(ChainsawToolBarAndMenus.this.toggleStatusBarCheck.isSelected());
            }
        };
        toggleStatusBarAction.putValue("MnemonicKey", 66);
        this.toggleStatusBarCheck.setAction(toggleStatusBarAction);
        this.toggleStatusBarCheck.setSelected(this.logui.getApplicationPreferenceModel().isStatusBar());
        this.activeTabMenu.add(pause);
        this.activeTabMenu.add(this.toggleCyclicMenuItem);
        this.activeTabMenu.addSeparator();
        this.activeTabMenu.add(this.toggleDetailMenuItem);
        this.activeTabMenu.add(this.toggleLogTreeMenuItem);
        this.activeTabMenu.addSeparator();
        this.activeTabMenu.add(menuUndock);
        this.activeTabMenu.add(menuShowColor);
        this.activeTabMenu.add(menuPrefs);
        this.activeTabMenu.addSeparator();
        this.activeTabMenu.add(new CopyEventsToClipboardAction(this.logui));
        this.activeTabMenu.add(new JMenuItem(this.clearAction));
        this.activeTabMenu.addSeparator();
        this.activeTabMenu.add(new JMenuItem(this.toggleMarkerAction));
        this.activeTabMenu.add(new JMenuItem(this.findNextMarkerAction));
        this.activeTabMenu.add(new JMenuItem(this.findPreviousMarkerAction));
        this.activeTabMenu.add(new JMenuItem(this.clearAllMarkersAction));
        this.activeTabMenu.add(new JMenuItem(this.findNextColorizedEventAction));
        this.activeTabMenu.add(new JMenuItem(this.findPreviousColorizedEventAction));
        this.activeTabMenu.addSeparator();
        this.activeTabMenu.add(new JMenuItem(this.scrollToTopAction));
        this.activeTabMenu.add(this.toggleScrollToBottomMenuItem);
        this.activeTabMenu.add(menuItemUseRightMouse);
        this.viewMenu.add(showToolbarCheck);
        this.viewMenu.add(this.toggleStatusBarCheck);
        this.viewMenu.add(this.toggleShowReceiversCheck);
        this.viewMenu.add(this.menuShowWelcome);
        this.viewMenu.addSeparator();
        this.viewMenu.add(menuCustomExpressionPanel);
        if (!OSXIntegration.IS_OSX) {
            this.viewMenu.addSeparator();
            this.viewMenu.add(showAppPrefs);
        }
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        JMenuItem about = new JMenuItem("About Chainsaw v2...");
        about.setMnemonic('A');
        about.addActionListener(e -> this.logui.showAboutBox());
        AbstractAction startTutorial = new AbstractAction("Tutorial...", new ImageIcon(ChainsawIcons.HELP)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChainsawToolBarAndMenus.this.logui.setupTutorial();
            }
        };
        startTutorial.putValue("ShortDescription", "Starts the tutorial process");
        helpMenu.add(startTutorial);
        List knownReceivers = ReceiversHelper.getInstance().getKnownReceiverClasses();
        JMenu receiverHelp = new JMenu("Receiver JavaDoc");
        for (Object knownReceiver : knownReceivers) {
            final Class clazz = (Class)knownReceiver;
            receiverHelp.add(new AbstractAction(clazz.getName()){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    HelpManager.getInstance().showHelpForClass(clazz);
                }
            });
        }
        helpMenu.add(receiverHelp);
        helpMenu.addSeparator();
        helpMenu.add(CommonActions.getInstance().getShowReleaseNotes());
        helpMenu.add(about);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.activeTabMenu);
        this.menuBar.add(helpMenu);
    }

    private Action createPauseAction() {
        AbstractAction action = new AbstractAction("Pause"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel == null) {
                    return;
                }
                logPanel.setPaused(!logPanel.isPaused());
                ChainsawToolBarAndMenus.this.scanState();
            }
        };
        action.putValue("MnemonicKey", 80);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F12"));
        action.putValue("ShortDescription", "Causes incoming events for this tab to be discarded");
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.PAUSE));
        return action;
    }

    private Action createShowPreferencesAction() {
        AbstractAction showPreferences = new AbstractAction("", ChainsawIcons.ICON_PREFERENCES){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel != null) {
                    logPanel.showPreferences();
                }
            }
        };
        showPreferences.putValue("ShortDescription", "Tab Preferences...");
        return showPreferences;
    }

    private Action createCustomExpressionPanelAction() {
        final JDialog dialog = new JDialog(this.logui, "Define tab", true);
        dialog.getContentPane().add(this.getCustomExpressionPanel());
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        AbstractAction createExpressionPanel = new AbstractAction("", ChainsawIcons.ICON_HELP){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LogPanel.centerAndSetVisible(dialog);
            }
        };
        createExpressionPanel.putValue("ShortDescription", "Create tab from expression...   ");
        return createExpressionPanel;
    }

    private Action createShowColorPanelAction() {
        AbstractAction showColorPanel = new AbstractAction("", ChainsawIcons.ICON_PREFERENCES){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel != null) {
                    logPanel.showColorPreferences();
                }
            }
        };
        showColorPanel.putValue("ShortDescription", "Color settings...");
        return showColorPanel;
    }

    private Action createShowReceiversAction() {
        AbstractAction action = new AbstractAction("Show Receivers"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ChainsawToolBarAndMenus.this.logui.getApplicationPreferenceModel().setReceivers(!ChainsawToolBarAndMenus.this.logui.getApplicationPreferenceModel().isReceivers());
            }
        };
        action.putValue("MnemonicKey", 69);
        action.putValue("ShortDescription", "Shows the currently configured Log4j Receivers");
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F6"));
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ANIM_NET_CONNECT));
        this.toggleShowReceiversCheck.setAction(action);
        return action;
    }

    private Action createToggleDetailPaneAction() {
        AbstractAction action = new AbstractAction("Show Detail Pane"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel == null) {
                    return;
                }
                logPanel.toggleDetailVisible();
            }
        };
        action.putValue("MnemonicKey", 68);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        action.putValue("ShortDescription", "Hides/Shows the Detail Pane");
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.INFO));
        return action;
    }

    private Action createToggleToolbarAction() {
        AbstractAction action = new AbstractAction("Show Toolbar"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChainsawToolBarAndMenus.this.logui.getApplicationPreferenceModel().setToolbar(!ChainsawToolBarAndMenus.this.logui.getApplicationPreferenceModel().isToolbar());
            }
        };
        action.putValue("MnemonicKey", 84);
        return action;
    }

    private void createToolbar() {
        Insets buttonMargins = new Insets(1, 1, 1, 1);
        FileMenu menu = (FileMenu)this.menuBar.getMenu(0);
        SmallButton fileOpenButton = new SmallButton(menu.getLog4JFileOpenAction());
        fileOpenButton.setMargin(buttonMargins);
        SmallButton fileSaveButton = new SmallButton(menu.getFileSaveAction());
        fileSaveButton.setMargin(buttonMargins);
        fileOpenButton.setText("");
        fileSaveButton.setText("");
        this.toolbar.add(fileOpenButton);
        this.toolbar.add(fileSaveButton);
        this.toolbar.addSeparator();
        this.pauseButton.setAction(this.pauseAction);
        this.pauseButton.setText("");
        this.pauseButton.getActionMap().put(this.pauseAction.getValue("Name"), this.pauseAction);
        this.toggleCyclicButton.setAction(this.changeModelAction);
        this.toggleCyclicButton.setText(null);
        this.detailPaneButton.setAction(this.toggleDetailPaneAction);
        this.detailPaneButton.setText(null);
        this.detailPaneButton.getActionMap().put(this.toggleDetailPaneAction.getValue("Name"), this.toggleDetailPaneAction);
        this.detailPaneButton.getInputMap(1).put(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), this.toggleDetailPaneAction.getValue("Name"));
        this.logTreePaneButton.setAction(this.toggleLogTreeAction);
        this.logTreePaneButton.getActionMap().put(this.toggleLogTreeAction.getValue("Name"), this.toggleLogTreeAction);
        this.logTreePaneButton.getInputMap(1).put(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), this.toggleLogTreeAction.getValue("Name"));
        this.logTreePaneButton.setText(null);
        this.scrollToBottomButton.setAction(this.toggleScrollToBottomAction);
        this.scrollToBottomButton.getActionMap().put(this.toggleScrollToBottomAction.getValue("Name"), this.toggleScrollToBottomAction);
        this.scrollToBottomButton.getInputMap(1).put(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), this.toggleScrollToBottomAction.getValue("Name"));
        this.scrollToBottomButton.setText(null);
        SmallButton prefsButton = new SmallButton(this.showPreferencesAction);
        SmallButton undockButton = new SmallButton(this.undockAction);
        undockButton.setText("");
        this.toolbar.add(undockButton);
        this.toolbar.add(this.pauseButton);
        this.toolbar.add(this.toggleCyclicButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.detailPaneButton);
        this.toolbar.add(this.logTreePaneButton);
        this.toolbar.add(this.scrollToBottomButton);
        this.toolbar.add(prefsButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.clearButton);
        this.clearButton.setAction(this.clearAction);
        this.clearButton.setText("");
        this.toolbar.addSeparator();
        this.showReceiversButton.setText(null);
        this.toolbar.add(this.showReceiversButton);
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.setMargin(buttonMargins);
        this.toolbar.setFloatable(false);
    }

    private Action createUndockAction() {
        AbstractAction action = new AbstractAction("Undock", ChainsawIcons.ICON_UNDOCK){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel != null) {
                    logPanel.undock();
                }
            }
        };
        action.putValue("ShortDescription", "Undocks the current Log panel into its own window");
        return action;
    }

    private void scanState() {
        this.toggleStatusBarCheck.setSelected(this.logui.isStatusBarVisible());
        this.toggleShowReceiversCheck.setSelected(this.logui.getApplicationPreferenceModel().isReceivers());
        this.logTreePaneButton.setSelected(this.logui.isLogTreePanelVisible());
        LogPanel panel = this.logui.getCurrentLogPanel();
        if (panel != null) {
            this.scrollToBottomButton.setSelected(panel.isScrollToBottom());
            this.toggleDetailMenuItem.setSelected(panel.isDetailVisible());
        } else {
            this.scrollToBottomButton.setSelected(false);
            this.toggleDetailMenuItem.setSelected(false);
        }
        this.showReceiversButton.setSelected(this.logui.getApplicationPreferenceModel().isReceivers());
        this.menuShowWelcome.setSelected(this.logui.getTabbedPane().containsWelcomePanel());
        LogPanel logPanel = this.logui.getCurrentLogPanel();
        boolean activateLogPanelActions = true;
        if (logPanel == null) {
            activateLogPanelActions = false;
            this.activeTabMenu.setEnabled(false);
            this.toggleWelcomeVisibleAction.setEnabled(true);
            this.detailPaneButton.setSelected(false);
            this.toggleCyclicButton.setSelected(false);
        } else {
            this.activeTabMenu.setEnabled(true);
            this.fileMenu.getFileSaveAction().setEnabled(true);
            this.pauseButton.getModel().setSelected(logPanel.isPaused());
            this.toggleCyclicButton.setSelected(logPanel.isCyclic());
            this.logui.getStatusBar().setPaused(logPanel.isPaused(), logPanel.getIdentifier());
            this.toggleCyclicMenuItem.setSelected(logPanel.isCyclic());
            this.detailPaneButton.getModel().setSelected(logPanel.isDetailVisible());
            this.toggleLogTreeMenuItem.setSelected(logPanel.isLogTreeVisible());
            this.toggleScrollToBottomMenuItem.setSelected(logPanel.isScrollToBottom());
        }
        for (Action logPanelSpecificAction : this.logPanelSpecificActions) {
            logPanelSpecificAction.setEnabled(activateLogPanelActions);
        }
        String currentLookAndFeelName = UIManager.getLookAndFeel().getName();
        for (Object lookAndFeelMenu : this.lookAndFeelMenus) {
            JRadioButtonMenuItem element = (JRadioButtonMenuItem)lookAndFeelMenu;
            if (element.getText().equals(currentLookAndFeelName)) {
                element.setSelected(true);
                continue;
            }
            element.setSelected(false);
        }
    }

    private Action getFindNextColorizedEventAction() {
        AbstractAction action = new AbstractAction("Find next colorized event"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel p = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (p != null) {
                    p.findNextColorizedEvent();
                }
            }
        };
        action.putValue("ShortDescription", "Find the next colorized event from the current location");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", 78);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        return action;
    }

    private Action getFindPreviousColorizedEventAction() {
        AbstractAction action = new AbstractAction("Find previous colorized event"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel p = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (p != null) {
                    p.findPreviousColorizedEvent();
                }
            }
        };
        action.putValue("ShortDescription", "Find the next colorized event from the current location");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", 80);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        return action;
    }

    private JPanel getCustomExpressionPanel() {
        final JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("Enter expression for new tab:  "), "North");
        final JEditorPane entryField = new JEditorPane();
        entryField.setPreferredSize(new Dimension(350, 75));
        JTextComponentFormatter.applySystemFontAndSize(entryField);
        entryField.addKeyListener(new ExpressionRuleContext(new FilterModel(), entryField));
        panel.add((Component)entryField, "Center");
        JButton ok = new JButton(" OK ");
        JButton close = new JButton(" Close ");
        JPanel lowerPanel = new JPanel();
        lowerPanel.add(ok);
        lowerPanel.add(Box.createHorizontalStrut(7));
        lowerPanel.add(close);
        panel.add((Component)lowerPanel, "South");
        ok.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChainsawToolBarAndMenus.this.logui.createCustomExpressionLogPanel(entryField.getText());
                SwingUtilities.getAncestorOfClass(JDialog.class, panel).setVisible(false);
            }
        });
        close.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.getAncestorOfClass(JDialog.class, panel).setVisible(false);
            }
        });
        return panel;
    }
}

