/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.vfs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.provider.URLFileName;
import org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs.util.RandomAccessMode;
import org.apache.log4j.chainsaw.receivers.VisualReceiver;
import org.apache.log4j.varia.LogFilePatternReceiver;

public class VFSLogFilePatternReceiver
extends LogFilePatternReceiver
implements VisualReceiver {
    private boolean promptForUserInfo = false;
    private Container container;
    private final Object waitForContainerLock = new Object();
    private boolean autoReconnect;
    private VFSReader vfsReader;

    @Override
    public void shutdown() {
        this.getLogger().info("shutdown VFSLogFilePatternReceiver");
        this.active = false;
        this.container = null;
        if (this.vfsReader != null) {
            this.vfsReader.terminate();
            this.vfsReader = null;
        }
    }

    public void setPromptForUserInfo(boolean promptForUserInfo) {
        this.promptForUserInfo = promptForUserInfo;
    }

    public boolean isPromptForUserInfo() {
        return this.promptForUserInfo;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContainer(Container container) {
        if (this.promptForUserInfo) {
            Object object = this.waitForContainerLock;
            synchronized (object) {
                this.container = container;
                this.waitForContainerLock.notify();
            }
        }
    }

    @Override
    public void activateOptions() {
        this.active = true;
        if (this.promptForUserInfo && !this.getFileURL().contains("@")) {
            new Thread(() -> {
                Frame containerFrame1;
                Object object = this.waitForContainerLock;
                synchronized (object) {
                    while (this.container == null) {
                        try {
                            this.waitForContainerLock.wait(1000L);
                            this.getLogger().debug("waiting for setContainer call");
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (this.container instanceof Frame) {
                    containerFrame1 = (Frame)this.container;
                } else {
                    Object object2 = this.waitForContainerLock;
                    synchronized (object2) {
                        while ((containerFrame1 = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.container)) == null) {
                            try {
                                this.waitForContainerLock.wait(1000L);
                                this.getLogger().debug("waiting for container's frame to be available");
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
                Frame containerFrame = containerFrame1;
                SwingUtilities.invokeLater(() -> {
                    Frame owner = null;
                    if (this.container != null) {
                        owner = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, containerFrame);
                    }
                    UserNamePasswordDialog f = new UserNamePasswordDialog(owner);
                    f.pack();
                    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                    f.setLocation(d.width / 2, d.height / 2);
                    f.setVisible(true);
                    if (null == f.getUserName() || null == f.getPassword()) {
                        this.getLogger().info("Username and password not both provided, not using credentials");
                    } else {
                        String oldURL = this.getFileURL();
                        int index = oldURL.indexOf("://");
                        String firstPart = oldURL.substring(0, index);
                        String lastPart = oldURL.substring(index + "://".length());
                        this.setFileURL(firstPart + "://" + f.getUserName() + ":" + new String(f.getPassword()) + "@" + lastPart);
                        this.setHost(oldURL.substring(0, index + "://".length()));
                        this.setPath(oldURL.substring(index + "://".length()));
                    }
                    this.vfsReader = new VFSReader();
                    new Thread(this.vfsReader).start();
                });
            }).start();
        } else {
            String oldURL = this.getFileURL();
            if (oldURL != null && oldURL.contains(":/") && !oldURL.contains("://")) {
                int index = oldURL.indexOf(":/");
                String lastPart = oldURL.substring(index + ":/".length());
                int passEndIndex = lastPart.indexOf("@");
                if (passEndIndex > -1) {
                    this.setHost(oldURL.substring(0, index + ":/".length()));
                    this.setPath(lastPart.substring(passEndIndex + 1));
                }
                this.vfsReader = new VFSReader();
                new Thread(this.vfsReader).start();
            } else if (oldURL != null && oldURL.contains("://")) {
                int index = oldURL.indexOf("://");
                String lastPart = oldURL.substring(index + "://".length());
                int passEndIndex = lastPart.indexOf("@");
                if (passEndIndex > -1) {
                    this.setHost(oldURL.substring(0, index + "://".length()));
                    this.setPath(lastPart.substring(passEndIndex + 1));
                }
                this.vfsReader = new VFSReader();
                new Thread(this.vfsReader).start();
            } else {
                this.getLogger().info("null URL - unable to parse file");
            }
        }
    }

    public class UserNamePasswordDialog
    extends JDialog {
        private String userName;
        private char[] password;

        private UserNamePasswordDialog(Frame containerFrame) {
            super(containerFrame, "Login", true);
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 0;
            gc.anchor = 11;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.gridwidth = 3;
            gc.insets = new Insets(7, 7, 7, 7);
            panel.add((Component)new JLabel("URI: " + VFSLogFilePatternReceiver.this.getFileURL()), gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.gridwidth = 1;
            gc.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)new JLabel("Username"), gc);
            gc.gridx = 1;
            gc.gridy = 1;
            gc.gridwidth = 2;
            gc.weightx = 1.0;
            gc.fill = 2;
            JTextField userNameTextField = new JTextField(15);
            panel.add((Component)userNameTextField, gc);
            gc.gridx = 0;
            gc.gridy = 2;
            gc.gridwidth = 1;
            gc.fill = 0;
            panel.add((Component)new JLabel("Password"), gc);
            gc.gridx = 1;
            gc.gridy = 2;
            gc.gridwidth = 2;
            gc.fill = 2;
            JPasswordField passwordTextField = new JPasswordField(15);
            panel.add((Component)passwordTextField, gc);
            gc.gridy = 3;
            gc.anchor = 15;
            gc.fill = 0;
            JButton submitButton = new JButton(" Submit ");
            panel.add((Component)submitButton, gc);
            this.getContentPane().add(panel);
            submitButton.addActionListener(evt -> {
                this.userName = userNameTextField.getText();
                this.password = passwordTextField.getPassword();
                this.getContentPane().setVisible(false);
                this.dispose();
            });
        }

        public String getUserName() {
            return this.userName;
        }

        public char[] getPassword() {
            return this.password;
        }
    }

    private class VFSReader
    implements Runnable {
        private boolean terminated = false;
        private Reader reader;
        private FileObject fileObject;

        private VFSReader() {
        }

        private boolean isGZip(String fileName) {
            return fileName.endsWith(".gz");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.reader == null && !this.terminated) {
                int atIndex = VFSLogFilePatternReceiver.this.getFileURL().indexOf("@");
                int protocolIndex = VFSLogFilePatternReceiver.this.getFileURL().indexOf("://");
                String loggableFileURL = atIndex > -1 ? VFSLogFilePatternReceiver.this.getFileURL().substring(0, protocolIndex + "://".length()) + "username:password" + VFSLogFilePatternReceiver.this.getFileURL().substring(atIndex) : VFSLogFilePatternReceiver.this.getFileURL();
                VFSLogFilePatternReceiver.this.getLogger().info("attempting to load file: " + loggableFileURL);
                try {
                    FileSystemManager fileSystemManager = VFS.getManager();
                    FileSystemOptions opts = new FileSystemOptions();
                    try {
                        SftpFileSystemConfigBuilder.getInstance().setStrictHostKeyChecking(opts, "no");
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        VFSLogFilePatternReceiver.this.getLogger().warn((Object)"JSch not on classpath!", ncdfe);
                    }
                    FileSystemManager ncdfe = fileSystemManager;
                    synchronized (ncdfe) {
                        this.fileObject = fileSystemManager.resolveFile(VFSLogFilePatternReceiver.this.getFileURL(), opts);
                        if (this.fileObject.exists()) {
                            this.reader = new InputStreamReader(this.fileObject.getContent().getInputStream(), "UTF-8");
                            if (this.fileObject.getName() instanceof URLFileName) {
                                URLFileName urlFileName = (URLFileName)this.fileObject.getName();
                                VFSLogFilePatternReceiver.this.setHost(urlFileName.getHostName());
                                VFSLogFilePatternReceiver.this.setPath(urlFileName.getPath());
                            }
                        } else {
                            VFSLogFilePatternReceiver.this.getLogger().info(loggableFileURL + " not available - will re-attempt to load after waiting 10000 millis");
                        }
                    }
                }
                catch (FileSystemException fse) {
                    VFSLogFilePatternReceiver.this.getLogger().info((Object)(loggableFileURL + " not available - may be due to incorrect credentials, but will re-attempt to load after waiting 10000 millis"), fse);
                }
                catch (UnsupportedEncodingException e) {
                    VFSLogFilePatternReceiver.this.getLogger().info((Object)"UTF-8 not available", e);
                }
                if (this.reader != null) continue;
                VFSReader e = this;
                synchronized (e) {
                    try {
                        this.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.terminated) {
                return;
            }
            VFSLogFilePatternReceiver.this.initialize();
            VFSLogFilePatternReceiver.this.getLogger().debug(VFSLogFilePatternReceiver.this.getPath() + " exists");
            boolean readingFinished = false;
            do {
                long lastFilePointer = 0L;
                long lastFileSize = 0L;
                VFSLogFilePatternReceiver.this.createPattern();
                try {
                    do {
                        FileSystemManager fileSystemManager = VFS.getManager();
                        FileSystemOptions opts = new FileSystemOptions();
                        try {
                            SftpFileSystemConfigBuilder.getInstance().setStrictHostKeyChecking(opts, "no");
                        }
                        catch (NoClassDefFoundError ncdfe) {
                            VFSLogFilePatternReceiver.this.getLogger().warn((Object)"JSch not on classpath!", ncdfe);
                        }
                        FileSystemManager ncdfe = fileSystemManager;
                        synchronized (ncdfe) {
                            if (this.fileObject != null) {
                                this.fileObject.getFileSystem().getFileSystemManager().closeFileSystem(this.fileObject.getFileSystem());
                                this.fileObject.close();
                                this.fileObject = null;
                            }
                            this.fileObject = fileSystemManager.resolveFile(VFSLogFilePatternReceiver.this.getFileURL(), opts);
                        }
                        boolean fileLarger = false;
                        if (this.fileObject != null && this.fileObject.exists()) {
                            try {
                                this.fileObject.refresh();
                            }
                            catch (Error err) {
                                VFSLogFilePatternReceiver.this.getLogger().info((Object)(VFSLogFilePatternReceiver.this.getPath() + " - unable to refresh fileobject"), err);
                            }
                            if (this.isGZip(VFSLogFilePatternReceiver.this.getFileURL())) {
                                GZIPInputStream gzipStream = new GZIPInputStream(this.fileObject.getContent().getInputStream());
                                InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, "UTF-8");
                                BufferedReader bufferedReader = new BufferedReader(decoder);
                                VFSLogFilePatternReceiver.this.process(bufferedReader);
                                readingFinished = true;
                            }
                            if (this.fileObject.getContent().getSize() < lastFileSize) {
                                this.reader = new InputStreamReader(this.fileObject.getContent().getInputStream(), "UTF-8");
                                VFSLogFilePatternReceiver.this.getLogger().debug(VFSLogFilePatternReceiver.this.getPath() + " was truncated");
                                lastFileSize = 0L;
                                lastFilePointer = 0L;
                            } else if (this.fileObject.getContent().getSize() > lastFileSize) {
                                fileLarger = true;
                                RandomAccessContent rac = this.fileObject.getContent().getRandomAccessContent(RandomAccessMode.READ);
                                rac.seek(lastFilePointer);
                                this.reader = new InputStreamReader(rac.getInputStream(), "UTF-8");
                                BufferedReader bufferedReader = new BufferedReader(this.reader);
                                VFSLogFilePatternReceiver.this.process(bufferedReader);
                                lastFilePointer = rac.getFilePointer();
                                lastFileSize = this.fileObject.getContent().getSize();
                                rac.close();
                            }
                            try {
                                if (this.reader != null) {
                                    this.reader.close();
                                    this.reader = null;
                                }
                            }
                            catch (IOException ioe) {
                                VFSLogFilePatternReceiver.this.getLogger().debug((Object)(VFSLogFilePatternReceiver.this.getPath() + " - unable to close reader"), ioe);
                            }
                        } else {
                            VFSLogFilePatternReceiver.this.getLogger().info(VFSLogFilePatternReceiver.this.getPath() + " - not available - will re-attempt to load after waiting " + VFSLogFilePatternReceiver.this.getWaitMillis() + " millis");
                        }
                        try {
                            VFSReader vFSReader = this;
                            synchronized (vFSReader) {
                                this.wait(VFSLogFilePatternReceiver.this.getWaitMillis());
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!VFSLogFilePatternReceiver.this.isTailing() || !fileLarger || this.terminated) continue;
                        VFSLogFilePatternReceiver.this.getLogger().debug(VFSLogFilePatternReceiver.this.getPath() + " - tailing file - file size: " + lastFileSize);
                    } while (VFSLogFilePatternReceiver.this.isTailing() && !this.terminated && !readingFinished);
                }
                catch (IOException ioe) {
                    VFSLogFilePatternReceiver.this.getLogger().info((Object)(VFSLogFilePatternReceiver.this.getPath() + " - exception processing file"), ioe);
                    try {
                        if (this.fileObject != null) {
                            this.fileObject.close();
                        }
                    }
                    catch (FileSystemException e) {
                        VFSLogFilePatternReceiver.this.getLogger().info((Object)(VFSLogFilePatternReceiver.this.getPath() + " - exception processing file"), e);
                    }
                    try {
                        VFSReader vFSReader = this;
                        synchronized (vFSReader) {
                            this.wait(VFSLogFilePatternReceiver.this.getWaitMillis());
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } while (VFSLogFilePatternReceiver.this.isAutoReconnect() && !this.terminated && !readingFinished);
            VFSLogFilePatternReceiver.this.getLogger().debug(VFSLogFilePatternReceiver.this.getPath() + " - processing complete");
        }

        public void terminate() {
            this.terminated = true;
        }
    }
}

