/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.receivers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.helper.TableCellEditorFactory;
import org.apache.log4j.plugins.Plugin;

public class PluginPropertyEditorPanel
extends JPanel {
    private final JScrollPane scrollPane = new JScrollPane();
    private final JTable propertyTable = new JTable();
    private Plugin plugin;
    private TableModel defaultModel = new DefaultTableModel(new String[]{"Property", "Value"}, 1);
    private static final Logger logger = LogManager.getLogger(PluginPropertyEditorPanel.class);

    public PluginPropertyEditorPanel() {
        this.initComponents();
        this.setupListeners();
    }

    private void initComponents() {
        this.propertyTable.setRowHeight(20);
        this.setLayout(new BorderLayout());
        this.scrollPane.setViewportView(this.propertyTable);
        this.add((Component)this.scrollPane, "Center");
        this.defaultModel = new DefaultTableModel(new String[]{"Property", "Value"}, 1);
        this.propertyTable.setModel(this.defaultModel);
    }

    private void setupListeners() {
        this.addPropertyChangeListener("plugin", evt -> {
            Plugin p = (Plugin)evt.getNewValue();
            if (p != null) {
                try {
                    PluginPropertyTableModel model = new PluginPropertyTableModel(p);
                    this.propertyTable.setModel(model);
                    this.propertyTable.getColumnModel().getColumn(1).setCellEditor(new PluginTableCellEditor());
                    this.propertyTable.setEnabled(true);
                }
                catch (Throwable e) {
                    logger.error("Failed to introspect the Plugin", e);
                }
            } else {
                this.propertyTable.setModel(this.defaultModel);
                this.propertyTable.setEnabled(false);
            }
        });
    }

    public final Plugin getPlugin() {
        return this.plugin;
    }

    public final void setPlugin(Plugin plugin) {
        Plugin oldValue = this.plugin;
        this.plugin = plugin;
        this.firePropertyChange("plugin", oldValue, this.plugin);
    }

    private class PluginPropertyTableModel
    extends AbstractTableModel {
        private final PropertyDescriptor[] descriptors;
        private final Plugin plugin;

        private PluginPropertyTableModel(Plugin p) throws IntrospectionException {
            BeanInfo beanInfo = Introspector.getBeanInfo(p.getClass());
            ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(Arrays.asList(beanInfo.getPropertyDescriptors()));
            list.sort((o1, o2) -> {
                PropertyDescriptor d1 = (PropertyDescriptor)o1;
                PropertyDescriptor d2 = (PropertyDescriptor)o2;
                return d1.getDisplayName().compareToIgnoreCase(d2.getDisplayName());
            });
            this.plugin = p;
            this.descriptors = list.toArray(new PropertyDescriptor[0]);
        }

        @Override
        public Object getValueAt(int row, int col) {
            PropertyDescriptor d = this.descriptors[row];
            switch (col) {
                case 1: {
                    try {
                        Object object = d.getReadMethod().invoke((Object)this.plugin, new Object[0]);
                        if (object != null) {
                            return object;
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error reading value for PropertyDescriptor " + d);
                    }
                    return "";
                }
                case 0: {
                    return d.getName();
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.descriptors.length;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 && this.descriptors[rowIndex].getWriteMethod() != null;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "Property" : "Value";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                if (this.descriptors[rowIndex].getName().equalsIgnoreCase("name") && (aValue == null || aValue.toString().trim().equals(""))) {
                    logger.error("Name required");
                    return;
                }
                aValue = this.translateValueIfNeeded(rowIndex, aValue);
                logger.debug("setValueAt, " + rowIndex + ", " + columnIndex + ", value=" + aValue + ", valueClass" + aValue.getClass());
                try {
                    this.descriptors[rowIndex].getWriteMethod().invoke((Object)this.plugin, aValue);
                    this.fireTableCellUpdated(rowIndex, columnIndex);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (Exception e) {
                    logger.error("Failed to modify the Plugin because of Exception", e);
                }
            } else {
                super.setValueAt(aValue, rowIndex, columnIndex);
            }
            PluginPropertyEditorPanel.this.propertyTable.setRowHeight(20);
        }

        private Object translateValueIfNeeded(int row, Object value) {
            if (this.descriptors[row].getPropertyType() == Integer.TYPE || this.descriptors[row].getPropertyType() == Integer.class) {
                try {
                    return Integer.valueOf(value.toString());
                }
                catch (Exception e) {
                    logger.error("Failed to convert to Integer type");
                }
            }
            return value;
        }

        public final PropertyDescriptor[] getDescriptors() {
            return this.descriptors;
        }
    }

    private class PluginTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private Map editorMap = new HashMap();
        private DefaultCellEditor defaultEditor;
        private DefaultCellEditor currentEditor = this.defaultEditor = new DefaultCellEditor(new JTextField());

        private PluginTableCellEditor() {
            this.editorMap.put(Boolean.class, TableCellEditorFactory.createBooleanTableCellEditor());
            this.editorMap.put(Level.class, TableCellEditorFactory.createLevelTableCellEditor());
            this.editorMap.put(Boolean.TYPE, TableCellEditorFactory.createBooleanTableCellEditor());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            PluginPropertyTableModel model = (PluginPropertyTableModel)table.getModel();
            PropertyDescriptor descriptor = model.getDescriptors()[row];
            Class<?> valueClass = descriptor.getPropertyType();
            if (this.editorMap.containsKey(valueClass)) {
                DefaultCellEditor editor = (DefaultCellEditor)this.editorMap.get(valueClass);
                logger.debug("Located CellEditor for " + valueClass);
                this.currentEditor = editor;
                return this.currentEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
            this.currentEditor = this.defaultEditor;
            logger.debug("Cell value class " + valueClass + " not know, using default editor");
            Component c = this.defaultEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
            table.setRowHeight(row, c.getPreferredSize().height);
            return c;
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentEditor.getCellEditorValue();
        }
    }
}

