/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.util.Comparator;
import org.apache.log4j.Priority;
import org.apache.log4j.chainsaw.LoggingEventWrapper;
import org.apache.log4j.spi.LoggingEvent;

public class ColumnComparator
implements Comparator {
    protected int index;
    protected boolean ascending;
    protected String columnName;

    public ColumnComparator(String columnName, int index, boolean ascending) {
        this.columnName = columnName;
        this.index = index;
        this.ascending = ascending;
    }

    public int compare(Object o1, Object o2) {
        int sort = 1;
        if (o1 instanceof LoggingEventWrapper && o2 instanceof LoggingEventWrapper) {
            LoggingEvent e1 = ((LoggingEventWrapper)o1).getLoggingEvent();
            LoggingEvent e2 = ((LoggingEventWrapper)o2).getLoggingEvent();
            switch (this.index + 1) {
                case 4: {
                    sort = e1.getLevel().isGreaterOrEqual((Priority)e2.getLevel()) ? 1 : -1;
                    break;
                }
                case 1: {
                    sort = e1.getLoggerName().compareToIgnoreCase(e2.getLoggerName());
                    break;
                }
                case 6: {
                    sort = e1.getMessage().toString().compareToIgnoreCase(e2.getMessage().toString());
                    break;
                }
                case 7: {
                    if (e1.getNDC() != null && e2.getNDC() != null) {
                        sort = e1.getNDC().compareToIgnoreCase(e2.getNDC());
                        break;
                    }
                    if (e1.getNDC() == null && e2.getNDC() == null) {
                        sort = 0;
                        break;
                    }
                    if (e1.getNDC() == null) {
                        sort = -1;
                        break;
                    }
                    if (e2.getNDC() != null) break;
                    sort = 1;
                    break;
                }
                case 10: {
                    if (!(e1.locationInformationExists() & e2.locationInformationExists())) break;
                    sort = e1.getLocationInformation().getMethodName().compareToIgnoreCase(e2.getLocationInformation().getMethodName());
                    break;
                }
                case 9: {
                    if (!(e1.locationInformationExists() & e2.locationInformationExists())) break;
                    sort = e1.getLocationInformation().getClassName().compareToIgnoreCase(e2.getLocationInformation().getClassName());
                    break;
                }
                case 11: {
                    if (!(e1.locationInformationExists() & e2.locationInformationExists())) break;
                    sort = e1.getLocationInformation().getFileName().compareToIgnoreCase(e2.getLocationInformation().getFileName());
                    break;
                }
                case 3: {
                    sort = e1.getTimeStamp() < e2.getTimeStamp() ? -1 : (e1.getTimeStamp() == e2.getTimeStamp() ? 0 : 1);
                    break;
                }
                case 5: {
                    sort = e1.getThreadName().compareToIgnoreCase(e2.getThreadName());
                    break;
                }
                case 14: {
                    int id1 = Integer.parseInt(e1.getProperty("log4jid"));
                    int id2 = Integer.parseInt(e2.getProperty("log4jid"));
                    if (id1 == id2) {
                        sort = 0;
                        break;
                    }
                    if (id1 < id2) {
                        sort = 1;
                        break;
                    }
                    sort = -1;
                    break;
                }
                case 8: {
                    if (e1.getThrowableStrRep() == null || e2.getThrowableStrRep() == null) break;
                    String[] s1 = e1.getThrowableStrRep();
                    String[] s2 = e2.getThrowableStrRep();
                    boolean foundDiff = false;
                    for (int i = 0; i < s1.length && !foundDiff && i <= s2.length; ++i) {
                        sort = s1[i].compareToIgnoreCase(s2[i]);
                        foundDiff = sort != 0;
                    }
                    break;
                }
                case 12: {
                    if (!(e1.locationInformationExists() & e2.locationInformationExists())) break;
                    sort = e1.getLocationInformation().getLineNumber().compareToIgnoreCase(e2.getLocationInformation().getLineNumber());
                    break;
                }
                default: {
                    if (e1.getProperty(this.columnName) == null || e2.getProperty(this.columnName) == null) break;
                    sort = e1.getProperty(this.columnName).toString().compareToIgnoreCase(e2.getProperty(this.columnName).toString());
                }
            }
        }
        int n = sort == 0 ? 0 : (sort = sort < 0 ? -1 : 1);
        if (!this.ascending && sort != 0) {
            sort = sort < 0 ? 1 : -1;
        }
        return sort;
    }
}

