--
-- Licensed to the Apache Software Foundation (ASF) under one
-- or more contributor license agreements.  See the NOTICE file
-- distributed with this work for additional information
-- regarding copyright ownership.  The ASF licenses this file
-- to you under the Apache License, Version 2.0 (the
-- "License"); you may not use this file except in compliance
-- with the License.  You may obtain a copy of the License at
--
--     http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
--


select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190601')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '201906'
and
    "DIMDATE_1"."YEAR" = '2019'
and
    "DIMDATE_1"."WEEKKEY" = '20190601'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190608')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '201906'
and
    "DIMDATE_1"."YEAR" = '2019'
and
    "DIMDATE_1"."WEEKKEY" = '20190608'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190615')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '201906'
and
    "DIMDATE_1"."YEAR" = '2019'
and
    "DIMDATE_1"."WEEKKEY" = '20190615'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190622')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '201906'
and
    "DIMDATE_1"."YEAR" = '2019'
and
    "DIMDATE_1"."WEEKKEY" = '20190622'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202001' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202002' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202003' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202001' and "DIMDATE_1"."WEEKKEY" = '20191228' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202001' and "DIMDATE_1"."WEEKKEY" = '20200104' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202001' and "DIMDATE_1"."WEEKKEY" = '20200111' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202001' and "DIMDATE_1"."WEEKKEY" = '20200118' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202001' and "DIMDATE_1"."WEEKKEY" = '20200125' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202002' and "DIMDATE_1"."WEEKKEY" = '20200201' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202002' and "DIMDATE_1"."WEEKKEY" = '20200208' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202002' and "DIMDATE_1"."WEEKKEY" = '20200215' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202002' and "DIMDATE_1"."WEEKKEY" = '20200222' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202002' and "DIMDATE_1"."WEEKKEY" = '20200229' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202003' and "DIMDATE_1"."WEEKKEY" = '20200229' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202003' and "DIMDATE_1"."WEEKKEY" = '20200307' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202003' and "DIMDATE_1"."WEEKKEY" = '20200314' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202003' and "DIMDATE_1"."WEEKKEY" = '20200321' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202003' and "DIMDATE_1"."WEEKKEY" = '20200328' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200328' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200404' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200411' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200418' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200425' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200425' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200502' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200530' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202001' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202002' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202003' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202001' and "DIMDATE_1"."WEEKKEY" = '20191228' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202001' and "DIMDATE_1"."WEEKKEY" = '20200104' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202001' and "DIMDATE_1"."WEEKKEY" = '20200111' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202001' and "DIMDATE_1"."WEEKKEY" = '20200118' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202001' and "DIMDATE_1"."WEEKKEY" = '20200125' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202002' and "DIMDATE_1"."WEEKKEY" = '20200201' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202002' and "DIMDATE_1"."WEEKKEY" = '20200208' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202002' and "DIMDATE_1"."WEEKKEY" = '20200215' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202002' and "DIMDATE_1"."WEEKKEY" = '20200222' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202002' and "DIMDATE_1"."WEEKKEY" = '20200229' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202003' and "DIMDATE_1"."WEEKKEY" = '20200229' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202003' and "DIMDATE_1"."WEEKKEY" = '20200307' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202003' and "DIMDATE_1"."WEEKKEY" = '20200314' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202003' and "DIMDATE_1"."WEEKKEY" = '20200321' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202003' and "DIMDATE_1"."WEEKKEY" = '20200328' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200328' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200404' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200411' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200418' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200425' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200425' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200502' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200530' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMCANVAS_1"."CANVAS" as "c0"
from
    "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1"
group by
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMCANVAS_1"."CANVAS" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020')
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHNAME"
order by
    "DIMDATE_1"."MONTHKEY" ASC;

select
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1";

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202006'
and
    "DIMDATE_1"."YEAR" = '2020'
and
    "DIMDATE_1"."WEEKKEY" = '20200530'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202006'
and
    "DIMDATE_1"."YEAR" = '2020'
and
    "DIMDATE_1"."WEEKKEY" = '20200606'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202006'
and
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202006'
and
    "DIMDATE_1"."YEAR" = '2020'
and
    "DIMDATE_1"."WEEKKEY" = '20200627'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202006'
and
    "DIMDATE_1"."YEAR" = '2020'
and
    "DIMDATE_1"."WEEKKEY" = '20200620'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select * from (select
    "DIMCANVAS_1"."CANVAS" as "c0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."CANVASKEY" = "DIMCANVAS_1"."CANVASKEY"
group by
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMCANVAS_1"."CANVAS" ASC) limit 50000;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    "DIMCANVAS_1"."CANVAS" as "c4",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."CANVASKEY" = "DIMCANVAS_1"."CANVASKEY" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE",
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC,
    "DIMCANVAS_1"."CANVAS" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020')
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHNAME"
order by
    "DIMDATE_1"."MONTHKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    "DIMDATE_1"."YEAR" = '2019'
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019')
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHNAME"
order by
    "DIMDATE_1"."MONTHKEY" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190601')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190608')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190615')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190622')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-20') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-21') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-22') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-23') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-24') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-25') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-26'));

select
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-03') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-05'));

select
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-27') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-28') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-29') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-30'));

select
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-17') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-18') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-19'));

select
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-10') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-12'));

select
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-03') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-05') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-10') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-12') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-17') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718' and "DIMDATE_1"."DATE" = DATE '2020-07-18'));

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-03') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-05'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-17') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-18') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-19'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-20') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-21') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-22') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-23') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-24') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-25') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-26'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-10') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-12'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-27') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-28') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-29') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-30'));

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-03') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-05') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-10') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-12') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-17') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718' and "DIMDATE_1"."DATE" = DATE '2020-07-18'));

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."R28DAYSACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMCANVAS_1"."CANVAS" as "c0"
from
    "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1"
where
    "DIMCANVAS_1"."CANVAS" = 'Edge DHP'
group by
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMCANVAS_1"."CANVAS" ASC;

select
    "DIMCANVAS_1"."CANVAS" as "c0"
from
    "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1"
group by
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMCANVAS_1"."CANVAS" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020')
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHNAME"
order by
    "DIMDATE_1"."MONTHKEY" ASC;

select
    "DIMUSERACTION_1"."USERACTION" as "c0"
from
    "MSNDATAMART"."DIMUSERACTION" as "DIMUSERACTION_1"
where
    "DIMUSERACTION_1"."USERACTION" = 'Core Page Views'
group by
    "DIMUSERACTION_1"."USERACTION"
order by
    "DIMUSERACTION_1"."USERACTION" ASC;

select
    "DIMUSERACTION_1"."USERACTION" as "c0",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."R28DAYSACTIONS") as "m1"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."DIMUSERACTION" as "DIMUSERACTION_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."USERACTIONKEY" = "DIMUSERACTION_1"."USERACTIONKEY"
where
    "DIMUSERACTION_1"."USERACTION" = 'Core Page Views'
group by
    "DIMUSERACTION_1"."USERACTION"
order by
    "DIMUSERACTION_1"."USERACTION" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMUSERACTION_1"."USERACTION" as "c2",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."R28DAYSACTIONS") as "m1"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMUSERACTION" as "DIMUSERACTION_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."USERACTIONKEY" = "DIMUSERACTION_1"."USERACTIONKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
and
    "DIMUSERACTION_1"."USERACTION" = 'Core Page Views'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMUSERACTION_1"."USERACTION"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMUSERACTION_1"."USERACTION" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMUSERACTION_1"."USERACTION" as "c2",
    "DIMCANVAS_1"."CANVAS" as "c3",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMUSERACTION" as "DIMUSERACTION_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."USERACTIONKEY" = "DIMUSERACTION_1"."USERACTIONKEY" inner join "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."CANVASKEY" = "DIMCANVAS_1"."CANVASKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202006'
and
    "DIMDATE_1"."YEAR" = '2020'
and
    "DIMUSERACTION_1"."USERACTION" = 'Core Page Views'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMUSERACTION_1"."USERACTION",
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMUSERACTION_1"."USERACTION" ASC,
    "DIMCANVAS_1"."CANVAS" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202006'
and
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020')
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHNAME"
order by
    "DIMDATE_1"."MONTHKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    "DIMDATE_1"."YEAR" = '2019'
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019')
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHNAME"
order by
    "DIMDATE_1"."MONTHKEY" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190601')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190608')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190615')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190622')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select * from (select
    "DIMCANVAS_1"."CANVAS" as "c0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."CANVASKEY" = "DIMCANVAS_1"."CANVASKEY"
group by
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMCANVAS_1"."CANVAS" ASC) limit 50000;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-03') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-05'));

select
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-27') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-28') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-29') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-30'));

select
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-10') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-12'));

select
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-20') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-21') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-22') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-23') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-24') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-25') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-26'));

select
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-03') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-05') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-10') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-12') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-17') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718' and "DIMDATE_1"."DATE" = DATE '2020-07-18'));

select
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-17') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-18') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-19'));

select
    "DIMCANVAS_1"."CANVAS" as "c0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."CANVASKEY" = "DIMCANVAS_1"."CANVASKEY" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-10') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-12'))
group by
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMCANVAS_1"."CANVAS" ASC;

select
    "DIMCANVAS_1"."CANVAS" as "c0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."CANVASKEY" = "DIMCANVAS_1"."CANVASKEY" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-20') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-21') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-22') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-23') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-24') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-25') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-26'))
group by
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMCANVAS_1"."CANVAS" ASC;

select
    "DIMCANVAS_1"."CANVAS" as "c0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."CANVASKEY" = "DIMCANVAS_1"."CANVASKEY" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-27') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-28') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-29') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-30'))
group by
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMCANVAS_1"."CANVAS" ASC;

select
    "DIMCANVAS_1"."CANVAS" as "c0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."CANVASKEY" = "DIMCANVAS_1"."CANVASKEY" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-03') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-05'))
group by
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMCANVAS_1"."CANVAS" ASC;

select
    "DIMCANVAS_1"."CANVAS" as "c0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."CANVASKEY" = "DIMCANVAS_1"."CANVASKEY" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-17') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-18') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-19'))
group by
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMCANVAS_1"."CANVAS" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    "DIMCANVAS_1"."CANVAS" as "c4",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."CANVASKEY" = "DIMCANVAS_1"."CANVASKEY" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE",
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC,
    "DIMCANVAS_1"."CANVAS" ASC;

select
    "DIMCANVAS_1"."CANVAS" as "c0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."CANVASKEY" = "DIMCANVAS_1"."CANVASKEY" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-03') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-05') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-10') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-12') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-17') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718' and "DIMDATE_1"."DATE" = DATE '2020-07-18'))
group by
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMCANVAS_1"."CANVAS" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m1"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1"
where
    "DIMBROWSER_1"."BROWSER" = 'IE11'
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1"
where
    "DIMBROWSER_1"."BROWSER" = 'Other'
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1"
where
    "DIMBROWSER_1"."BROWSER" = 'All Up'
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1"
where
    "DIMBROWSER_1"."BROWSER" = 'Unknown'
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1"
where
    "DIMBROWSER_1"."BROWSER" = 'IE Other'
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1"
where
    "DIMBROWSER_1"."BROWSER" = 'Unmatched'
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1"
where
    "DIMBROWSER_1"."BROWSER" = 'Edge - All Versions'
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1"
where
    "DIMBROWSER_1"."BROWSER" = 'Chrome - All Versions'
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1"
where
    "DIMBROWSER_1"."BROWSER" = 'Firefox - All Versions'
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select * from (select
    "DIMCANVAS_1"."CANVAS" as "c0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."CANVASKEY" = "DIMCANVAS_1"."CANVASKEY" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
where
    (("DIMBROWSER_1"."BROWSER" in ('IE11', 'Other', 'All Up', 'Unknown', 'IE Other', 'Unmatched', 'Edge - All Versions', 'Chrome - All Versions', 'Firefox - All Versions')))
group by
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMCANVAS_1"."CANVAS" ASC) limit 50000;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
and
    (("DIMBROWSER_1"."BROWSER" in ('IE11', 'Other', 'All Up', 'Unknown', 'IE Other', 'Unmatched', 'Edge - All Versions', 'Chrome - All Versions', 'Firefox - All Versions')))
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    "DIMCANVAS_1"."CANVAS" as "c4",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."DIMCANVAS" as "DIMCANVAS_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."CANVASKEY" = "DIMCANVAS_1"."CANVASKEY" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
and
    (("DIMBROWSER_1"."BROWSER" in ('IE11', 'Other', 'All Up', 'Unknown', 'IE Other', 'Unmatched', 'Edge - All Versions', 'Chrome - All Versions', 'Firefox - All Versions')))
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE",
    "DIMCANVAS_1"."CANVAS"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC,
    "DIMCANVAS_1"."CANVAS" ASC;

select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1"
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020')
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHNAME"
order by
    "DIMDATE_1"."MONTHKEY" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    "DIMDATE_1"."YEAR" = '2019'
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019')
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHNAME"
order by
    "DIMDATE_1"."MONTHKEY" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190601')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190608')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190615')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2019' and "DIMDATE_1"."MONTHKEY" = '201906' and "DIMDATE_1"."WEEKKEY" = '20190622')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200425' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200502' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m1"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m1"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202005'
and
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200328' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200404' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200411' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200418' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200425')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200328')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select * from (select "c0" from ( select
    "DIMPAGECONTENTLAYOUT_1"."PAGECONTENTLAYOUT" as "c0"
from
    "MSNDATAMART"."FACTSEARCHNONADDITIVE" as "FACTSEARCHNONADDITIVE_3" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTSEARCHNONADDITIVE_3"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMPAGECONTENTLAYOUT" as "DIMPAGECONTENTLAYOUT_1" on "FACTSEARCHNONADDITIVE_3"."PAGECONTENTLAYOUTKEY" = "DIMPAGECONTENTLAYOUT_1"."PAGECONTENTLAYOUTKEY"
where
    "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-01'
group by
    "DIMPAGECONTENTLAYOUT_1"."PAGECONTENTLAYOUT"
union
select
    "DIMPAGECONTENTLAYOUT_1"."PAGECONTENTLAYOUT" as "c0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMPAGECONTENTLAYOUT" as "DIMPAGECONTENTLAYOUT_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."PAGECONTENTLAYOUTKEY" = "DIMPAGECONTENTLAYOUT_1"."PAGECONTENTLAYOUTKEY"
where
    "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-01'
group by
    "DIMPAGECONTENTLAYOUT_1"."PAGECONTENTLAYOUT"
order by
    1 ASC)) limit 50000;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202007'
and
    "DIMDATE_1"."YEAR" = '2020'
and
    "DIMDATE_1"."WEEKKEY" = '20200627'
and
    "DIMDATE_1"."DATE" = DATE '2020-07-01'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    "DIMPAGECONTENTLAYOUT_1"."PAGECONTENTLAYOUT" as "c4",
    max("FACTSEARCHNONADDITIVE_3"."SEARCHDAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTSEARCHNONADDITIVE" as "FACTSEARCHNONADDITIVE_3" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTSEARCHNONADDITIVE_3"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMPAGECONTENTLAYOUT" as "DIMPAGECONTENTLAYOUT_1" on "FACTSEARCHNONADDITIVE_3"."PAGECONTENTLAYOUTKEY" = "DIMPAGECONTENTLAYOUT_1"."PAGECONTENTLAYOUTKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202007'
and
    "DIMDATE_1"."YEAR" = '2020'
and
    "DIMDATE_1"."WEEKKEY" = '20200627'
and
    "DIMDATE_1"."DATE" = DATE '2020-07-01'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE",
    "DIMPAGECONTENTLAYOUT_1"."PAGECONTENTLAYOUT"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC,
    "DIMPAGECONTENTLAYOUT_1"."PAGECONTENTLAYOUT" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    "DIMPAGECONTENTLAYOUT_1"."PAGECONTENTLAYOUT" as "c4",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMPAGECONTENTLAYOUT" as "DIMPAGECONTENTLAYOUT_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."PAGECONTENTLAYOUTKEY" = "DIMPAGECONTENTLAYOUT_1"."PAGECONTENTLAYOUTKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202007'
and
    "DIMDATE_1"."YEAR" = '2020'
and
    "DIMDATE_1"."WEEKKEY" = '20200627'
and
    "DIMDATE_1"."DATE" = DATE '2020-07-01'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE",
    "DIMPAGECONTENTLAYOUT_1"."PAGECONTENTLAYOUT"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC,
    "DIMPAGECONTENTLAYOUT_1"."PAGECONTENTLAYOUT" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTSEARCHNONADDITIVE_3"."SEARCHDAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTSEARCHNONADDITIVE" as "FACTSEARCHNONADDITIVE_3" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTSEARCHNONADDITIVE_3"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202007'
and
    "DIMDATE_1"."YEAR" = '2020'
and
    "DIMDATE_1"."WEEKKEY" = '20200627'
and
    "DIMDATE_1"."DATE" = DATE '2020-07-01'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select * from (select "c0" from ( select
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL" as "c0"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0" inner join "MSNDATAMART"."DIMCONTENTVERTICAL" as "DIMCONTENTVERTICAL_1" on "FACTSEARCHADDITIVE_0"."CONTENTVERTICALKEY" = "DIMCONTENTVERTICAL_1"."CONTENTVERTICALKEY"
group by
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL"
union
select
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL" as "c0"
from
    "MSNDATAMART"."FACTSEARCHNONADDITIVE" as "FACTSEARCHNONADDITIVE_1" inner join "MSNDATAMART"."DIMCONTENTVERTICAL" as "DIMCONTENTVERTICAL_1" on "FACTSEARCHNONADDITIVE_1"."CONTENTVERTICALKEY" = "DIMCONTENTVERTICAL_1"."CONTENTVERTICALKEY"
group by
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL"
order by
    1 ASC)) limit 50000;

select * from (select "c0", "c1" from ( select
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL" as "c0",
    "DIMCONTENTTYPE_1"."CONTENTTYPE" as "c1"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0" inner join "MSNDATAMART"."DIMCONTENTVERTICAL" as "DIMCONTENTVERTICAL_1" on "FACTSEARCHADDITIVE_0"."CONTENTVERTICALKEY" = "DIMCONTENTVERTICAL_1"."CONTENTVERTICALKEY" inner join "MSNDATAMART"."DIMCONTENTTYPE" as "DIMCONTENTTYPE_1" on "FACTSEARCHADDITIVE_0"."CONTENTTYPEKEY" = "DIMCONTENTTYPE_1"."CONTENTTYPEKEY"
group by
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL",
    "DIMCONTENTTYPE_1"."CONTENTTYPE"
union
select
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL" as "c0",
    "DIMCONTENTTYPE_1"."CONTENTTYPE" as "c1"
from
    "MSNDATAMART"."FACTSEARCHNONADDITIVE" as "FACTSEARCHNONADDITIVE_1" inner join "MSNDATAMART"."DIMCONTENTTYPE" as "DIMCONTENTTYPE_1" on "FACTSEARCHNONADDITIVE_1"."CONTENTTYPEKEY" = "DIMCONTENTTYPE_1"."CONTENTTYPEKEY" inner join "MSNDATAMART"."DIMCONTENTVERTICAL" as "DIMCONTENTVERTICAL_1" on "FACTSEARCHNONADDITIVE_1"."CONTENTVERTICALKEY" = "DIMCONTENTVERTICAL_1"."CONTENTVERTICALKEY"
group by
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL",
    "DIMCONTENTTYPE_1"."CONTENTTYPE"
order by
    1 ASC,
    2 ASC)) limit 50000;

select
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL" as "c0",
    max("FACTSEARCHNONADDITIVE_1"."SEARCHR28DAYSACTIVEUSERS") as "m0",
    max("FACTSEARCHNONADDITIVE_1"."SEARCHR28DAYSVISITORS") as "m1"
from
    "MSNDATAMART"."FACTSEARCHNONADDITIVE" as "FACTSEARCHNONADDITIVE_1" inner join "MSNDATAMART"."DIMCONTENTVERTICAL" as "DIMCONTENTVERTICAL_1" on "FACTSEARCHNONADDITIVE_1"."CONTENTVERTICALKEY" = "DIMCONTENTVERTICAL_1"."CONTENTVERTICALKEY"
group by
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL"
order by
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL" ASC;

select
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL" as "c0",
    sum("FACTSEARCHADDITIVE_0"."DAILYSEARCHES") as "m0",
    sum("FACTSEARCHADDITIVE_0"."SEARCHDAILYPAGEVIEWS") as "m1"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0" inner join "MSNDATAMART"."DIMCONTENTVERTICAL" as "DIMCONTENTVERTICAL_1" on "FACTSEARCHADDITIVE_0"."CONTENTVERTICALKEY" = "DIMCONTENTVERTICAL_1"."CONTENTVERTICALKEY"
group by
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL"
order by
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL" ASC;

select
    max("FACTSEARCHNONADDITIVE_1"."SEARCHR28DAYSACTIVEUSERS") as "m0",
    max("FACTSEARCHNONADDITIVE_1"."SEARCHR28DAYSVISITORS") as "m1"
from
    "MSNDATAMART"."FACTSEARCHNONADDITIVE" as "FACTSEARCHNONADDITIVE_1";

select
    sum("FACTSEARCHADDITIVE_0"."DAILYSEARCHES") as "m0",
    sum("FACTSEARCHADDITIVE_0"."SEARCHDAILYPAGEVIEWS") as "m1"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0";

select
    "DIMCONTENTTYPE_1"."CONTENTTYPE" as "c0",
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL" as "c1",
    sum("FACTSEARCHADDITIVE_0"."DAILYSEARCHES") as "m0",
    sum("FACTSEARCHADDITIVE_0"."SEARCHDAILYPAGEVIEWS") as "m1"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0" inner join "MSNDATAMART"."DIMCONTENTVERTICAL" as "DIMCONTENTVERTICAL_1" on "FACTSEARCHADDITIVE_0"."CONTENTVERTICALKEY" = "DIMCONTENTVERTICAL_1"."CONTENTVERTICALKEY" inner join "MSNDATAMART"."DIMCONTENTTYPE" as "DIMCONTENTTYPE_1" on "FACTSEARCHADDITIVE_0"."CONTENTTYPEKEY" = "DIMCONTENTTYPE_1"."CONTENTTYPEKEY"
where
    "DIMCONTENTTYPE_1"."CONTENTTYPE" = 'All Up'
group by
    "DIMCONTENTTYPE_1"."CONTENTTYPE",
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL"
order by
    "DIMCONTENTTYPE_1"."CONTENTTYPE" ASC,
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL" ASC;

select
    "DIMCONTENTTYPE_1"."CONTENTTYPE" as "c0",
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL" as "c1",
    max("FACTSEARCHNONADDITIVE_1"."SEARCHR28DAYSACTIVEUSERS") as "m0",
    max("FACTSEARCHNONADDITIVE_1"."SEARCHR28DAYSVISITORS") as "m1"
from
    "MSNDATAMART"."FACTSEARCHNONADDITIVE" as "FACTSEARCHNONADDITIVE_1" inner join "MSNDATAMART"."DIMCONTENTTYPE" as "DIMCONTENTTYPE_1" on "FACTSEARCHNONADDITIVE_1"."CONTENTTYPEKEY" = "DIMCONTENTTYPE_1"."CONTENTTYPEKEY" inner join "MSNDATAMART"."DIMCONTENTVERTICAL" as "DIMCONTENTVERTICAL_1" on "FACTSEARCHNONADDITIVE_1"."CONTENTVERTICALKEY" = "DIMCONTENTVERTICAL_1"."CONTENTVERTICALKEY"
where
    "DIMCONTENTTYPE_1"."CONTENTTYPE" = 'All Up'
group by
    "DIMCONTENTTYPE_1"."CONTENTTYPE",
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL"
order by
    "DIMCONTENTTYPE_1"."CONTENTTYPE" ASC,
    "DIMCONTENTVERTICAL_1"."CONTENTVERTICAL" ASC;

select * from (select
    "DIMPAGETYPEGROUP_1"."PAGETYPEGROUP" as "c0"
from
    "MSNDATAMART"."FACTVIDEOADDITIVE" as "FACTVIDEOADDITIVE_0" inner join "MSNDATAMART"."DIMPAGETYPEGROUP" as "DIMPAGETYPEGROUP_1" on "FACTVIDEOADDITIVE_0"."PAGETYPEGROUPKEY" = "DIMPAGETYPEGROUP_1"."PAGETYPEGROUPKEY"
group by
    "DIMPAGETYPEGROUP_1"."PAGETYPEGROUP"
order by
    "DIMPAGETYPEGROUP_1"."PAGETYPEGROUP" ASC) limit 50000;

select
    sum("FACTVIDEOADDITIVE_0"."VIDEODAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTVIDEOADDITIVE" as "FACTVIDEOADDITIVE_0";

select
    "DIMPAGETYPEGROUP_1"."PAGETYPEGROUP" as "c0",
    sum("FACTVIDEOADDITIVE_0"."VIDEODAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTVIDEOADDITIVE" as "FACTVIDEOADDITIVE_0" inner join "MSNDATAMART"."DIMPAGETYPEGROUP" as "DIMPAGETYPEGROUP_1" on "FACTVIDEOADDITIVE_0"."PAGETYPEGROUPKEY" = "DIMPAGETYPEGROUP_1"."PAGETYPEGROUPKEY"
group by
    "DIMPAGETYPEGROUP_1"."PAGETYPEGROUP"
order by
    "DIMPAGETYPEGROUP_1"."PAGETYPEGROUP" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-27') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-28') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-29') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-30'));

select
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-17') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-18') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-19'));

select
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-03') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-05') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-10') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-12') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-17') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718' and "DIMDATE_1"."DATE" = DATE '2020-07-18'));

select
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-10') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-12'));

select
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-03') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-05'));

select
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-20') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-21') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-22') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-23') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-24') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-25') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-26'));

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202006'
and
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202005'
and
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020')
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHNAME"
order by
    "DIMDATE_1"."MONTHKEY" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200425' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200502' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200328' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200404' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200411' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200418' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200425')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200328' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200404' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200425')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516' and "DIMDATE_1"."DATE" = DATE '2020-05-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516' and "DIMDATE_1"."DATE" = DATE '2020-05-17') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516' and "DIMDATE_1"."DATE" = DATE '2020-05-18') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516' and "DIMDATE_1"."DATE" = DATE '2020-05-19') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516' and "DIMDATE_1"."DATE" = DATE '2020-05-20') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516' and "DIMDATE_1"."DATE" = DATE '2020-05-21') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516' and "DIMDATE_1"."DATE" = DATE '2020-05-22'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200502' and "DIMDATE_1"."DATE" = DATE '2020-05-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200502' and "DIMDATE_1"."DATE" = DATE '2020-05-03') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200502' and "DIMDATE_1"."DATE" = DATE '2020-05-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200502' and "DIMDATE_1"."DATE" = DATE '2020-05-05') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200502' and "DIMDATE_1"."DATE" = DATE '2020-05-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200502' and "DIMDATE_1"."DATE" = DATE '2020-05-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200502' and "DIMDATE_1"."DATE" = DATE '2020-05-08'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509' and "DIMDATE_1"."DATE" = DATE '2020-05-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509' and "DIMDATE_1"."DATE" = DATE '2020-05-10') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509' and "DIMDATE_1"."DATE" = DATE '2020-05-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509' and "DIMDATE_1"."DATE" = DATE '2020-05-12') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509' and "DIMDATE_1"."DATE" = DATE '2020-05-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509' and "DIMDATE_1"."DATE" = DATE '2020-05-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509' and "DIMDATE_1"."DATE" = DATE '2020-05-15'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-05-30') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-05-31'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523' and "DIMDATE_1"."DATE" = DATE '2020-05-23') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523' and "DIMDATE_1"."DATE" = DATE '2020-05-24') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523' and "DIMDATE_1"."DATE" = DATE '2020-05-25') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523' and "DIMDATE_1"."DATE" = DATE '2020-05-26') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523' and "DIMDATE_1"."DATE" = DATE '2020-05-27') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523' and "DIMDATE_1"."DATE" = DATE '2020-05-28') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523' and "DIMDATE_1"."DATE" = DATE '2020-05-29'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200425' and "DIMDATE_1"."DATE" = DATE '2020-05-01');

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-03') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' and "DIMDATE_1"."DATE" = DATE '2020-06-05'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-10') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' and "DIMDATE_1"."DATE" = DATE '2020-06-12'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-03') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-05') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-10') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-12') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-17') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718' and "DIMDATE_1"."DATE" = DATE '2020-07-18'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-27') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-28') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-29') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-06-30'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-17') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-18') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' and "DIMDATE_1"."DATE" = DATE '2020-06-19'));

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYVISITORS") as "m1",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYVISITORS") as "m2"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-20') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-21') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-22') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-23') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-24') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-25') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' and "DIMDATE_1"."DATE" = DATE '2020-06-26'));

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200328' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200404')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."R28DAYSACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-03'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-12') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-17'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-05') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-10'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718' and "DIMDATE_1"."DATE" = DATE '2020-07-18');

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200328')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."R28DAYSACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202007'
and
    "DIMDATE_1"."YEAR" = '2020'
and
    "DIMDATE_1"."WEEKKEY" = '20200627'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYACTIVEUSERS") as "m0",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYVISITORS") as "m1"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."MONTHKEY" = '202007'
and
    "DIMDATE_1"."YEAR" = '2020'
and
    "DIMDATE_1"."WEEKKEY" = '20200627'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200425' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200502')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200328' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200411' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200418')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200328' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200404' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200425')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020')
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHNAME"
order by
    "DIMDATE_1"."MONTHKEY" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."R28DAYSAVERAGEDAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200328' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200404')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE"."YEAR" as "c0"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE"
where
    "DIMDATE"."YEAR" = '2020'
group by
    "DIMDATE"."YEAR"
order by
    "DIMDATE"."YEAR" ASC;

select
    "DIMADSTYPE"."ADSTYPE" as "c0"
from
    "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE"
where
    "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMADSTYPE"."ADSTYPE"
order by
    "DIMADSTYPE"."ADSTYPE" ASC;

select
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" as "c0"
from
    "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME"
where
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up'
group by
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME"
order by
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" ASC;

select
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c0"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMSOURCEGRAIN" as "DIMSOURCEGRAIN" on "VWFACTREVSHAREADDDAILY"."SOURCEGRAINKEY" = "DIMSOURCEGRAIN"."SOURCEGRAINKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up' and "DIMDATE"."YEAR" = '2020' and "DIMDATE"."MONTHKEY" = '202007' and "DIMDATE"."WEEKKEY" = '20200718' and "DIMDATE"."DATE" = DATE '2020-07-19' and "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMSOURCEGRAIN"."SOURCEGRAIN"
order by
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC
limit 50000;

select
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c0",
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP" as "c1"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPAGETYPEGROUP" as "DIMPAGETYPEGROUP" on "VWFACTREVSHAREADDDAILY"."PAGETYPEGROUPKEY" = "DIMPAGETYPEGROUP"."PAGETYPEGROUPKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMSOURCEGRAIN" as "DIMSOURCEGRAIN" on "VWFACTREVSHAREADDDAILY"."SOURCEGRAINKEY" = "DIMSOURCEGRAIN"."SOURCEGRAINKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up' and "DIMDATE"."YEAR" = '2020' and "DIMDATE"."MONTHKEY" = '202007' and "DIMDATE"."WEEKKEY" = '20200718' and "DIMDATE"."DATE" = DATE '2020-07-19' and "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMSOURCEGRAIN"."SOURCEGRAIN",
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP"
order by
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC,
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP" ASC
limit 50000;

select
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c0",
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP" as "c1",
    "DIMPAGETYPE"."PAGETYPE" as "c2"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPAGETYPE" as "DIMPAGETYPE" on "VWFACTREVSHAREADDDAILY"."PAGETYPEKEY" = "DIMPAGETYPE"."PAGETYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPAGETYPEGROUP" as "DIMPAGETYPEGROUP" on "VWFACTREVSHAREADDDAILY"."PAGETYPEGROUPKEY" = "DIMPAGETYPEGROUP"."PAGETYPEGROUPKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMSOURCEGRAIN" as "DIMSOURCEGRAIN" on "VWFACTREVSHAREADDDAILY"."SOURCEGRAINKEY" = "DIMSOURCEGRAIN"."SOURCEGRAINKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up' and "DIMDATE"."YEAR" = '2020' and "DIMDATE"."MONTHKEY" = '202007' and "DIMDATE"."WEEKKEY" = '20200718' and "DIMDATE"."DATE" = DATE '2020-07-19' and "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMSOURCEGRAIN"."SOURCEGRAIN",
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP",
    "DIMPAGETYPE"."PAGETYPE"
order by
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC,
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP" ASC,
    "DIMPAGETYPE"."PAGETYPE" ASC
limit 50000;

select
    "DIMDATE"."MONTHKEY" as "c0",
    "DIMDATE"."YEAR" as "c1",
    "DIMDATE"."WEEKKEY" as "c2",
    "DIMDATE"."DATE" as "c3",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" as "c4",
    "DIMADSTYPE"."ADSTYPE" as "c5",
    sum("VWFACTREVSHAREADDDAILY"."REVENUEPAGEVIEWS") as "m0",
    sum("VWFACTREVSHAREADDDAILY"."VIDEOSTARTS") as "m1"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMDATE"."MONTHKEY" = '202007'
and
    "DIMDATE"."YEAR" = '2020'
and
    "DIMDATE"."WEEKKEY" = '20200718'
and
    "DIMDATE"."DATE" = DATE '2020-07-19'
and
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up'
and
    "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMDATE"."MONTHKEY",
    "DIMDATE"."YEAR",
    "DIMDATE"."WEEKKEY",
    "DIMDATE"."DATE",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME",
    "DIMADSTYPE"."ADSTYPE"
order by
    "DIMDATE"."MONTHKEY" ASC,
    "DIMDATE"."YEAR" ASC,
    "DIMDATE"."WEEKKEY" ASC,
    "DIMDATE"."DATE" ASC,
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" ASC,
    "DIMADSTYPE"."ADSTYPE" ASC;

select
    "DIMDATE"."MONTHKEY" as "c0",
    "DIMDATE"."YEAR" as "c1",
    "DIMDATE"."WEEKKEY" as "c2",
    "DIMDATE"."DATE" as "c3",
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP" as "c4",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" as "c5",
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c6",
    "DIMADSTYPE"."ADSTYPE" as "c7",
    sum("VWFACTREVSHAREADDDAILY"."REVENUEPAGEVIEWS") as "m0",
    sum("VWFACTREVSHAREADDDAILY"."VIDEOSTARTS") as "m1"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPAGETYPEGROUP" as "DIMPAGETYPEGROUP" on "VWFACTREVSHAREADDDAILY"."PAGETYPEGROUPKEY" = "DIMPAGETYPEGROUP"."PAGETYPEGROUPKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMSOURCEGRAIN" as "DIMSOURCEGRAIN" on "VWFACTREVSHAREADDDAILY"."SOURCEGRAINKEY" = "DIMSOURCEGRAIN"."SOURCEGRAINKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMDATE"."MONTHKEY" = '202007'
and
    "DIMDATE"."YEAR" = '2020'
and
    "DIMDATE"."WEEKKEY" = '20200718'
and
    "DIMDATE"."DATE" = DATE '2020-07-19'
and
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up'
and
    "DIMSOURCEGRAIN"."SOURCEGRAIN" = 'Rid'
and
    "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMDATE"."MONTHKEY",
    "DIMDATE"."YEAR",
    "DIMDATE"."WEEKKEY",
    "DIMDATE"."DATE",
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME",
    "DIMSOURCEGRAIN"."SOURCEGRAIN",
    "DIMADSTYPE"."ADSTYPE"
order by
    "DIMDATE"."MONTHKEY" ASC,
    "DIMDATE"."YEAR" ASC,
    "DIMDATE"."WEEKKEY" ASC,
    "DIMDATE"."DATE" ASC,
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP" ASC,
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" ASC,
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC,
    "DIMADSTYPE"."ADSTYPE" ASC;

select
    "DIMDATE"."MONTHKEY" as "c0",
    "DIMDATE"."YEAR" as "c1",
    "DIMDATE"."WEEKKEY" as "c2",
    "DIMDATE"."DATE" as "c3",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" as "c4",
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c5",
    "DIMADSTYPE"."ADSTYPE" as "c6",
    sum("VWFACTREVSHAREADDDAILY"."REVENUEPAGEVIEWS") as "m0",
    sum("VWFACTREVSHAREADDDAILY"."VIDEOSTARTS") as "m1"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMSOURCEGRAIN" as "DIMSOURCEGRAIN" on "VWFACTREVSHAREADDDAILY"."SOURCEGRAINKEY" = "DIMSOURCEGRAIN"."SOURCEGRAINKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMDATE"."MONTHKEY" = '202007'
and
    "DIMDATE"."YEAR" = '2020'
and
    "DIMDATE"."WEEKKEY" = '20200718'
and
    "DIMDATE"."DATE" = DATE '2020-07-19'
and
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up'
and
    "DIMSOURCEGRAIN"."SOURCEGRAIN" = 'Rid'
and
    "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMDATE"."MONTHKEY",
    "DIMDATE"."YEAR",
    "DIMDATE"."WEEKKEY",
    "DIMDATE"."DATE",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME",
    "DIMSOURCEGRAIN"."SOURCEGRAIN",
    "DIMADSTYPE"."ADSTYPE"
order by
    "DIMDATE"."MONTHKEY" ASC,
    "DIMDATE"."YEAR" ASC,
    "DIMDATE"."WEEKKEY" ASC,
    "DIMDATE"."DATE" ASC,
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" ASC,
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC,
    "DIMADSTYPE"."ADSTYPE" ASC;

select
    "DIMDATE"."MONTHKEY" as "c0",
    "DIMDATE"."YEAR" as "c1",
    "DIMDATE"."WEEKKEY" as "c2",
    "DIMDATE"."DATE" as "c3",
    "DIMPAGETYPE"."PAGETYPE" as "c4",
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP" as "c5",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" as "c6",
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c7",
    "DIMADSTYPE"."ADSTYPE" as "c8",
    sum("VWFACTREVSHAREADDDAILY"."REVENUEPAGEVIEWS") as "m0",
    sum("VWFACTREVSHAREADDDAILY"."VIDEOSTARTS") as "m1"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPAGETYPE" as "DIMPAGETYPE" on "VWFACTREVSHAREADDDAILY"."PAGETYPEKEY" = "DIMPAGETYPE"."PAGETYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPAGETYPEGROUP" as "DIMPAGETYPEGROUP" on "VWFACTREVSHAREADDDAILY"."PAGETYPEGROUPKEY" = "DIMPAGETYPEGROUP"."PAGETYPEGROUPKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMSOURCEGRAIN" as "DIMSOURCEGRAIN" on "VWFACTREVSHAREADDDAILY"."SOURCEGRAINKEY" = "DIMSOURCEGRAIN"."SOURCEGRAINKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMDATE"."MONTHKEY" = '202007'
and
    "DIMDATE"."YEAR" = '2020'
and
    "DIMDATE"."WEEKKEY" = '20200718'
and
    "DIMDATE"."DATE" = DATE '2020-07-19'
and
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up'
and
    "DIMSOURCEGRAIN"."SOURCEGRAIN" = 'Rid'
and
    "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMDATE"."MONTHKEY",
    "DIMDATE"."YEAR",
    "DIMDATE"."WEEKKEY",
    "DIMDATE"."DATE",
    "DIMPAGETYPE"."PAGETYPE",
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME",
    "DIMSOURCEGRAIN"."SOURCEGRAIN",
    "DIMADSTYPE"."ADSTYPE"
order by
    "DIMDATE"."MONTHKEY" ASC,
    "DIMDATE"."YEAR" ASC,
    "DIMDATE"."WEEKKEY" ASC,
    "DIMDATE"."DATE" ASC,
    "DIMPAGETYPE"."PAGETYPE" ASC,
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP" ASC,
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" ASC,
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC,
    "DIMADSTYPE"."ADSTYPE" ASC;

select
    "DIMDATE"."MONTHKEY" as "c0",
    "DIMDATE"."YEAR" as "c1",
    "DIMDATE"."WEEKKEY" as "c2",
    "DIMDATE"."DATE" as "c3",
    "DIMPLACEMENT"."PLACEMENT" as "c4",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" as "c5",
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c6",
    "DIMADSTYPE"."ADSTYPE" as "c7",
    sum("VWFACTREVSHAREADDDAILY"."PAGEVIEWS") as "m0"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPLACEMENT" as "DIMPLACEMENT" on "VWFACTREVSHAREADDDAILY"."PLACEMENTKEY" = "DIMPLACEMENT"."PLACEMENTKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMSOURCEGRAIN" as "DIMSOURCEGRAIN" on "VWFACTREVSHAREADDDAILY"."SOURCEGRAINKEY" = "DIMSOURCEGRAIN"."SOURCEGRAINKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMDATE"."MONTHKEY" = '202007'
and
    "DIMDATE"."YEAR" = '2020'
and
    "DIMDATE"."WEEKKEY" = '20200718'
and
    "DIMDATE"."DATE" = DATE '2020-07-19'
and
    "DIMPLACEMENT"."PLACEMENT" = 'All Up'
and
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up'
and
    "DIMSOURCEGRAIN"."SOURCEGRAIN" = 'Rid'
and
    "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMDATE"."MONTHKEY",
    "DIMDATE"."YEAR",
    "DIMDATE"."WEEKKEY",
    "DIMDATE"."DATE",
    "DIMPLACEMENT"."PLACEMENT",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME",
    "DIMSOURCEGRAIN"."SOURCEGRAIN",
    "DIMADSTYPE"."ADSTYPE"
order by
    "DIMDATE"."MONTHKEY" ASC,
    "DIMDATE"."YEAR" ASC,
    "DIMDATE"."WEEKKEY" ASC,
    "DIMDATE"."DATE" ASC,
    "DIMPLACEMENT"."PLACEMENT" ASC,
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" ASC,
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC,
    "DIMADSTYPE"."ADSTYPE" ASC;

select
    "DIMDATE"."MONTHKEY" as "c0",
    "DIMDATE"."YEAR" as "c1",
    "DIMDATE"."WEEKKEY" as "c2",
    "DIMDATE"."DATE" as "c3",
    "DIMPLACEMENT"."PLACEMENT" as "c4",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" as "c5",
    "DIMADSTYPE"."ADSTYPE" as "c6",
    sum("VWFACTREVSHAREADDDAILY"."PAGEVIEWS") as "m0"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPLACEMENT" as "DIMPLACEMENT" on "VWFACTREVSHAREADDDAILY"."PLACEMENTKEY" = "DIMPLACEMENT"."PLACEMENTKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMDATE"."MONTHKEY" = '202007'
and
    "DIMDATE"."YEAR" = '2020'
and
    "DIMDATE"."WEEKKEY" = '20200718'
and
    "DIMDATE"."DATE" = DATE '2020-07-19'
and
    "DIMPLACEMENT"."PLACEMENT" = 'All Up'
and
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up'
and
    "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMDATE"."MONTHKEY",
    "DIMDATE"."YEAR",
    "DIMDATE"."WEEKKEY",
    "DIMDATE"."DATE",
    "DIMPLACEMENT"."PLACEMENT",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME",
    "DIMADSTYPE"."ADSTYPE"
order by
    "DIMDATE"."MONTHKEY" ASC,
    "DIMDATE"."YEAR" ASC,
    "DIMDATE"."WEEKKEY" ASC,
    "DIMDATE"."DATE" ASC,
    "DIMPLACEMENT"."PLACEMENT" ASC,
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" ASC,
    "DIMADSTYPE"."ADSTYPE" ASC;

select
    "DIMDATE"."MONTHKEY" as "c0",
    "DIMDATE"."YEAR" as "c1",
    "DIMDATE"."WEEKKEY" as "c2",
    "DIMDATE"."DATE" as "c3",
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP" as "c4",
    "DIMPLACEMENT"."PLACEMENT" as "c5",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" as "c6",
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c7",
    "DIMADSTYPE"."ADSTYPE" as "c8",
    sum("VWFACTREVSHAREADDDAILY"."PAGEVIEWS") as "m0"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPAGETYPEGROUP" as "DIMPAGETYPEGROUP" on "VWFACTREVSHAREADDDAILY"."PAGETYPEGROUPKEY" = "DIMPAGETYPEGROUP"."PAGETYPEGROUPKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPLACEMENT" as "DIMPLACEMENT" on "VWFACTREVSHAREADDDAILY"."PLACEMENTKEY" = "DIMPLACEMENT"."PLACEMENTKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMSOURCEGRAIN" as "DIMSOURCEGRAIN" on "VWFACTREVSHAREADDDAILY"."SOURCEGRAINKEY" = "DIMSOURCEGRAIN"."SOURCEGRAINKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMDATE"."MONTHKEY" = '202007'
and
    "DIMDATE"."YEAR" = '2020'
and
    "DIMDATE"."WEEKKEY" = '20200718'
and
    "DIMDATE"."DATE" = DATE '2020-07-19'
and
    "DIMPLACEMENT"."PLACEMENT" = 'All Up'
and
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up'
and
    "DIMSOURCEGRAIN"."SOURCEGRAIN" = 'Rid'
and
    "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMDATE"."MONTHKEY",
    "DIMDATE"."YEAR",
    "DIMDATE"."WEEKKEY",
    "DIMDATE"."DATE",
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP",
    "DIMPLACEMENT"."PLACEMENT",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME",
    "DIMSOURCEGRAIN"."SOURCEGRAIN",
    "DIMADSTYPE"."ADSTYPE"
order by
    "DIMDATE"."MONTHKEY" ASC,
    "DIMDATE"."YEAR" ASC,
    "DIMDATE"."WEEKKEY" ASC,
    "DIMDATE"."DATE" ASC,
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP" ASC,
    "DIMPLACEMENT"."PLACEMENT" ASC,
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" ASC,
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC,
    "DIMADSTYPE"."ADSTYPE" ASC;

select
    "DIMDATE"."MONTHKEY" as "c0",
    "DIMDATE"."YEAR" as "c1",
    "DIMDATE"."WEEKKEY" as "c2",
    "DIMDATE"."DATE" as "c3",
    "DIMPAGETYPE"."PAGETYPE" as "c4",
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP" as "c5",
    "DIMPLACEMENT"."PLACEMENT" as "c6",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" as "c7",
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c8",
    "DIMADSTYPE"."ADSTYPE" as "c9",
    sum("VWFACTREVSHAREADDDAILY"."PAGEVIEWS") as "m0"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPAGETYPE" as "DIMPAGETYPE" on "VWFACTREVSHAREADDDAILY"."PAGETYPEKEY" = "DIMPAGETYPE"."PAGETYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPLACEMENT" as "DIMPLACEMENT" on "VWFACTREVSHAREADDDAILY"."PLACEMENTKEY" = "DIMPLACEMENT"."PLACEMENTKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMSOURCEGRAIN" as "DIMSOURCEGRAIN" on "VWFACTREVSHAREADDDAILY"."SOURCEGRAINKEY" = "DIMSOURCEGRAIN"."SOURCEGRAINKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPAGETYPEGROUP" as "DIMPAGETYPEGROUP" on "VWFACTREVSHAREADDDAILY"."PAGETYPEGROUPKEY" = "DIMPAGETYPEGROUP"."PAGETYPEGROUPKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY"
where
    "DIMDATE"."MONTHKEY" = '202007'
and
    "DIMDATE"."YEAR" = '2020'
and
    "DIMDATE"."WEEKKEY" = '20200718'
and
    "DIMDATE"."DATE" = DATE '2020-07-19'
and
    "DIMPLACEMENT"."PLACEMENT" = 'All Up'
and
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up'
and
    "DIMSOURCEGRAIN"."SOURCEGRAIN" = 'Rid'
and
    "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMDATE"."MONTHKEY",
    "DIMDATE"."YEAR",
    "DIMDATE"."WEEKKEY",
    "DIMDATE"."DATE",
    "DIMPAGETYPE"."PAGETYPE",
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP",
    "DIMPLACEMENT"."PLACEMENT",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME",
    "DIMSOURCEGRAIN"."SOURCEGRAIN",
    "DIMADSTYPE"."ADSTYPE"
order by
    "DIMDATE"."MONTHKEY" ASC,
    "DIMDATE"."YEAR" ASC,
    "DIMDATE"."WEEKKEY" ASC,
    "DIMDATE"."DATE" ASC,
    "DIMPAGETYPE"."PAGETYPE" ASC,
    "DIMPAGETYPEGROUP"."PAGETYPEGROUP" ASC,
    "DIMPLACEMENT"."PLACEMENT" ASC,
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" ASC,
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC,
    "DIMADSTYPE"."ADSTYPE" ASC;

select
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c0",
    "DIMPAGETYPE"."PAGETYPE" as "c1"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPAGETYPE" as "DIMPAGETYPE" on "VWFACTREVSHAREADDDAILY"."PAGETYPEKEY" = "DIMPAGETYPE"."PAGETYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMSOURCEGRAIN" as "DIMSOURCEGRAIN" on "VWFACTREVSHAREADDDAILY"."SOURCEGRAINKEY" = "DIMSOURCEGRAIN"."SOURCEGRAINKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up' and "DIMDATE"."YEAR" = '2020' and "DIMDATE"."MONTHKEY" = '202007' and "DIMDATE"."WEEKKEY" = '20200718' and "DIMDATE"."DATE" = DATE '2020-07-19' and "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMSOURCEGRAIN"."SOURCEGRAIN",
    "DIMPAGETYPE"."PAGETYPE"
order by
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC,
    "DIMPAGETYPE"."PAGETYPE" ASC
limit 50000;

select
    "DIMDATE"."MONTHKEY" as "c0",
    "DIMDATE"."YEAR" as "c1",
    "DIMDATE"."WEEKKEY" as "c2",
    "DIMDATE"."DATE" as "c3",
    "DIMPAGETYPE"."PAGETYPE" as "c4",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" as "c5",
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c6",
    "DIMADSTYPE"."ADSTYPE" as "c7",
    sum("VWFACTREVSHAREADDDAILY"."REVENUEPAGEVIEWS") as "m0",
    sum("VWFACTREVSHAREADDDAILY"."VIDEOSTARTS") as "m1"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPAGETYPE" as "DIMPAGETYPE" on "VWFACTREVSHAREADDDAILY"."PAGETYPEKEY" = "DIMPAGETYPE"."PAGETYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMSOURCEGRAIN" as "DIMSOURCEGRAIN" on "VWFACTREVSHAREADDDAILY"."SOURCEGRAINKEY" = "DIMSOURCEGRAIN"."SOURCEGRAINKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMDATE"."MONTHKEY" = '202007'
and
    "DIMDATE"."YEAR" = '2020'
and
    "DIMDATE"."WEEKKEY" = '20200718'
and
    "DIMDATE"."DATE" = DATE '2020-07-19'
and
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up'
and
    "DIMSOURCEGRAIN"."SOURCEGRAIN" = 'Rid'
and
    "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMDATE"."MONTHKEY",
    "DIMDATE"."YEAR",
    "DIMDATE"."WEEKKEY",
    "DIMDATE"."DATE",
    "DIMPAGETYPE"."PAGETYPE",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME",
    "DIMSOURCEGRAIN"."SOURCEGRAIN",
    "DIMADSTYPE"."ADSTYPE"
order by
    "DIMDATE"."MONTHKEY" ASC,
    "DIMDATE"."YEAR" ASC,
    "DIMDATE"."WEEKKEY" ASC,
    "DIMDATE"."DATE" ASC,
    "DIMPAGETYPE"."PAGETYPE" ASC,
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" ASC,
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC,
    "DIMADSTYPE"."ADSTYPE" ASC;

select
    "DIMDATE"."MONTHKEY" as "c0",
    "DIMDATE"."YEAR" as "c1",
    "DIMDATE"."WEEKKEY" as "c2",
    "DIMDATE"."DATE" as "c3",
    "DIMPAGETYPE"."PAGETYPE" as "c4",
    "DIMPLACEMENT"."PLACEMENT" as "c5",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" as "c6",
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c7",
    "DIMADSTYPE"."ADSTYPE" as "c8",
    sum("VWFACTREVSHAREADDDAILY"."PAGEVIEWS") as "m0"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPAGETYPE" as "DIMPAGETYPE" on "VWFACTREVSHAREADDDAILY"."PAGETYPEKEY" = "DIMPAGETYPE"."PAGETYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPLACEMENT" as "DIMPLACEMENT" on "VWFACTREVSHAREADDDAILY"."PLACEMENTKEY" = "DIMPLACEMENT"."PLACEMENTKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMSOURCEGRAIN" as "DIMSOURCEGRAIN" on "VWFACTREVSHAREADDDAILY"."SOURCEGRAINKEY" = "DIMSOURCEGRAIN"."SOURCEGRAINKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMDATE"."MONTHKEY" = '202007'
and
    "DIMDATE"."YEAR" = '2020'
and
    "DIMDATE"."WEEKKEY" = '20200718'
and
    "DIMDATE"."DATE" = DATE '2020-07-19'
and
    "DIMPLACEMENT"."PLACEMENT" = 'All Up'
and
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up'
and
    "DIMSOURCEGRAIN"."SOURCEGRAIN" = 'Rid'
and
    "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMDATE"."MONTHKEY",
    "DIMDATE"."YEAR",
    "DIMDATE"."WEEKKEY",
    "DIMDATE"."DATE",
    "DIMPAGETYPE"."PAGETYPE",
    "DIMPLACEMENT"."PLACEMENT",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME",
    "DIMSOURCEGRAIN"."SOURCEGRAIN",
    "DIMADSTYPE"."ADSTYPE"
order by
    "DIMDATE"."MONTHKEY" ASC,
    "DIMDATE"."YEAR" ASC,
    "DIMDATE"."WEEKKEY" ASC,
    "DIMDATE"."DATE" ASC,
    "DIMPAGETYPE"."PAGETYPE" ASC,
    "DIMPLACEMENT"."PLACEMENT" ASC,
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" ASC,
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC,
    "DIMADSTYPE"."ADSTYPE" ASC;

select
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c0",
    "DIMBROWSER"."BROWSER" as "c1"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMSOURCEGRAIN" as "DIMSOURCEGRAIN" on "VWFACTREVSHAREADDDAILY"."SOURCEGRAINKEY" = "DIMSOURCEGRAIN"."SOURCEGRAINKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMBROWSER" as "DIMBROWSER" on "VWFACTREVSHAREADDDAILY"."BROWSERKEY" = "DIMBROWSER"."BROWSERKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up' and "DIMDATE"."YEAR" = '2020' and "DIMDATE"."MONTHKEY" = '202007' and "DIMDATE"."WEEKKEY" = '20200718' and "DIMDATE"."DATE" = DATE '2020-07-19' and "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMSOURCEGRAIN"."SOURCEGRAIN",
    "DIMBROWSER"."BROWSER"
order by
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC,
    "DIMBROWSER"."BROWSER" ASC
limit 50000;

select
    "DIMDATE"."MONTHKEY" as "c0",
    "DIMDATE"."YEAR" as "c1",
    "DIMDATE"."WEEKKEY" as "c2",
    "DIMDATE"."DATE" as "c3",
    "DIMBROWSER"."BROWSER" as "c4",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" as "c5",
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c6",
    "DIMADSTYPE"."ADSTYPE" as "c7",
    sum("VWFACTREVSHAREADDDAILY"."REVENUEPAGEVIEWS") as "m0",
    sum("VWFACTREVSHAREADDDAILY"."VIDEOSTARTS") as "m1"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMSOURCEGRAIN" as "DIMSOURCEGRAIN" on "VWFACTREVSHAREADDDAILY"."SOURCEGRAINKEY" = "DIMSOURCEGRAIN"."SOURCEGRAINKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMBROWSER" as "DIMBROWSER" on "VWFACTREVSHAREADDDAILY"."BROWSERKEY" = "DIMBROWSER"."BROWSERKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMDATE"."MONTHKEY" = '202007'
and
    "DIMDATE"."YEAR" = '2020'
and
    "DIMDATE"."WEEKKEY" = '20200718'
and
    "DIMDATE"."DATE" = DATE '2020-07-19'
and
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up'
and
    "DIMSOURCEGRAIN"."SOURCEGRAIN" = 'Rid'
and
    "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMDATE"."MONTHKEY",
    "DIMDATE"."YEAR",
    "DIMDATE"."WEEKKEY",
    "DIMDATE"."DATE",
    "DIMBROWSER"."BROWSER",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME",
    "DIMSOURCEGRAIN"."SOURCEGRAIN",
    "DIMADSTYPE"."ADSTYPE"
order by
    "DIMDATE"."MONTHKEY" ASC,
    "DIMDATE"."YEAR" ASC,
    "DIMDATE"."WEEKKEY" ASC,
    "DIMDATE"."DATE" ASC,
    "DIMBROWSER"."BROWSER" ASC,
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" ASC,
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC,
    "DIMADSTYPE"."ADSTYPE" ASC;

select
    "DIMDATE"."MONTHKEY" as "c0",
    "DIMDATE"."YEAR" as "c1",
    "DIMDATE"."WEEKKEY" as "c2",
    "DIMDATE"."DATE" as "c3",
    "DIMPLACEMENT"."PLACEMENT" as "c4",
    "DIMBROWSER"."BROWSER" as "c5",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" as "c6",
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c7",
    "DIMADSTYPE"."ADSTYPE" as "c8",
    sum("VWFACTREVSHAREADDDAILY"."PAGEVIEWS") as "m0"
from
    "MSNREVENUESHAREDATAMARTUAT"."VWFACTREVSHAREADDDAILY" as "VWFACTREVSHAREADDDAILY" inner join "MSNREVENUESHAREDATAMARTUAT"."VWDIMDATE" as "DIMDATE" on "VWFACTREVSHAREADDDAILY"."DATEKEY" = "DIMDATE"."DATEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMPLACEMENT" as "DIMPLACEMENT" on "VWFACTREVSHAREADDDAILY"."PLACEMENTKEY" = "DIMPLACEMENT"."PLACEMENTKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMADSTYPE" as "DIMADSTYPE" on "VWFACTREVSHAREADDDAILY"."ADSTYPEKEY" = "DIMADSTYPE"."ADSTYPEKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMSOURCEGRAIN" as "DIMSOURCEGRAIN" on "VWFACTREVSHAREADDDAILY"."SOURCEGRAINKEY" = "DIMSOURCEGRAIN"."SOURCEGRAINKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMBROWSER" as "DIMBROWSER" on "VWFACTREVSHAREADDDAILY"."BROWSERKEY" = "DIMBROWSER"."BROWSERKEY" inner join "MSNREVENUESHAREDATAMARTUAT"."DIMMONETIZATIONPARTNERNAME" as "DIMMONETIZATIONPARTNERNAME" on "VWFACTREVSHAREADDDAILY"."MONETIZATIONPARTNERNAMEKEY" = "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAMEKEY"
where
    "DIMDATE"."MONTHKEY" = '202007'
and
    "DIMDATE"."YEAR" = '2020'
and
    "DIMDATE"."WEEKKEY" = '20200718'
and
    "DIMDATE"."DATE" = DATE '2020-07-19'
and
    "DIMPLACEMENT"."PLACEMENT" = 'All Up'
and
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up'
and
    "DIMSOURCEGRAIN"."SOURCEGRAIN" = 'Rid'
and
    "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMDATE"."MONTHKEY",
    "DIMDATE"."YEAR",
    "DIMDATE"."WEEKKEY",
    "DIMDATE"."DATE",
    "DIMPLACEMENT"."PLACEMENT",
    "DIMBROWSER"."BROWSER",
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME",
    "DIMSOURCEGRAIN"."SOURCEGRAIN",
    "DIMADSTYPE"."ADSTYPE"
order by
    "DIMDATE"."MONTHKEY" ASC,
    "DIMDATE"."YEAR" ASC,
    "DIMDATE"."WEEKKEY" ASC,
    "DIMDATE"."DATE" ASC,
    "DIMPLACEMENT"."PLACEMENT" ASC,
    "DIMBROWSER"."BROWSER" ASC,
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" ASC,
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC,
    "DIMADSTYPE"."ADSTYPE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020')
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHNAME"
order by
    "DIMDATE_1"."MONTHKEY" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
group by
    "DIMDATE_1"."YEAR"
order by
    "DIMDATE_1"."YEAR" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200425')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200502')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."WEEKKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEK" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004')
group by
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEK"
order by
    "DIMDATE_1"."WEEKKEY" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200328' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200404' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200411' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200418' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200425')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200530' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200606' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200613' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200620' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' and "DIMDATE_1"."WEEKKEY" = '20200627')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200509' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200516' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200523' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' and "DIMDATE_1"."WEEKKEY" = '20200530')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200328' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200404' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004' and "DIMDATE_1"."WEEKKEY" = '20200425')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    max("FACTAPPANDUSERACTIONNONADDITIVE_1"."DAILYVISITORS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select * from (select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004')
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC) limit 50000;

select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1"
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004'));

select
    "DIMBROWSER_1"."BROWSER" as "c0",
    count(*) as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004'))
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select * from (select "c0" from ( select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONNONADDITIVE" as "FACTAPPANDUSERACTIONNONADDITIVE_1" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONNONADDITIVE_1"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004')
group by
    "DIMBROWSER_1"."BROWSER"
union
select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004')
group by
    "DIMBROWSER_1"."BROWSER"
order by
    1 ASC)) limit 50000;

select * from (select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004')
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC) limit 50000;

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004'));

select
    "DIMBROWSER_1"."BROWSER" as "c0",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202006') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202005') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202004'))
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select * from (select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC) limit 50000;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."MONTHKEY" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."WEEKKEY" as "c2",
    "DIMDATE_1"."DATE" as "c3",
    "DIMBROWSER_1"."BROWSER" as "c4",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
where
    "DIMDATE_1"."YEAR" = '2020'
group by
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."DATE",
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC,
    "DIMBROWSER_1"."BROWSER" ASC;

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-03') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-05') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-10') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-12') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-17') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718' and "DIMDATE_1"."DATE" = DATE '2020-07-18'));

select
    "DIMBROWSER_1"."BROWSER" as "c0",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-03') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-05') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-10') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-12') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-17') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718' and "DIMDATE_1"."DATE" = DATE '2020-07-18'))
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    "DIMBROWSER_1"."BROWSER" as "c0",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718' and "DIMDATE_1"."DATE" = DATE '2020-07-18')
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-03'));

select
    "DIMBROWSER_1"."BROWSER" as "c0",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-01') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-02') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' and "DIMDATE_1"."DATE" = DATE '2020-07-03'))
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    "DIMBROWSER_1"."BROWSER" as "c0",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-12') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-17'))
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    "DIMBROWSER_1"."BROWSER" as "c0",
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-05') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-10'))
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-04') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-05') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-06') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-07') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-08') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-09') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704' and "DIMDATE_1"."DATE" = DATE '2020-07-10'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-11') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-12') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-13') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-14') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-15') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-16') or ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200711' and "DIMDATE_1"."DATE" = DATE '2020-07-17'));

select
    sum("FACTAPPANDUSERACTIONADDITIVE_0"."DAILYACTIONS") as "m0"
from
    "MSNDATAMART"."FACTAPPANDUSERACTIONADDITIVE" as "FACTAPPANDUSERACTIONADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTAPPANDUSERACTIONADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718' and "DIMDATE_1"."DATE" = DATE '2020-07-18');

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMDATE_1"."YEAR" as "c1",
    "DIMDATE_1"."MONTHKEY" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200718')
group by
    "DIMDATE_1"."DATE",
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."WEEKKEY"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."YEAR" as "c0",
    "DIMDATE_1"."MONTHKEY" as "c1",
    "DIMDATE_1"."MONTHNAME" as "c2",
    "DIMDATE_1"."WEEKKEY" as "c3",
    "DIMDATE_1"."WEEK" as "c4",
    "DIMDATE_1"."DATE" as "c5"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    ("DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200627' or "DIMDATE_1"."YEAR" = '2020' and "DIMDATE_1"."MONTHKEY" = '202007' and "DIMDATE_1"."WEEKKEY" = '20200704')
group by
    "DIMDATE_1"."YEAR",
    "DIMDATE_1"."MONTHKEY",
    "DIMDATE_1"."MONTHNAME",
    "DIMDATE_1"."WEEKKEY",
    "DIMDATE_1"."WEEK",
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."YEAR" ASC,
    "DIMDATE_1"."MONTHKEY" ASC,
    "DIMDATE_1"."WEEKKEY" ASC,
    "DIMDATE_1"."DATE" ASC;

select * from (select "c0" from ( select
    "DIMCONTENTTYPE_1"."CONTENTTYPE" as "c0"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0" inner join "MSNDATAMART"."DIMCONTENTTYPE" as "DIMCONTENTTYPE_1" on "FACTSEARCHADDITIVE_0"."CONTENTTYPEKEY" = "DIMCONTENTTYPE_1"."CONTENTTYPEKEY"
group by
    "DIMCONTENTTYPE_1"."CONTENTTYPE"
union
select
    "DIMCONTENTTYPE_1"."CONTENTTYPE" as "c0"
from
    "MSNDATAMART"."FACTSEARCHNONADDITIVE" as "FACTSEARCHNONADDITIVE_1" inner join "MSNDATAMART"."DIMCONTENTTYPE" as "DIMCONTENTTYPE_1" on "FACTSEARCHNONADDITIVE_1"."CONTENTTYPEKEY" = "DIMCONTENTTYPE_1"."CONTENTTYPEKEY"
group by
    "DIMCONTENTTYPE_1"."CONTENTTYPE"
order by
    1 ASC)) limit 50000;

select
    sum("FACTSEARCHADDITIVE_0"."DAILYSEARCHES") as "m0"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0";

select
    "DIMCONTENTTYPE_1"."CONTENTTYPE" as "c0",
    max("FACTSEARCHNONADDITIVE_1"."SEARCHR28DAYSACTIVEUSERS") as "m0",
    max("FACTSEARCHNONADDITIVE_1"."SEARCHR28DAYSVISITORS") as "m1"
from
    "MSNDATAMART"."FACTSEARCHNONADDITIVE" as "FACTSEARCHNONADDITIVE_1" inner join "MSNDATAMART"."DIMCONTENTTYPE" as "DIMCONTENTTYPE_1" on "FACTSEARCHNONADDITIVE_1"."CONTENTTYPEKEY" = "DIMCONTENTTYPE_1"."CONTENTTYPEKEY"
where
    "DIMCONTENTTYPE_1"."CONTENTTYPE" = 'All Up'
group by
    "DIMCONTENTTYPE_1"."CONTENTTYPE"
order by
    "DIMCONTENTTYPE_1"."CONTENTTYPE" ASC;

select
    "DIMCONTENTTYPE_1"."CONTENTTYPE" as "c0",
    sum("FACTSEARCHADDITIVE_0"."DAILYSEARCHES") as "m0",
    sum("FACTSEARCHADDITIVE_0"."SEARCHDAILYPAGEVIEWS") as "m1"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0" inner join "MSNDATAMART"."DIMCONTENTTYPE" as "DIMCONTENTTYPE_1" on "FACTSEARCHADDITIVE_0"."CONTENTTYPEKEY" = "DIMCONTENTTYPE_1"."CONTENTTYPEKEY"
where
    "DIMCONTENTTYPE_1"."CONTENTTYPE" = 'All Up'
group by
    "DIMCONTENTTYPE_1"."CONTENTTYPE"
order by
    "DIMCONTENTTYPE_1"."CONTENTTYPE" ASC;

select
    sum("FACTSEARCHADDITIVE_0"."SEARCHDAILYPAGEVIEWS") as "m0"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0";

select
    max("FACTSEARCHNONADDITIVE_1"."SEARCHR28DAYSACTIVEUSERS") as "m0",
    max("FACTSEARCHNONADDITIVE_1"."SEARCHR28DAYSVISITORS") as "m1"
from
    "MSNDATAMART"."FACTSEARCHNONADDITIVE" as "FACTSEARCHNONADDITIVE_1";

select * from (select "c0" from ( select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTSEARCHADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
group by
    "DIMBROWSER_1"."BROWSER"
union
select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."FACTSEARCHNONADDITIVE" as "FACTSEARCHNONADDITIVE_1" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTSEARCHNONADDITIVE_1"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
group by
    "DIMBROWSER_1"."BROWSER"
order by
    1 ASC)) limit 50000;

select
    "DIMBROWSER_1"."BROWSER" as "c0",
    max("FACTSEARCHNONADDITIVE_1"."SEARCHR28DAYSACTIVEUSERS") as "m0",
    max("FACTSEARCHNONADDITIVE_1"."SEARCHR28DAYSVISITORS") as "m1"
from
    "MSNDATAMART"."FACTSEARCHNONADDITIVE" as "FACTSEARCHNONADDITIVE_1" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTSEARCHNONADDITIVE_1"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    "DIMBROWSER_1"."BROWSER" as "c0",
    sum("FACTSEARCHADDITIVE_0"."DAILYSEARCHES") as "m0",
    sum("FACTSEARCHADDITIVE_0"."SEARCHDAILYPAGEVIEWS") as "m1"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTSEARCHADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select * from (select
    "DIMBROWSER_1"."BROWSER" as "c0"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTSEARCHADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC) limit 50000;

select * from (select
    "DIMDATE_1"."DATE" as "c0"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTSEARCHADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
group by
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."DATE" ASC) limit 50000;

select
    "DIMDATE_1"."DATE" as "c0",
    sum("FACTSEARCHADDITIVE_0"."SEARCHDAILYPAGEVIEWS") as "m0"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTSEARCHADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
group by
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0",
    "DIMBROWSER_1"."BROWSER" as "c1",
    sum("FACTSEARCHADDITIVE_0"."SEARCHDAILYPAGEVIEWS") as "m0"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTSEARCHADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTSEARCHADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
group by
    "DIMDATE_1"."DATE",
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMDATE_1"."DATE" ASC,
    "DIMBROWSER_1"."BROWSER" ASC;

select
    "DIMDATE_1"."DATE" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
group by
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    "DIMDATE_1"."DATE" = DATE '2020-06-30'
group by
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."DATE" ASC;

select
    "DIMDATE_1"."DATE" as "c0"
from
    "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1"
where
    "DIMDATE_1"."DATE" = DATE '2020-07-01'
group by
    "DIMDATE_1"."DATE"
order by
    "DIMDATE_1"."DATE" ASC;

select
    sum("FACTSEARCHADDITIVE_0"."SEARCHDAILYPAGEVIEWS") as "m0"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTSEARCHADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY"
where
    (("DIMDATE_1"."DATE" in (DATE '2020-06-30', DATE '2020-07-01')));

select
    "DIMBROWSER_1"."BROWSER" as "c0",
    sum("FACTSEARCHADDITIVE_0"."SEARCHDAILYPAGEVIEWS") as "m0"
from
    "MSNDATAMART"."FACTSEARCHADDITIVE" as "FACTSEARCHADDITIVE_0" inner join "MSNDATAMART"."VWDIMDATE" as "DIMDATE_1" on "FACTSEARCHADDITIVE_0"."DATEKEY" = "DIMDATE_1"."DATEKEY" inner join "MSNDATAMART"."DIMBROWSER" as "DIMBROWSER_1" on "FACTSEARCHADDITIVE_0"."BROWSERKEY" = "DIMBROWSER_1"."BROWSERKEY"
where
    (("DIMDATE_1"."DATE" in (DATE '2020-06-30', DATE '2020-07-01')))
group by
    "DIMBROWSER_1"."BROWSER"
order by
    "DIMBROWSER_1"."BROWSER" ASC;

select
    "VWDIMDATE"."MONTHKEY" as "c0",
    "VWDIMDATE"."MONTHNAME" as "c1"
from
    "MSNREVENUESHAREMART"."VWDIMDATE"
where
    "VWDIMDATE"."MONTHKEY" = '202007'
group by
    "VWDIMDATE"."MONTHKEY",
    "VWDIMDATE"."MONTHNAME"
order by
    "VWDIMDATE"."MONTHKEY" ASC;

select
    "VWDIMDATE"."WEEKKEY" as "c0",
    "VWDIMDATE"."MONTHKEY" as "c1",
    "VWDIMDATE"."WEEK" as "c2"
from
    "MSNREVENUESHAREMART"."VWDIMDATE" as "VWDIMDATE"
where
    ("VWDIMDATE"."MONTHKEY" = '202007')
group by
    "VWDIMDATE"."WEEKKEY",
    "VWDIMDATE"."MONTHKEY",
    "VWDIMDATE"."WEEK"
order by
    "VWDIMDATE"."WEEKKEY" ASC;

select
    "DIMSOURCEGRAIN"."SOURCEGRAIN" as "c0"
from
    "MSNREVENUESHAREMART"."DIMSOURCEGRAIN"
where
    "DIMSOURCEGRAIN"."SOURCEGRAIN" = 'Rid'
group by
    "DIMSOURCEGRAIN"."SOURCEGRAIN"
order by
    "DIMSOURCEGRAIN"."SOURCEGRAIN" ASC;

select
    "DIMPLACEMENT"."PLACEMENT" as "c0"
from
    "MSNREVENUESHAREMART"."DIMPLACEMENT"
where
    "DIMPLACEMENT"."PLACEMENT" = 'All Up'
group by
    "DIMPLACEMENT"."PLACEMENT"
order by
    "DIMPLACEMENT"."PLACEMENT" ASC;

select
    "DIMADSTYPE"."ADSTYPE" as "c0"
from
    "MSNREVENUESHAREMART"."DIMADSTYPE"
where
    "DIMADSTYPE"."ADSTYPE" = 'All Up'
group by
    "DIMADSTYPE"."ADSTYPE"
order by
    "DIMADSTYPE"."ADSTYPE" ASC;

select
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" as "c0"
from
    "MSNREVENUESHAREMART"."DIMMONETIZATIONPARTNERNAME"
where
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" = 'All Up'
group by
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME"
order by
    "DIMMONETIZATIONPARTNERNAME"."MONETIZATIONPARTNERNAME" ASC;

