/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.eclipse.persistence.exceptions.BeanValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.BeanValidationMode;
import org.eclipse.persistence.jaxb.ConstraintViolationWrapper;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;

class JAXBBeanValidator {
    private static Logger logger = Logger.getLogger(JAXBBeanValidator.class.getName());
    static final Class<?>[] DEFAULT_GROUP_ARRAY = new Class[]{Default.class};
    private static final String PREFIX_UNMARSHALLING = "un";
    private static final ReentrantLock lock = new ReentrantLock();
    private boolean noOptimisation = false;
    private final String prefix;
    private final JAXBContext context;
    private Validator validator;
    private Set<ConstraintViolation<Object>> constraintViolations = Collections.emptySet();
    private boolean canValidate;
    private boolean stopSearchingForValidator;
    private ValidatorFactory validatorFactory;
    private BeanValidationMode beanValidationMode = BeanValidationMode.NONE;

    private JAXBBeanValidator(String prefix, JAXBContext context) {
        this.prefix = prefix;
        this.context = context;
    }

    static JAXBBeanValidator getMarshallingBeanValidator(JAXBContext context) {
        return new JAXBBeanValidator("", context);
    }

    static JAXBBeanValidator getUnmarshallingBeanValidator(JAXBContext context) {
        return new JAXBBeanValidator(PREFIX_UNMARSHALLING, context);
    }

    boolean shouldValidate(Object value, BeanValidationMode beanValidationMode, Object preferredValidatorFactory, boolean noOptimisation) throws BeanValidationException {
        if (this.isValidationEffectivelyOff(beanValidationMode)) {
            return false;
        }
        this.noOptimisation = noOptimisation;
        if (!this.isConstrainedObject(value)) {
            return false;
        }
        if (this.beanValidationMode != beanValidationMode || this.validatorFactory != preferredValidatorFactory) {
            this.beanValidationMode = beanValidationMode;
            this.validatorFactory = (ValidatorFactory)preferredValidatorFactory;
            this.changeInternalState();
        }
        return this.canValidate;
    }

    private boolean isValidationEffectivelyOff(BeanValidationMode beanValidationMode) {
        return !(beanValidationMode == BeanValidationMode.AUTO && this.canValidate || beanValidationMode == BeanValidationMode.CALLBACK || beanValidationMode != BeanValidationMode.NONE && beanValidationMode != this.beanValidationMode);
    }

    private boolean isConstrainedObject(Object value) {
        if (value == null) {
            return false;
        }
        if (this.noOptimisation) {
            if (lock.isHeldByCurrentThread()) {
                return false;
            }
            return !(value instanceof XmlBindings);
        }
        return this.context.getBeanValidationHelper().isConstrained(value.getClass());
    }

    void validate(Object value, Class<?> ... groups) throws BeanValidationException {
        Class[] grp = groups;
        if (grp == null || grp.length == 0) {
            grp = DEFAULT_GROUP_ARRAY;
        }
        this.constraintViolations = this.validator.validate(value, grp);
        if (!this.constraintViolations.isEmpty()) {
            throw this.buildConstraintViolationException();
        }
    }

    Set<ConstraintViolationWrapper<Object>> getConstraintViolations() {
        HashSet<ConstraintViolationWrapper<Object>> result = new HashSet<ConstraintViolationWrapper<Object>>(this.constraintViolations.size());
        for (ConstraintViolation<Object> cv : this.constraintViolations) {
            result.add(new ConstraintViolationWrapper<Object>(cv));
        }
        return result;
    }

    private void changeInternalState() throws BeanValidationException {
        this.stopSearchingForValidator = false;
        switch (this.beanValidationMode) {
            case NONE: {
                this.canValidate = false;
                this.constraintViolations = Collections.emptySet();
                break;
            }
            case AUTO: 
            case CALLBACK: {
                this.canValidate = this.initValidator();
                break;
            }
            default: {
                throw BeanValidationException.illegalValidationMode(this.prefix, this.beanValidationMode.toString());
            }
        }
    }

    private boolean initValidator() throws BeanValidationException {
        if (this.validator == null && !this.stopSearchingForValidator) {
            try {
                ValidatorFactory factory = this.getValidatorFactory();
                this.validator = factory.getValidator();
                this.printValidatorInfo();
            }
            catch (ValidationException ve) {
                if (this.beanValidationMode == BeanValidationMode.CALLBACK) {
                    this.beanValidationMode = BeanValidationMode.AUTO;
                    throw BeanValidationException.providerNotFound(this.prefix, ve);
                }
                this.stopSearchingForValidator = true;
            }
        }
        return this.validator != null;
    }

    private ValidatorFactory getValidatorFactory() {
        if (this.validatorFactory != null) {
            return this.validatorFactory;
        }
        if (this.noOptimisation) {
            lock.lock();
            try {
                ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
                return validatorFactory;
            }
            finally {
                lock.unlock();
            }
        }
        return Validation.buildDefaultValidatorFactory();
    }

    private BeanValidationException buildConstraintViolationException() {
        ConstraintViolationException cve = new ConstraintViolationException(this.constraintViolations);
        return BeanValidationException.constraintViolation(this.createConstraintViolationExceptionArgs(), (Throwable)cve);
    }

    private Object[] createConstraintViolationExceptionArgs() {
        Object[] args = new Object[3];
        Iterator<ConstraintViolation<Object>> iterator = this.constraintViolations.iterator();
        assert (iterator.hasNext());
        ConstraintViolation<Object> cv = iterator.next();
        LinkedList<ConstraintViolationInfo> violatedConstraints = new LinkedList<ConstraintViolationInfo>(){

            @Override
            public String toString() {
                Iterator it = this.iterator();
                StringBuilder sb = new StringBuilder();
                while (it.hasNext()) {
                    sb.append("\n-->").append(((ConstraintViolationInfo)it.next()).toString());
                }
                return sb.toString();
            }
        };
        args[0] = this.prefix;
        Object bean = cv.getRootBean();
        args[1] = String.valueOf(bean.getClass().toString().substring("class ".length())) + "@" + Integer.toHexString(System.identityHashCode(bean));
        args[2] = violatedConstraints;
        while (true) {
            violatedConstraints.add(new ConstraintViolationInfo(cv.getMessage(), cv.getPropertyPath()));
            if (!iterator.hasNext()) break;
            cv = iterator.next();
        }
        return args;
    }

    private void printValidatorInfo() {
        if (!this.context.getHasLoggedValidatorInfo().getAndSet(true)) {
            CodeSource validationImplJar = this.getValidatorCodeSource();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("EclipseLink is using " + validationImplJar + " as BeanValidation implementation.");
            }
        }
    }

    private CodeSource getValidatorCodeSource() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedAction<CodeSource>(){

                @Override
                public CodeSource run() {
                    return JAXBBeanValidator.this.validator.getClass().getProtectionDomain().getCodeSource();
                }
            });
        }
        return this.validator.getClass().getProtectionDomain().getCodeSource();
    }

    private static class ConstraintViolationInfo {
        private final String violationDescription;
        private final Path propertyPath;

        private ConstraintViolationInfo(String message, Path propertyPath) {
            this.violationDescription = message;
            this.propertyPath = propertyPath;
        }

        public String toString() {
            return "Violated constraint on property " + this.propertyPath + ": \"" + this.violationDescription + "\".";
        }
    }
}

