/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="References a command executed on a peer cluster by a local command step.")
public class ApiRemoteCommand {
    @SerializedName(value="id")
    private BigDecimal id = null;
    @SerializedName(value="peerName")
    private String peerName = null;

    public ApiRemoteCommand id(BigDecimal id) {
        this.id = id;
        return this;
    }

    @Schema(description="Id of the remotely executed command.")
    public BigDecimal getId() {
        return this.id;
    }

    public void setId(BigDecimal id) {
        this.id = id;
    }

    public ApiRemoteCommand peerName(String peerName) {
        this.peerName = peerName;
        return this;
    }

    @Schema(description="The local peer name of the remote peer cluster.")
    public String getPeerName() {
        return this.peerName;
    }

    public void setPeerName(String peerName) {
        this.peerName = peerName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRemoteCommand apiRemoteCommand = (ApiRemoteCommand)o;
        return Objects.equals(this.id, apiRemoteCommand.id) && Objects.equals(this.peerName, apiRemoteCommand.peerName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.peerName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiRemoteCommand {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    peerName: ").append(this.toIndentedString(this.peerName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

