/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiJournalNodeArguments;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Arguments used for Enable NameNode High Availability command.")
public class ApiEnableNnHaArguments {
    @SerializedName(value="activeNnName")
    private String activeNnName = null;
    @SerializedName(value="standbyNnName")
    private String standbyNnName = null;
    @SerializedName(value="standbyNnHostId")
    private String standbyNnHostId = null;
    @SerializedName(value="standbyNameDirList")
    private List<String> standbyNameDirList = null;
    @SerializedName(value="nameservice")
    private String nameservice = null;
    @SerializedName(value="qjName")
    private String qjName = null;
    @SerializedName(value="activeFcName")
    private String activeFcName = null;
    @SerializedName(value="standbyFcName")
    private String standbyFcName = null;
    @SerializedName(value="zkServiceName")
    private String zkServiceName = null;
    @SerializedName(value="jns")
    private List<ApiJournalNodeArguments> jns = null;
    @SerializedName(value="forceInitZNode")
    private Boolean forceInitZNode = null;
    @SerializedName(value="clearExistingStandbyNameDirs")
    private Boolean clearExistingStandbyNameDirs = null;
    @SerializedName(value="clearExistingJnEditsDir")
    private Boolean clearExistingJnEditsDir = null;

    public ApiEnableNnHaArguments activeNnName(String activeNnName) {
        this.activeNnName = activeNnName;
        return this;
    }

    @Schema(description="Name of the NameNode role that is going to be made Highly Available.")
    public String getActiveNnName() {
        return this.activeNnName;
    }

    public void setActiveNnName(String activeNnName) {
        this.activeNnName = activeNnName;
    }

    public ApiEnableNnHaArguments standbyNnName(String standbyNnName) {
        this.standbyNnName = standbyNnName;
        return this;
    }

    @Schema(description="Name of the new Standby NameNode role that will be created during the command (Optional).")
    public String getStandbyNnName() {
        return this.standbyNnName;
    }

    public void setStandbyNnName(String standbyNnName) {
        this.standbyNnName = standbyNnName;
    }

    public ApiEnableNnHaArguments standbyNnHostId(String standbyNnHostId) {
        this.standbyNnHostId = standbyNnHostId;
        return this;
    }

    @Schema(description="Id of the host on which new Standby NameNode will be created.")
    public String getStandbyNnHostId() {
        return this.standbyNnHostId;
    }

    public void setStandbyNnHostId(String standbyNnHostId) {
        this.standbyNnHostId = standbyNnHostId;
    }

    public ApiEnableNnHaArguments standbyNameDirList(List<String> standbyNameDirList) {
        this.standbyNameDirList = standbyNameDirList;
        return this;
    }

    public ApiEnableNnHaArguments addStandbyNameDirListItem(String standbyNameDirListItem) {
        if (this.standbyNameDirList == null) {
            this.standbyNameDirList = new ArrayList<String>();
        }
        this.standbyNameDirList.add(standbyNameDirListItem);
        return this;
    }

    @Schema(description="List of directories for the new Standby NameNode. If not provided then it will use same dirs as Active NameNode.")
    public List<String> getStandbyNameDirList() {
        return this.standbyNameDirList;
    }

    public void setStandbyNameDirList(List<String> standbyNameDirList) {
        this.standbyNameDirList = standbyNameDirList;
    }

    public ApiEnableNnHaArguments nameservice(String nameservice) {
        this.nameservice = nameservice;
        return this;
    }

    @Schema(description="Nameservice to be used while enabling Highly Available. It must be specified if Active NameNode isn't configured with it. If Active NameNode is already configured, then this need not be specified. However, if it is still specified, it must match the existing config for the Active NameNode.")
    public String getNameservice() {
        return this.nameservice;
    }

    public void setNameservice(String nameservice) {
        this.nameservice = nameservice;
    }

    public ApiEnableNnHaArguments qjName(String qjName) {
        this.qjName = qjName;
        return this;
    }

    @Schema(description="Name of the journal located on each JournalNodes' filesystem. This can be optionally provided if the config hasn't already been set for the Active NameNode. If this isn't provided and Active NameNode doesn't also have the config, then nameservice is used by default. If Active NameNode already has this configured, then it much match the existing config.")
    public String getQjName() {
        return this.qjName;
    }

    public void setQjName(String qjName) {
        this.qjName = qjName;
    }

    public ApiEnableNnHaArguments activeFcName(String activeFcName) {
        this.activeFcName = activeFcName;
        return this;
    }

    @Schema(description="Name of the FailoverController role to be created on Active NameNode's host (Optional).")
    public String getActiveFcName() {
        return this.activeFcName;
    }

    public void setActiveFcName(String activeFcName) {
        this.activeFcName = activeFcName;
    }

    public ApiEnableNnHaArguments standbyFcName(String standbyFcName) {
        this.standbyFcName = standbyFcName;
        return this;
    }

    @Schema(description="Name of the FailoverController role to be created on Standby NameNode's host (Optional).")
    public String getStandbyFcName() {
        return this.standbyFcName;
    }

    public void setStandbyFcName(String standbyFcName) {
        this.standbyFcName = standbyFcName;
    }

    public ApiEnableNnHaArguments zkServiceName(String zkServiceName) {
        this.zkServiceName = zkServiceName;
        return this;
    }

    @Schema(description="Name of the ZooKeeper service to be used for Auto-Failover. This MUST be provided if HDFS doesn't have a ZooKeeper dependency. If the dependency is already set, then this should be the name of the same ZooKeeper service, but can also be omitted in that case.")
    public String getZkServiceName() {
        return this.zkServiceName;
    }

    public void setZkServiceName(String zkServiceName) {
        this.zkServiceName = zkServiceName;
    }

    public ApiEnableNnHaArguments jns(List<ApiJournalNodeArguments> jns) {
        this.jns = jns;
        return this;
    }

    public ApiEnableNnHaArguments addJnsItem(ApiJournalNodeArguments jnsItem) {
        if (this.jns == null) {
            this.jns = new ArrayList<ApiJournalNodeArguments>();
        }
        this.jns.add(jnsItem);
        return this;
    }

    @Schema(description="Arguments for the JournalNodes to be created during the command. Must be provided only if JournalNodes don't exist already in HDFS.")
    public List<ApiJournalNodeArguments> getJns() {
        return this.jns;
    }

    public void setJns(List<ApiJournalNodeArguments> jns) {
        this.jns = jns;
    }

    public ApiEnableNnHaArguments forceInitZNode(Boolean forceInitZNode) {
        this.forceInitZNode = forceInitZNode;
        return this;
    }

    @Schema(description="Boolean indicating if the ZNode should be force initialized if it is already present. Useful while re-enabling High Availability. (Default: TRUE)")
    public Boolean isForceInitZNode() {
        return this.forceInitZNode;
    }

    public void setForceInitZNode(Boolean forceInitZNode) {
        this.forceInitZNode = forceInitZNode;
    }

    public ApiEnableNnHaArguments clearExistingStandbyNameDirs(Boolean clearExistingStandbyNameDirs) {
        this.clearExistingStandbyNameDirs = clearExistingStandbyNameDirs;
        return this;
    }

    @Schema(description="Boolean indicating if the existing name directories for Standby NameNode should be cleared during the workflow. Useful while re-enabling High Availability. (Default: TRUE)")
    public Boolean isClearExistingStandbyNameDirs() {
        return this.clearExistingStandbyNameDirs;
    }

    public void setClearExistingStandbyNameDirs(Boolean clearExistingStandbyNameDirs) {
        this.clearExistingStandbyNameDirs = clearExistingStandbyNameDirs;
    }

    public ApiEnableNnHaArguments clearExistingJnEditsDir(Boolean clearExistingJnEditsDir) {
        this.clearExistingJnEditsDir = clearExistingJnEditsDir;
        return this;
    }

    @Schema(description="Boolean indicating if the existing edits directories for the JournalNodes for the specified nameservice should be cleared during the workflow. Useful while re-enabling High Availability. (Default: TRUE)")
    public Boolean isClearExistingJnEditsDir() {
        return this.clearExistingJnEditsDir;
    }

    public void setClearExistingJnEditsDir(Boolean clearExistingJnEditsDir) {
        this.clearExistingJnEditsDir = clearExistingJnEditsDir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiEnableNnHaArguments apiEnableNnHaArguments = (ApiEnableNnHaArguments)o;
        return Objects.equals(this.activeNnName, apiEnableNnHaArguments.activeNnName) && Objects.equals(this.standbyNnName, apiEnableNnHaArguments.standbyNnName) && Objects.equals(this.standbyNnHostId, apiEnableNnHaArguments.standbyNnHostId) && Objects.equals(this.standbyNameDirList, apiEnableNnHaArguments.standbyNameDirList) && Objects.equals(this.nameservice, apiEnableNnHaArguments.nameservice) && Objects.equals(this.qjName, apiEnableNnHaArguments.qjName) && Objects.equals(this.activeFcName, apiEnableNnHaArguments.activeFcName) && Objects.equals(this.standbyFcName, apiEnableNnHaArguments.standbyFcName) && Objects.equals(this.zkServiceName, apiEnableNnHaArguments.zkServiceName) && Objects.equals(this.jns, apiEnableNnHaArguments.jns) && Objects.equals(this.forceInitZNode, apiEnableNnHaArguments.forceInitZNode) && Objects.equals(this.clearExistingStandbyNameDirs, apiEnableNnHaArguments.clearExistingStandbyNameDirs) && Objects.equals(this.clearExistingJnEditsDir, apiEnableNnHaArguments.clearExistingJnEditsDir);
    }

    public int hashCode() {
        return Objects.hash(this.activeNnName, this.standbyNnName, this.standbyNnHostId, this.standbyNameDirList, this.nameservice, this.qjName, this.activeFcName, this.standbyFcName, this.zkServiceName, this.jns, this.forceInitZNode, this.clearExistingStandbyNameDirs, this.clearExistingJnEditsDir);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiEnableNnHaArguments {\n");
        sb.append("    activeNnName: ").append(this.toIndentedString(this.activeNnName)).append("\n");
        sb.append("    standbyNnName: ").append(this.toIndentedString(this.standbyNnName)).append("\n");
        sb.append("    standbyNnHostId: ").append(this.toIndentedString(this.standbyNnHostId)).append("\n");
        sb.append("    standbyNameDirList: ").append(this.toIndentedString(this.standbyNameDirList)).append("\n");
        sb.append("    nameservice: ").append(this.toIndentedString(this.nameservice)).append("\n");
        sb.append("    qjName: ").append(this.toIndentedString(this.qjName)).append("\n");
        sb.append("    activeFcName: ").append(this.toIndentedString(this.activeFcName)).append("\n");
        sb.append("    standbyFcName: ").append(this.toIndentedString(this.standbyFcName)).append("\n");
        sb.append("    zkServiceName: ").append(this.toIndentedString(this.zkServiceName)).append("\n");
        sb.append("    jns: ").append(this.toIndentedString(this.jns)).append("\n");
        sb.append("    forceInitZNode: ").append(this.toIndentedString(this.forceInitZNode)).append("\n");
        sb.append("    clearExistingStandbyNameDirs: ").append(this.toIndentedString(this.clearExistingStandbyNameDirs)).append("\n");
        sb.append("    clearExistingJnEditsDir: ").append(this.toIndentedString(this.clearExistingJnEditsDir)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

