/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="A clusterRef references a cluster. To operate on the cluster object, use the cluster API with the clusterName as the parameter.")
public class ApiClusterRef {
    @SerializedName(value="clusterName")
    private String clusterName = null;
    @SerializedName(value="displayName")
    private String displayName = null;

    public ApiClusterRef clusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    @Schema(description="The name of the cluster, which uniquely identifies it in a CM installation.")
    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public ApiClusterRef displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="The display name of the cluster. This is available from v30.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiClusterRef apiClusterRef = (ApiClusterRef)o;
        return Objects.equals(this.clusterName, apiClusterRef.clusterName) && Objects.equals(this.displayName, apiClusterRef.displayName);
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, this.displayName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiClusterRef {\n");
        sb.append("    clusterName: ").append(this.toIndentedString(this.clusterName)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

