/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.Collection;
import java.util.Objects;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Preconditions;

public final class BulkDeleteUtils {
    private BulkDeleteUtils() {
    }

    public static void validateBulkDeletePaths(Collection<Path> paths, int pageSize, Path basePath) {
        Objects.requireNonNull(paths);
        Preconditions.checkArgument(paths.size() <= pageSize, "Number of paths (%d) is larger than the page size (%d)", paths.size(), pageSize);
        paths.forEach(p -> {
            Preconditions.checkArgument(p.isAbsolute(), "Path %s is not absolute", p);
            Preconditions.checkArgument(BulkDeleteUtils.validatePathIsUnderParent(p, basePath), "Path %s is not under the base path %s", p, basePath);
        });
    }

    public static boolean validatePathIsUnderParent(Path p, Path basePath) {
        while (p != null) {
            if (p.equals(basePath)) {
                return true;
            }
            p = p.getParent();
        }
        return false;
    }
}

