/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.simple;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.knox.gateway.topology.simple.SimpleDescriptor;

public class SimpleDescriptorImpl
implements SimpleDescriptor {
    @JsonProperty(value="discovery-type")
    private String discoveryType;
    @JsonProperty(value="discovery-address")
    private String discoveryAddress;
    @JsonProperty(value="discovery-user")
    private String discoveryUser;
    @JsonProperty(value="discovery-pwd-alias")
    private String discoveryPasswordAlias;
    @JsonProperty(value="provider-config-ref")
    private String providerConfig;
    @JsonProperty(value="read-only")
    private boolean readOnly;
    @JsonProperty(value="cluster")
    private String cluster;
    @JsonProperty(value="provision-encrypt-query-string-credential")
    private boolean provisionEncryptQueryStringCredential = true;
    @JsonProperty(value="services")
    private List<SimpleDescriptor.Service> services;
    @JsonProperty(value="applications")
    private List<SimpleDescriptor.Application> applications;
    private String name;

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDiscoveryType(String discoveryType) {
        this.discoveryType = discoveryType;
    }

    @Override
    public String getDiscoveryType() {
        return this.discoveryType;
    }

    public void setDiscoveryAddress(String discoveryAddress) {
        this.discoveryAddress = discoveryAddress;
    }

    @Override
    public String getDiscoveryAddress() {
        return this.discoveryAddress;
    }

    public void setDiscoveryUser(String discoveryUser) {
        this.discoveryUser = discoveryUser;
    }

    @Override
    public String getDiscoveryUser() {
        return this.discoveryUser;
    }

    public void setDiscoveryPasswordAlias(String discoveryPasswordAlias) {
        this.discoveryPasswordAlias = discoveryPasswordAlias;
    }

    @Override
    public String getDiscoveryPasswordAlias() {
        return this.discoveryPasswordAlias;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    @Override
    public String getCluster() {
        return this.cluster;
    }

    public void setProviderConfig(String providerConfig) {
        this.providerConfig = providerConfig;
    }

    @Override
    public String getProviderConfig() {
        return this.providerConfig;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean isProvisionEncryptQueryStringCredential() {
        return this.provisionEncryptQueryStringCredential;
    }

    public void setProvisionEncryptQueryStringCredential(boolean provisionEncryptQueryStringCredential) {
        this.provisionEncryptQueryStringCredential = provisionEncryptQueryStringCredential;
    }

    public void addService(SimpleDescriptor.Service service) {
        if (this.services == null) {
            this.services = new ArrayList<SimpleDescriptor.Service>();
        }
        this.services.add(service);
    }

    public void setServices(Collection<SimpleDescriptor.Service> services) {
        this.services = new ArrayList<SimpleDescriptor.Service>(services);
    }

    @Override
    public List<SimpleDescriptor.Service> getServices() {
        ArrayList<SimpleDescriptor.Service> result = new ArrayList<SimpleDescriptor.Service>();
        if (this.services != null) {
            result.addAll(this.services);
        }
        return result;
    }

    @Override
    public SimpleDescriptor.Service getService(String serviceName) {
        return this.getServices().stream().filter(service -> service.getName().equals(serviceName)).findFirst().orElse(null);
    }

    public void addApplication(SimpleDescriptor.Application application) {
        if (this.applications == null) {
            this.applications = new ArrayList<SimpleDescriptor.Application>();
        }
        this.applications.add(application);
    }

    @Override
    public List<SimpleDescriptor.Application> getApplications() {
        ArrayList<SimpleDescriptor.Application> result = new ArrayList<SimpleDescriptor.Application>();
        if (this.applications != null) {
            result.addAll(this.applications);
        }
        return result;
    }

    @Override
    public SimpleDescriptor.Application getApplication(String applicationName) {
        return this.getApplications().stream().filter(application -> application.getName().equals(applicationName)).findFirst().orElse(null);
    }

    public static class ApplicationImpl
    implements SimpleDescriptor.Application {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="params")
        private Map<String, String> params;
        @JsonProperty(value="urls")
        private List<String> urls;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<String, String> getParams() {
            return this.params;
        }

        @Override
        public List<String> getURLs() {
            return this.urls;
        }

        public void addUrl(String url) {
            if (this.urls == null) {
                this.urls = new ArrayList<String>();
            }
            this.urls.add(url);
        }

        public void setName(String name) {
            this.name = name;
        }

        public void addParam(String name, String value) {
            if (this.params == null) {
                this.params = new TreeMap<String, String>();
            }
            this.params.put(name, value);
        }
    }

    public static class ServiceImpl
    implements SimpleDescriptor.Service {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="params")
        private Map<String, String> params;
        @JsonProperty(value="urls")
        private List<String> urls;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public Map<String, String> getParams() {
            return this.params;
        }

        @Override
        public List<String> getURLs() {
            return this.urls;
        }

        public void addUrl(String url) {
            if (this.urls == null) {
                this.urls = new ArrayList<String>();
            }
            this.urls.add(url);
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void addParam(String name, String value) {
            if (this.params == null) {
                this.params = new TreeMap<String, String>();
            }
            this.params.put(name, value);
        }
    }
}

