/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.identityasserter.filter;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.knox.gateway.identityasserter.common.filter.IdentityAsserterHttpServletRequestWrapper;

public class NoImpersonationAsserterRequestWrapper
extends IdentityAsserterHttpServletRequestWrapper {
    public NoImpersonationAsserterRequestWrapper(HttpServletRequest request, String principal) {
        this(request, principal, Collections.EMPTY_LIST);
    }

    public NoImpersonationAsserterRequestWrapper(HttpServletRequest request, String principal, List<String> impersonationParamsList) {
        super(request, principal, impersonationParamsList);
    }

    public String getQueryString() {
        String q = null;
        try {
            Map params = this.getParams();
            if (params == null) {
                params = new LinkedHashMap();
            }
            List principalParamNames = this.getImpersonationParamNames();
            params = this.scrubOfExistingPrincipalParams(params, principalParamNames);
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = Charset.defaultCharset().name();
            }
            q = NoImpersonationAsserterRequestWrapper.urlEncode(params, (String)encoding);
        }
        catch (UnsupportedEncodingException e) {
            log.unableToGetParamsFromQueryString((Exception)e);
        }
        return q;
    }
}

