/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.hadoop.xml;

import java.nio.file.attribute.FileTime;
import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;

@Messages(logger="org.apache.knox.gateway")
public interface HadoopXmlResourceMessages {
    @Message(level=MessageLevel.INFO, text="Monitoring Knox resources in Hadoop style XML configurations in {0} ...")
    public void monitoringHadoopXmlResources(String var1);

    @Message(level=MessageLevel.INFO, text="Monitoring Knox resources in Hadoop style XML configurations is disabled.")
    public void disableMonitoringHadoopXmlResources();

    @Message(level=MessageLevel.INFO, text="Parsing  Knox resources in Hadoop style XML {0}...")
    public void parseHadoopXmlResource(String var1);

    @Message(level=MessageLevel.INFO, text="Found Knox descriptors {0} in {1}")
    public void foundKnoxDescriptors(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Found Knox provider configurations {0} in {1}")
    public void foundKnoxProviderConfigurations(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Saved Knox {0} into {1}")
    public void savedResource(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Ignoring {0} Knox {1} update because it did not change.")
    public void resourceDidNotChange(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Parsing Knox shared provider configuration {0} failed: {1}")
    public void failedToParseProviderConfiguration(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.ERROR, text="Parsing Knox descriptor {0} failed: {1}")
    public void failedToParseDescriptor(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.ERROR, text="Parsing XML configuration {0} failed: {1}")
    public void failedToParseXmlConfiguration(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.DEBUG, text="Processing Hadoop XML resource {0} (lastReloadTime = {1}; lastModified = {2})")
    public void processHadoopXmlResource(String var1, FileTime var2, FileTime var3);

    @Message(level=MessageLevel.DEBUG, text="Skipping Hadoop XML resource monitoring of {0} (lastReloadTime = {1}; lastModified = {2})")
    public void skipMonitorHadoopXmlResource(String var1, FileTime var2, FileTime var3);

    @Message(level=MessageLevel.ERROR, text="Error while monitoring Hadoop style XML configuration {0}: {1}")
    public void failedToMonitorHadoopXmlResource(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.ERROR, text="Error while producing Knox descriptor: {0}")
    public void failedToProduceKnoxDescriptor(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Error while producing Knox provider: {0}")
    public void failedToProduceKnoxProvider(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.INFO, text="Updated advanced service discovery configuration for {0}.")
    public void updatedAdvanceServiceDiscoverytConfiguration(String var1);

    @Message(level=MessageLevel.WARN, text="Skipping read only descriptor: {0}.")
    public void skipReadOnlyDescriptor(String var1);

    @Message(level=MessageLevel.WARN, text="Skipping read only provider: {0}.")
    public void skipReadOnlyProvider(String var1);

    @Message(level=MessageLevel.INFO, text="Found deleted descriptors {0} in {1}")
    public void foundKnoxDeletedDescriptors(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Found deleted provider configurations {0} in {1}")
    public void foundKnoxDeletedProviderConfigurations(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Deleting file {0}")
    public void deleteFile(String var1);

    @Message(level=MessageLevel.WARN, text="Not deleting provider {0} as it is referenced by on ore more descriptors.")
    public void notDeletingReferenceProvider(String var1);
}

