/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.search;

import org.apache.directory.api.ldap.model.filter.FilterEncoder;
import org.apache.directory.ldap.client.api.search.AbstractFilter;
import org.apache.directory.ldap.client.api.search.FilterOperator;

class MatchingRuleAssertionFilter
extends AbstractFilter {
    private String attribute;
    private String matchingRule;
    private FilterOperator operator;
    private boolean useDnAttributes = false;
    private String value;

    MatchingRuleAssertionFilter(String attribute, String value, FilterOperator operator) {
        this.attribute = attribute;
        this.value = value;
        this.operator = operator;
    }

    public static MatchingRuleAssertionFilter extensible(String value) {
        return new MatchingRuleAssertionFilter(null, value, FilterOperator.EXTENSIBLE_EQUAL);
    }

    public static MatchingRuleAssertionFilter extensible(String attribute, String value) {
        return new MatchingRuleAssertionFilter(attribute, value, FilterOperator.EXTENSIBLE_EQUAL);
    }

    public MatchingRuleAssertionFilter setMatchingRule(String matchingRule) {
        this.matchingRule = matchingRule;
        return this;
    }

    public MatchingRuleAssertionFilter useDnAttributes() {
        this.useDnAttributes = true;
        return this;
    }

    @Override
    public StringBuilder build(StringBuilder builder) {
        builder.append("(");
        if (this.attribute != null) {
            builder.append(this.attribute);
        }
        if (this.useDnAttributes) {
            builder.append(":dn");
        }
        if (this.matchingRule != null && !this.matchingRule.isEmpty()) {
            builder.append(":").append(this.matchingRule);
        }
        return builder.append(this.operator.operator()).append(FilterEncoder.encodeFilterValue((String)this.value)).append(")");
    }
}

