/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.vlv_impl;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewResponse;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewResponseImpl;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewResponseContainer;
import org.apache.directory.api.ldap.model.message.Control;

public class VirtualListViewResponseFactory
extends AbstractControlFactory<VirtualListViewResponse> {
    public VirtualListViewResponseFactory(LdapApiService codec) {
        super(codec, "2.16.840.1.113730.3.4.10");
    }

    public VirtualListViewResponse newControl() {
        return new VirtualListViewResponseImpl();
    }

    public void encodeValue(Asn1Buffer buffer, Control control) {
        int start = buffer.getPos();
        VirtualListViewResponse vlvResponse = (VirtualListViewResponse)control;
        if (vlvResponse.getContextId() != null) {
            BerValue.encodeOctetString((Asn1Buffer)buffer, (byte[])vlvResponse.getContextId());
        }
        BerValue.encodeEnumerated((Asn1Buffer)buffer, (int)vlvResponse.getVirtualListViewResult().getValue());
        BerValue.encodeInteger((Asn1Buffer)buffer, (int)vlvResponse.getContentCount());
        BerValue.encodeInteger((Asn1Buffer)buffer, (int)vlvResponse.getTargetPosition());
        BerValue.encodeSequence((Asn1Buffer)buffer, (int)start);
    }

    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        this.decodeValue(new VirtualListViewResponseContainer(control), control, controlBytes);
    }
}

