/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.webshell;

import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.websockets.WebsocketLogMessages;
import org.eclipse.jetty.io.RuntimeIOException;

public class ConnectionInfo {
    private static final Auditor auditor = AuditServiceFactory.getAuditService().getAuditor("audit", "knox", "knox");
    private static final WebsocketLogMessages LOG = (WebsocketLogMessages)MessagesFactory.get(WebsocketLogMessages.class);
    private static final String TERMINAL_EMULATOR_KEY = "TERM";
    private static final String TERMINAL_EMULATOR_VALUE = "xterm";
    private InputStream inputStream;
    private OutputStream outputStream;
    private PtyProcess ptyProcess;
    private final String username;
    private final String gatewayPIDDir;
    private final Thread shutdownHook;
    private final AtomicInteger concurrentWebshells;
    private long pid;
    private final Map<String, String> webshellEnvVariables = new HashMap<String, String>();

    public ConnectionInfo(String username, String gatewayPIDDir, AtomicInteger concurrentWebshells) {
        this.username = username;
        this.gatewayPIDDir = gatewayPIDDir;
        this.concurrentWebshells = concurrentWebshells;
        this.shutdownHook = new Thread(this::disconnect);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.webshellEnvVariables.put(TERMINAL_EMULATOR_KEY, TERMINAL_EMULATOR_VALUE);
    }

    private void saveProcessPID(long pid) {
        File file = new File(this.gatewayPIDDir + "/webshell_" + pid + ".pid");
        try {
            FileUtils.writeStringToFile((File)file, (String)String.valueOf(pid), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.onError("error saving PID for webshell:" + e);
        }
        auditor.audit("webshell", this.username + ':' + pid, "process", "success", "Started Bash process");
    }

    @SuppressForbidden
    public void connect() {
        String[] cmd = new String[]{"sudo", "--user", this.username, "bash", "-i"};
        try {
            this.ptyProcess = new PtyProcessBuilder().setCommand(cmd).setRedirectErrorStream(true).setWindowsAnsiColorEnabled(true).setInitialColumns(Integer.valueOf(100)).setInitialRows(Integer.valueOf(40)).start();
        }
        catch (IOException e) {
            LOG.onError("Error starting ptyProcess: " + e.getMessage());
            this.disconnect();
            throw new RuntimeIOException((Throwable)e);
        }
        this.outputStream = this.ptyProcess.getOutputStream();
        this.inputStream = this.ptyProcess.getInputStream();
        this.pid = this.ptyProcess.pid();
        this.saveProcessPID(this.pid);
        this.concurrentWebshells.incrementAndGet();
    }

    public String getUsername() {
        return this.username;
    }

    public long getPid() {
        return this.pid;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void disconnect() {
        if (this.ptyProcess != null) {
            this.ptyProcess.destroy();
            if (this.ptyProcess.isAlive()) {
                this.ptyProcess.destroyForcibly();
            }
            this.ptyProcess = null;
            this.concurrentWebshells.decrementAndGet();
            auditor.audit("webshell", this.username + ':' + this.pid, "process", "success", "destroyed Bash process");
            File fileToDelete = FileUtils.getFile((String[])new String[]{this.gatewayPIDDir + "/webshell_" + this.pid + ".pid"});
            FileUtils.deleteQuietly((File)fileToDelete);
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }
}

