/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.update;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.io.Printable;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.modify.UpdateCompare;
import org.apache.jena.sparql.modify.request.UpdateSerializer;
import org.apache.jena.sparql.modify.request.UpdateWriter;
import org.apache.jena.sparql.serializer.SerializerRegistry;
import org.apache.jena.sparql.serializer.UpdateSerializerFactory;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateFactory;

public class UpdateRequest
extends Prologue
implements Printable,
Iterable<Update> {
    private List<Update> operations = new ArrayList<Update>();
    private List<Update> operationsView = Collections.unmodifiableList(this.operations);

    public UpdateRequest() {
    }

    public UpdateRequest(Update update) {
        this();
        this.add(update);
    }

    public UpdateRequest add(Update update) {
        this.operations.add(update);
        return this;
    }

    public UpdateRequest add(String string) {
        UpdateFactory.parse(this, string);
        return this;
    }

    public List<Update> getOperations() {
        return this.operationsView;
    }

    @Override
    public Iterator<Update> iterator() {
        return this.operationsView.iterator();
    }

    public String toString() {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.output((IndentedWriter)buff);
        return buff.toString();
    }

    public void output(IndentedWriter out) {
        UpdateSerializerFactory factory = SerializerRegistry.get().getUpdateSerializerFactory(Syntax.defaultUpdateSyntax);
        if (factory != null) {
            UpdateSerializer serializer = factory.create(Syntax.defaultUpdateSyntax, this, out);
            serializer.open();
            serializer.update(this);
            serializer.close();
        } else {
            UpdateWriter.output(this, out);
        }
    }

    public boolean equalTo(UpdateRequest other) {
        return UpdateCompare.isomorphic(this, other);
    }
}

