/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.protobuf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.protobuf.PBufRDF;
import org.apache.jena.riot.protobuf.wire.PB_RDF;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;

public class StreamRDF2Protobuf
implements StreamRDF,
AutoCloseable {
    private PrefixMap pmap = PrefixMapFactory.create();
    private final boolean encodeValues;
    private final Consumer<PB_RDF.RDF_StreamRow> rowHandler;
    private final Runnable andFinally;
    private PB_RDF.RDF_StreamRow.Builder streamRowBuilder = PB_RDF.RDF_StreamRow.newBuilder();
    private PB_RDF.RDF_Triple.Builder tripleBuilder = PB_RDF.RDF_Triple.newBuilder();
    private PB_RDF.RDF_Quad.Builder quadBuilder = PB_RDF.RDF_Quad.newBuilder();
    private PB_RDF.RDF_PrefixDecl.Builder prefixBuilder = PB_RDF.RDF_PrefixDecl.newBuilder();
    private PB_RDF.RDF_IRI.Builder baseBuilder = PB_RDF.RDF_IRI.newBuilder();
    private PB_RDF.RDF_Term.Builder termBuilder = PB_RDF.RDF_Term.newBuilder();

    public static StreamRDF createDelimited(OutputStream outputStream, boolean withValues) {
        Consumer<PB_RDF.RDF_StreamRow> output = sr -> PBufRDF.writeDelimitedTo(sr, outputStream);
        return new StreamRDF2Protobuf(output, withValues, () -> IO.flush((OutputStream)outputStream));
    }

    public static void writeBlk(OutputStream outputStream, Consumer<StreamRDF> stream, boolean withValues) {
        PB_RDF.RDF_Stream.Builder builder = PB_RDF.RDF_Stream.newBuilder();
        Consumer<PB_RDF.RDF_StreamRow> output = sr -> builder.addRow((PB_RDF.RDF_StreamRow)sr);
        StreamRDF2Protobuf processor = new StreamRDF2Protobuf(output, withValues, () -> IO.flush((OutputStream)outputStream));
        stream.accept(processor);
        PB_RDF.RDF_Stream pbStream = builder.build();
        try {
            pbStream.writeTo(outputStream);
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
    }

    private StreamRDF2Protobuf(Consumer<PB_RDF.RDF_StreamRow> rowHandler, boolean encodeValues, Runnable atEnd) {
        this.pmap = PrefixMapFactory.create();
        this.encodeValues = encodeValues;
        this.rowHandler = rowHandler;
        this.andFinally = atEnd;
    }

    @Override
    public void start() {
    }

    @Override
    public void finish() {
        this.andFinally.run();
    }

    @Override
    public void close() {
        this.finish();
    }

    @Override
    public void base(String base) {
        this.streamRowBuilder.clear();
        this.baseBuilder.clear();
        this.baseBuilder.setIri(base);
        this.streamRowBuilder.setBase(this.baseBuilder.build());
        this.rowHandler.accept(this.streamRowBuilder.build());
    }

    @Override
    public void prefix(String prefix, String iri) {
        this.streamRowBuilder.clear();
        this.prefixBuilder.clear();
        this.prefixBuilder.setPrefix(prefix);
        this.prefixBuilder.setUri(iri);
        this.streamRowBuilder.setPrefixDecl(this.prefixBuilder.build());
        this.rowHandler.accept(this.streamRowBuilder.build());
    }

    @Override
    public void version(String version2) {
    }

    @Override
    public void triple(Triple triple) {
        this.streamRowBuilder.clear();
        PB_RDF.RDF_Triple triplePB = PBufRDF.rdfTriple(triple, this.tripleBuilder, this.termBuilder);
        this.streamRowBuilder.setTriple(triplePB);
        this.rowHandler.accept(this.streamRowBuilder.build());
    }

    @Override
    public void quad(Quad quad) {
        this.streamRowBuilder.clear();
        PB_RDF.RDF_Quad quadPB = PBufRDF.rdfQuad(quad, this.quadBuilder, this.termBuilder);
        this.streamRowBuilder.setQuad(quadPB);
        this.rowHandler.accept(this.streamRowBuilder.build());
    }
}

