/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.ExternallyTaggedUnion;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

public abstract class SingleBucketAggregateBase
extends AggregateBase {
    private final Map<String, Aggregate> aggregations;
    private final long docCount;

    protected SingleBucketAggregateBase(AbstractBuilder<?> builder) {
        super(builder);
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.docCount = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).docCount, this, "docCount");
    }

    public final Map<String, Aggregate> aggregations() {
        return this.aggregations;
    }

    public final long docCount() {
        return this.docCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        ExternallyTaggedUnion.serializeTypedKeysInner(this.aggregations, generator, mapper);
        generator.writeKey("doc_count");
        generator.write(this.docCount);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSingleBucketAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(AbstractBuilder::docCount, JsonpDeserializer.longDeserializer(), "doc_count");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (builder.aggregations == null) {
                builder.aggregations = new HashMap<String, Aggregate>();
            }
            Aggregate._TYPED_KEYS_DESERIALIZER.deserializeEntry((String)name, (JsonParser)parser, (JsonpMapper)mapper, builder.aggregations);
        });
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregateBase.AbstractBuilder<BuilderT> {
        @Nullable
        protected Map<String, Aggregate> aggregations = new HashMap<String, Aggregate>();
        private Long docCount;

        public final BuilderT aggregations(Map<String, Aggregate> aggregateMap) {
            this.aggregations = AbstractBuilder._mapPutAll(this.aggregations, aggregateMap);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT aggregations(String key, Aggregate value) {
            this.aggregations = AbstractBuilder._mapPut(this.aggregations, key, value);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT aggregations(String key, Function<Aggregate.Builder, ObjectBuilder<Aggregate>> function) {
            return this.aggregations(key, function.apply(new Aggregate.Builder()).build());
        }

        public final BuilderT docCount(long value) {
            this.docCount = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

