/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jooq.impl.ObjIntFunction;

final class ScopeStack<K, V>
implements Iterable<V> {
    private int scopeLevel = -1;
    private Map<K, List<Element<V>>> stack;
    private final ObjIntFunction<K, V> constructor;

    ScopeStack() {
        this((ObjIntFunction)null);
    }

    ScopeStack(V defaultValue) {
        this((part, scopeLevel) -> defaultValue);
    }

    ScopeStack(ObjIntFunction<K, V> constructor) {
        this.constructor = constructor;
    }

    private final Map<K, List<Element<V>>> stack() {
        if (this.stack == null) {
            this.stack = new LinkedHashMap<K, List<Element<V>>>();
        }
        return this.stack;
    }

    private final void trim() {
        int l = this.scopeLevel + 1;
        if (l >= 0) {
            Iterator<Map.Entry<K, List<Element<V>>>> it = this.stack().entrySet().iterator();
            while (it.hasNext()) {
                int size;
                Map.Entry<K, List<Element<V>>> entry = it.next();
                List<Element<V>> list = entry.getValue();
                while ((size = list.size()) > l || size > 0 && list.get(size - 1) == null) {
                    list.remove(size - 1);
                }
                if (!list.isEmpty()) continue;
                it.remove();
            }
        }
    }

    final boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    final Iterable<Value<V>> valueIterable() {
        return () -> new ScopeStackIterator<Value>(e -> Value.lastOf((List)e.getValue()), e -> true);
    }

    @Override
    public final Iterator<V> iterator() {
        return this.iterable(e -> true).iterator();
    }

    final Iterable<V> iterableAtScopeLevel() {
        return this.iterableAtScopeLevel(e -> true);
    }

    final Iterable<V> iterableAtScopeLevel(Predicate<? super V> filter) {
        return () -> new ScopeStackIterator<Object>((k, v) -> v.size() == this.scopeLevel + 1 ? this.getCurrentScope0((List<Element<V>>)v) : null, filter);
    }

    final Iterable<V> iterable(Predicate<? super V> filter) {
        return () -> new ScopeStackIterator<Object>((k, v) -> ScopeStack.get0(v), filter);
    }

    final Iterable<K> keyIterableAtScopeLevel() {
        return this.keyIterableAtScopeLevel(e -> true);
    }

    final Iterable<K> keyIterableAtScopeLevel(Predicate<? super K> filter) {
        return () -> new ScopeStackIterator<Object>((k, v) -> v.size() == this.scopeLevel + 1 ? k : null, filter);
    }

    final Iterable<K> keyIterable(Predicate<? super K> filter) {
        return () -> new ScopeStackIterator<Object>((k, v) -> k, filter);
    }

    final void setAll(V value) {
        for (K key : this.stack().keySet()) {
            this.set(key, value);
        }
    }

    final void set(K key, V value) {
        this.set0(this.list(key), value);
    }

    private static final <V> V get0(List<Element<V>> list) {
        return ScopeStack.getIfNotHidden(ScopeStack.getElement0(list));
    }

    private static final <V> Element<V> getElement0(List<Element<V>> list) {
        if (list == null) {
            return null;
        }
        int i = list.size();
        if (i == 0) {
            return null;
        }
        return list.get(i - 1);
    }

    private static final <V> V getIfNotHidden(Element<V> element) {
        if (element == null) {
            return null;
        }
        if (element.hidden) {
            return null;
        }
        return element.value;
    }

    private final V getCurrentScope0(List<Element<V>> list) {
        if (list == null) {
            return null;
        }
        int i = list.size();
        if (i == 0) {
            return null;
        }
        if (this.scopeLevel >= i) {
            return null;
        }
        return ScopeStack.getIfNotHidden(list.get(i - 1));
    }

    final V hide(K key) {
        return this.hide0(key, true);
    }

    final V show(K key) {
        return this.hide0(key, false);
    }

    private final V hide0(K key, boolean hidden) {
        Element<V> e = ScopeStack.getElement0(this.listOrNull(key));
        if (e == null) {
            return null;
        }
        e.hidden = hidden;
        return e.value;
    }

    final V get(K key) {
        return ScopeStack.get0(this.listOrNull(key));
    }

    final V getCurrentScope(K key) {
        return this.getCurrentScope0(this.listOrNull(key));
    }

    final <T extends Throwable> V getOrThrow(K key, Supplier<T> exception) throws T {
        V result = this.get(key);
        if (result == null) {
            throw (Throwable)exception.get();
        }
        return result;
    }

    final V getOrCreate(K key) {
        List<Element<V>> list = this.list(key);
        V result = ScopeStack.get0(list);
        return result != null ? result : this.create0(key, list);
    }

    final V create(K key) {
        return this.create0(key, this.list(key));
    }

    private final V create0(K key, List<Element<V>> list) {
        V result = this.constructor.apply(key, this.scopeLevel);
        this.set0(list, result);
        return result;
    }

    private final void set0(List<Element<V>> list, V value) {
        int l = this.scopeLevel + 1;
        int size = list.size();
        if (size < l) {
            int nulls = l - size;
            for (int i = 0; i < nulls; ++i) {
                list.add(null);
            }
        }
        list.set(this.scopeLevel, new Element<V>(value));
    }

    private final List<Element<V>> listOrNull(K key) {
        return this.stack().get(key);
    }

    private final List<Element<V>> list(K key) {
        return this.stack().computeIfAbsent(key, k -> new ArrayList());
    }

    final boolean inScope() {
        return this.scopeLevel > -1;
    }

    final int scopeLevel() {
        return this.scopeLevel;
    }

    final void scopeStart() {
        ++this.scopeLevel;
    }

    final void scopeEnd() {
        --this.scopeLevel;
        this.trim();
    }

    public String toString() {
        return this.stack().toString();
    }

    static final class Element<V> {
        final V value;
        boolean hidden;

        Element(V value) {
            this.value = value;
        }

        public String toString() {
            return "E[" + String.valueOf(this.value) + (this.hidden ? ", hidden" : "") + "]";
        }
    }

    private final class ScopeStackIterator<U>
    implements Iterator<U> {
        final Iterator<Map.Entry<K, List<Element<V>>>> it;
        final Function<Map.Entry<K, List<Element<V>>>, U> valueExtractor;
        final Predicate<? super U> filter;
        U next;

        ScopeStackIterator(BiFunction<K, List<Element<V>>, U> valueExtractor, Predicate<? super U> filter) {
            this((Map.Entry<K, List<Element<V>>> e) -> valueExtractor.apply(e.getKey(), (List)e.getValue()), filter);
        }

        ScopeStackIterator(Function<Map.Entry<K, List<Element<V>>>, U> valueExtractor, Predicate<? super U> filter) {
            this.it = ScopeStack.this.stack().entrySet().iterator();
            this.valueExtractor = valueExtractor;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            return this.move() != null;
        }

        @Override
        public U next() {
            if (this.next == null) {
                return this.move();
            }
            U result = this.next;
            this.next = null;
            return result;
        }

        private U move() {
            Map.Entry e;
            while (this.it.hasNext() && ((e = this.it.next()).getValue().isEmpty() || ScopeStack.get0(e.getValue()) == null || (this.next = this.valueExtractor.apply(e)) == null || !this.filter.test(this.next))) {
                this.next = null;
            }
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    record Value<V>(int scopeLevel, V value) {
        static <V> Value<V> of(int scopeLevel, V value) {
            return value == null ? null : new Value<V>(scopeLevel, value);
        }

        static <V> Value<V> lastOf(List<Element<V>> list) {
            int size = list.size();
            V value = ScopeStack.getIfNotHidden(list.get(size - 1));
            return Value.of(size - 1, value);
        }
    }
}

