/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function2;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class ArrayAppend<T>
extends AbstractField<T[]>
implements QOM.ArrayAppend<T> {
    final Field<T[]> array;
    final Field<T> append;

    ArrayAppend(Field<T[]> array, Field<T> append) {
        super(Names.N_ARRAY_APPEND, Tools.allNotNull(Tools.dataType(SQLDataType.OTHER.array(), array, false), array, append));
        this.array = Tools.nullSafeNotNull(array, SQLDataType.OTHER.array());
        this.append = Tools.nullSafeNotNull(append, SQLDataType.OTHER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: 
            case HSQLDB: 
            case TRINO: {
                return false;
            }
            case CLICKHOUSE: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: 
            case HSQLDB: 
            case TRINO: {
                ctx.visit(DSL.arrayConcat(this.array, DSL.array(this.append)));
                break;
            }
            case CLICKHOUSE: {
                ctx.visit(DSL.function(Names.N_arrayPushBack, this.getDataType(), this.array, this.append));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_ARRAY_APPEND, this.getDataType(), this.array, this.append));
            }
        }
    }

    @Override
    public final Field<T[]> $arg1() {
        return this.array;
    }

    @Override
    public final Field<T> $arg2() {
        return this.append;
    }

    @Override
    public final QOM.ArrayAppend<T> $arg1(Field<T[]> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.ArrayAppend<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T[]>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T[]>, ? super Field<T>, ? extends QOM.ArrayAppend<T>> $constructor() {
        return (a1, a2) -> new ArrayAppend((Field<T[]>)a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.ArrayAppend) {
            QOM.ArrayAppend o = (QOM.ArrayAppend)that;
            return StringUtils.equals(this.$array(), o.$array()) && StringUtils.equals(this.$append(), o.$append());
        }
        return super.equals(that);
    }
}

