/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPException;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPSocketFactory;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JavaToLDAPSocketFactory
extends SocketFactory
implements LDAPSocketFactory {
    @NotNull
    private final SocketFactory f;

    public JavaToLDAPSocketFactory(@NotNull SocketFactory f) {
        this.f = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Socket createSocket(@NotNull String host, int port) throws IOException {
        SocketFactory socketFactory = this.f;
        synchronized (socketFactory) {
            return this.f.createSocket(host, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Socket createSocket(@NotNull String host, int port, @NotNull InetAddress localAddress, int localPort) throws IOException {
        SocketFactory socketFactory = this.f;
        synchronized (socketFactory) {
            return this.f.createSocket(host, port, localAddress, localPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Socket createSocket(@NotNull InetAddress address, int port) throws IOException {
        SocketFactory socketFactory = this.f;
        synchronized (socketFactory) {
            return this.f.createSocket(address, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Socket createSocket(@NotNull InetAddress address, int port, @NotNull InetAddress localAddress, int localPort) throws IOException {
        SocketFactory socketFactory = this.f;
        synchronized (socketFactory) {
            return this.f.createSocket(address, port, localAddress, localPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Socket makeSocket(@NotNull String host, int port) throws LDAPException {
        try {
            SocketFactory socketFactory = this.f;
            synchronized (socketFactory) {
                return this.f.createSocket(host, port);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(StaticUtils.getExceptionMessage(e), 91);
        }
    }
}

