/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.lucene.search;

import com.github.fge.lambdas.Throwing;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.lucene.search.DocumentFieldConstants;
import org.apache.james.mailbox.lucene.search.LuceneMessageSearchIndex;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.searchhighligt.SearchHighlighter;
import org.apache.james.mailbox.searchhighligt.SearchHighlighterConfiguration;
import org.apache.james.mailbox.searchhighligt.SearchSnippet;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class LuceneSearchHighlighter
implements SearchHighlighter {
    private final LuceneMessageSearchIndex luceneMessageSearchIndex;
    private final Analyzer analyzer;
    private final Formatter formatter;
    private final MessageId.Factory messageIdFactory;
    private final SearchHighlighterConfiguration configuration;
    private final StoreMailboxManager storeMailboxManager;

    private static Analyzer defaultAnalyzer() {
        return new StandardAnalyzer();
    }

    public LuceneSearchHighlighter(LuceneMessageSearchIndex luceneMessageSearchIndex, SearchHighlighterConfiguration searchHighlighterConfiguration, MessageId.Factory messageIdFactory, StoreMailboxManager storeMailboxManager, Analyzer analyzer) {
        this.luceneMessageSearchIndex = luceneMessageSearchIndex;
        this.messageIdFactory = messageIdFactory;
        this.analyzer = analyzer;
        this.configuration = searchHighlighterConfiguration;
        this.storeMailboxManager = storeMailboxManager;
        this.formatter = new SimpleHTMLFormatter(searchHighlighterConfiguration.preTagFormatter(), searchHighlighterConfiguration.postTagFormatter());
    }

    @Inject
    @Singleton
    public LuceneSearchHighlighter(LuceneMessageSearchIndex luceneMessageSearchIndex, SearchHighlighterConfiguration searchHighlighterConfiguration, MessageId.Factory messageIdFactory, StoreMailboxManager storeMailboxManager) {
        this(luceneMessageSearchIndex, searchHighlighterConfiguration, messageIdFactory, storeMailboxManager, LuceneSearchHighlighter.defaultAnalyzer());
    }

    public Flux<SearchSnippet> highlightSearch(List<MessageId> messageIds, MultimailboxesSearchQuery expression, MailboxSession session) {
        if (messageIds.isEmpty() || expression.getSearchQuery().getCriteria().isEmpty()) {
            return Flux.empty();
        }
        return this.storeMailboxManager.getInMailboxIds(expression, session).collectList().flatMapMany(inMailboxIdsAccessible -> this.highlightSearch((Collection<MailboxId>)inMailboxIdsAccessible, expression.getSearchQuery(), messageIds));
    }

    private Flux<SearchSnippet> highlightSearch(Collection<MailboxId> mailboxIds, SearchQuery searchQuery, List<MessageId> messageIds) {
        int limit = messageIds.size();
        return Mono.fromCallable(() -> this.luceneMessageSearchIndex.searchDocument(mailboxIds, searchQuery, limit)).flatMapMany(Flux::fromIterable).map(document -> (SearchSnippet)Throwing.supplier(() -> this.buildSearchSnippet((Document)document, searchQuery)).get()).filter(searchSnippet -> messageIds.contains(searchSnippet.messageId())).subscribeOn(Schedulers.boundedElastic());
    }

    private Highlighter highlighter(SearchQuery searchQuery) {
        Query query = this.buildQueryFromSearchQuery(searchQuery);
        QueryScorer scorer = new QueryScorer(query);
        Highlighter highlighter = new Highlighter(this.formatter, (Scorer)scorer);
        highlighter.setEncoder((Encoder)new SimpleHTMLEncoder());
        highlighter.setTextFragmenter((Fragmenter)new SimpleSpanFragmenter(scorer, this.configuration.fragmentSize()));
        return highlighter;
    }

    private Query buildQueryFromSearchQuery(SearchQuery searchQuery) {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        searchQuery.getCriteria().stream().map(this::buildQueryFromCriterion).flatMap(Optional::stream).forEach(query -> queryBuilder.add(query, BooleanClause.Occur.SHOULD));
        return queryBuilder.build();
    }

    private Optional<Query> buildQueryFromCriterion(SearchQuery.Criterion criterion) {
        SearchQuery.ConjunctionCriterion conjunctionCriterion;
        if (criterion instanceof SearchQuery.TextCriterion) {
            SearchQuery.TextCriterion textCriterion = (SearchQuery.TextCriterion)criterion;
            return Optional.of(this.buildQuery("body", textCriterion.getOperator().getValue().toLowerCase(Locale.US)));
        }
        if (criterion instanceof SearchQuery.SubjectCriterion) {
            SearchQuery.SubjectCriterion subjectCriterion = (SearchQuery.SubjectCriterion)criterion;
            return Optional.of(this.buildQuery("subject", subjectCriterion.getSubject().toLowerCase(Locale.US)));
        }
        if (criterion instanceof SearchQuery.ConjunctionCriterion && !(conjunctionCriterion = (SearchQuery.ConjunctionCriterion)criterion).getType().equals((Object)SearchQuery.Conjunction.NOR)) {
            BooleanQuery.Builder conQuery = new BooleanQuery.Builder();
            conjunctionCriterion.getCriteria().stream().map(this::buildQueryFromCriterion).flatMap(Optional::stream).forEach(query -> conQuery.add(query, BooleanClause.Occur.SHOULD));
            return Optional.of(conQuery.build());
        }
        return Optional.empty();
    }

    private Query buildQuery(String field, String queryValue) {
        QueryParser parser = new QueryParser(field, this.analyzer);
        return (Query)Throwing.supplier(() -> parser.parse(queryValue)).get();
    }

    private SearchSnippet buildSearchSnippet(Document doc, SearchQuery searchQuery) {
        MessageId messageId = this.messageIdFactory.fromString(doc.get("messageid"));
        Optional<String> highlightedSubject = Optional.ofNullable(this.getHighlightedSubject(doc, searchQuery));
        Optional<String> highlightedBody = Optional.ofNullable(this.getHighlightedBody(doc, searchQuery)).or(() -> this.getHighlightAttachmentTextBody(doc, searchQuery));
        return new SearchSnippet(messageId, highlightedSubject, highlightedBody);
    }

    private String getHighlightedSubject(Document doc, SearchQuery searchQuery) {
        return Optional.ofNullable(doc.get("subject")).map(Throwing.function(subject -> this.highlighter(searchQuery).getBestFragment(this.analyzer, "subject", subject))).orElse(null);
    }

    private String getHighlightedBody(Document doc, SearchQuery searchQuery) {
        return Optional.ofNullable(doc.get("body")).map(Throwing.function(body -> this.highlighter(searchQuery).getBestFragment(this.analyzer, "body", body))).orElse(null);
    }

    private Optional<String> getHighlightAttachmentTextBody(Document doc, SearchQuery searchQuery) {
        Highlighter highlighter = this.highlighter(searchQuery);
        return Stream.ofNullable(doc.getFields(DocumentFieldConstants.ATTACHMENT_TEXT_CONTENT_FIELD)).flatMap(Arrays::stream).map(IndexableField::stringValue).map(Throwing.function(contentType -> highlighter.getBestFragment(this.analyzer, DocumentFieldConstants.ATTACHMENT_TEXT_CONTENT_FIELD, contentType))).findFirst();
    }
}

