/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.lmtpserver.hook;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.lmtpserver.DataLineLMTPHandler;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.protocols.lmtp.hook.DeliverToRecipientHook;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.util.AuditTrail;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class MailboxDeliverToRecipientHandler
implements DeliverToRecipientHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailboxDeliverToRecipientHandler.class);
    private final UsersRepository users;
    private final MailboxManager mailboxManager;

    @Inject
    public MailboxDeliverToRecipientHandler(UsersRepository users, @Named(value="mailboxmanager") MailboxManager mailboxManager) {
        this.users = users;
        this.mailboxManager = mailboxManager;
    }

    public HookResult deliver(SMTPSession session, MailAddress recipient, final MailEnvelope envelope) {
        try {
            Username username = this.users.getUsername(recipient);
            MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
            MailboxPath inbox = MailboxPath.inbox((MailboxSession)mailboxSession);
            this.mailboxManager.startProcessingRequest(mailboxSession);
            if (Boolean.FALSE.equals(Mono.from((Publisher)this.mailboxManager.mailboxExists(inbox, mailboxSession)).block())) {
                Optional mailboxId = this.mailboxManager.createMailbox(inbox, mailboxSession);
                LOGGER.info("Provisioning INBOX. {} created.", (Object)mailboxId);
            }
            this.mailboxManager.getMailbox(MailboxPath.inbox((Username)username), mailboxSession).appendMessage(MessageManager.AppendCommand.builder().recent().build(new Content(){

                public InputStream getInputStream() throws IOException {
                    return envelope.getMessageInputStream();
                }

                public long size() {
                    return envelope.getSize();
                }
            }), mailboxSession);
            this.mailboxManager.endProcessingRequest(mailboxSession);
            this.auditTrail(session, recipient, envelope);
            return HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpReturnCode("250").smtpDescription(DSNStatus.getStatus((int)2, (String)"6.0") + " Message received <" + recipient.asString() + ">").build();
        }
        catch (OverQuotaException e) {
            LOGGER.info("{} is over quota", (Object)recipient);
            return HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpReturnCode("552").smtpDescription(DSNStatus.getStatus((int)5, (String)"2.2") + " Over Quota error when delivering message to <" + String.valueOf(recipient) + ">").build();
        }
        catch (MailboxException | UsersRepositoryException e) {
            LOGGER.error("Unexpected error handling DATA stream", e);
            return HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpDescription(" Temporary error deliver message to " + String.valueOf(recipient)).build();
        }
    }

    private void auditTrail(SMTPSession session, MailAddress recipient, MailEnvelope envelope) {
        if (envelope instanceof DataLineLMTPHandler.ReadOnlyMailEnvelope) {
            DataLineLMTPHandler.ReadOnlyMailEnvelope readOnlyMailEnvelope = (DataLineLMTPHandler.ReadOnlyMailEnvelope)envelope;
            AuditTrail.entry().username(() -> Optional.ofNullable(session.getUsername()).map(Username::asString).orElse("")).remoteIP(() -> Optional.ofNullable(session.getRemoteAddress())).sessionId(() -> ((SMTPSession)session).getSessionID()).protocol("LMTP").action("Deliver mail").parameters(() -> Map.of("mailId", readOnlyMailEnvelope.getMailId(), "mimeMessageId", readOnlyMailEnvelope.getMimeMessageId().orElse(""), "sender", readOnlyMailEnvelope.getMaybeSender().asString(), "recipient", recipient.asString())).log("LMTP mail sent.");
        }
    }
}

