/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.webadmin.service.DeleteUserDataService;
import reactor.core.publisher.Mono;

public class DeleteUserDataTask
implements Task {
    static final TaskType TYPE = TaskType.of((String)"DeleteUserDataTask");
    private final Username username;
    private final DeleteUserDataService.Performer performer;
    private final Optional<DeleteUserDataTaskStep.StepName> fromStep;

    public DeleteUserDataTask(DeleteUserDataService service, Username username, Optional<DeleteUserDataTaskStep.StepName> fromStep) {
        this.username = username;
        this.performer = service.performer(fromStep);
        this.fromStep = fromStep;
    }

    public Task.Result run() {
        return (Task.Result)this.performer.deleteUserData(this.username).thenReturn((Object)Task.Result.COMPLETED).onErrorResume(e -> {
            LOGGER.error("Error while deleting data of the user {}", (Object)this.username.asString(), e);
            return Mono.just((Object)Task.Result.PARTIAL);
        }).block();
    }

    public TaskType type() {
        return TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(Clock.systemUTC().instant(), this.username, this.performer.getStatus().getStates(), this.fromStep));
    }

    public Username getUsername() {
        return this.username;
    }

    public Optional<DeleteUserDataTaskStep.StepName> getFromStep() {
        return this.fromStep;
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant timestamp;
        private final Username username;
        private final Map<DeleteUserDataTaskStep.StepName, DeleteUserDataService.StepState> status;
        private final Optional<DeleteUserDataTaskStep.StepName> fromStep;

        public AdditionalInformation(Instant timestamp, Username username, Map<DeleteUserDataTaskStep.StepName, DeleteUserDataService.StepState> status, Optional<DeleteUserDataTaskStep.StepName> fromStep) {
            this.timestamp = timestamp;
            this.username = username;
            this.status = status;
            this.fromStep = fromStep;
        }

        public Optional<DeleteUserDataTaskStep.StepName> getFromStep() {
            return this.fromStep;
        }

        public Username getUsername() {
            return this.username;
        }

        public Map<DeleteUserDataTaskStep.StepName, DeleteUserDataService.StepState> getStatus() {
            return this.status;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

