/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.OrderedColumnList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class OrderByList
extends OrderedColumnList<OrderByColumn>
implements RequiredRowOrdering {
    private boolean allAscending = true;
    private boolean alwaysSort;
    private ResultSetNode resultToSort;
    private SortCostController scc;
    private Object[] resultRow;
    private ColumnOrdering[] columnOrdering;
    private int estimatedRowSize;
    private boolean sortNeeded = true;
    private int resultSetNumber = -1;
    private boolean isTableValueCtorOrdering;

    OrderByList(ResultSetNode resultSetNode, ContextManager contextManager) {
        super(OrderByColumn.class, contextManager);
        this.isTableValueCtorOrdering = resultSetNode instanceof UnionNode && ((UnionNode)resultSetNode).tableConstructor() || resultSetNode instanceof RowResultSetNode;
    }

    void addOrderByColumn(OrderByColumn orderByColumn) {
        this.addElement(orderByColumn);
        if (!orderByColumn.isAscending()) {
            this.allAscending = false;
        }
    }

    boolean allAscending() {
        return this.allAscending;
    }

    OrderByColumn getOrderByColumn(int n) {
        return (OrderByColumn)this.elementAt(n);
    }

    void bindOrderByColumns(ResultSetNode resultSetNode) throws StandardException {
        this.resultToSort = resultSetNode;
        if (this.size() > 1012) {
            throw StandardException.newException((String)"54004", (Object[])new Object[0]);
        }
        for (OrderByColumn orderByColumn : this) {
            orderByColumn.bindOrderByColumn(resultSetNode, this);
            if (orderByColumn.getResultColumn().getExpression() instanceof ColumnReference) continue;
            this.alwaysSort = true;
        }
    }

    void closeGap(int n) {
        for (OrderByColumn orderByColumn : this) {
            orderByColumn.collapseAddedColumnGap(n);
        }
    }

    void pullUpOrderByColumns(ResultSetNode resultSetNode) throws StandardException {
        this.resultToSort = resultSetNode;
        for (OrderByColumn orderByColumn : this) {
            orderByColumn.pullUpOrderByColumn(resultSetNode);
        }
    }

    boolean isInOrderPrefix(ResultColumnList resultColumnList) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (((OrderByColumn)this.elementAt(i)).getResultColumn() == resultColumnList.elementAt(i)) continue;
            return false;
        }
        return true;
    }

    void resetToSourceRCs() {
        for (OrderByColumn orderByColumn : this) {
            orderByColumn.resetToSourceRC();
        }
    }

    ResultColumnList reorderRCL(ResultColumnList resultColumnList) throws StandardException {
        ResultColumnList resultColumnList2 = new ResultColumnList(this.getContextManager());
        for (OrderByColumn orderByColumn : this) {
            resultColumnList2.addElement(orderByColumn.getResultColumn());
            resultColumnList.removeElement(orderByColumn.getResultColumn());
        }
        resultColumnList2.destructiveAppend(resultColumnList);
        resultColumnList2.resetVirtualColumnIds();
        resultColumnList2.copyOrderBySelect(resultColumnList);
        return resultColumnList2;
    }

    void removeConstantColumns(PredicateList predicateList) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!((OrderByColumn)this.elementAt(i)).constantColumn(predicateList)) continue;
            this.removeElementAt(i);
        }
    }

    void removeDupColumns() {
        block0: for (int i = this.size() - 1; i > 0; --i) {
            OrderByColumn orderByColumn = (OrderByColumn)this.elementAt(i);
            int n = orderByColumn.getColumnPosition();
            for (int j = 0; j < i; ++j) {
                OrderByColumn orderByColumn2 = (OrderByColumn)this.elementAt(j);
                if (n != orderByColumn2.getColumnPosition()) continue;
                this.removeElementAt(i);
                continue block0;
            }
        }
    }

    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, ResultSetNode resultSetNode) throws StandardException {
        if (!this.sortNeeded) {
            resultSetNode.generate(activationClassBuilder, methodBuilder);
            return;
        }
        CompilerContext compilerContext = this.getCompilerContext();
        int n = activationClassBuilder.addItem(activationClassBuilder.getColumnOrdering(this));
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        resultSetNode.generate(activationClassBuilder, methodBuilder);
        this.resultSetNumber = compilerContext.getNextResultSetNumber();
        methodBuilder.push(false);
        methodBuilder.push(false);
        methodBuilder.push(n);
        methodBuilder.push(activationClassBuilder.addItem(resultSetNode.getResultColumns().buildRowTemplate()));
        methodBuilder.push(resultSetNode.getResultColumns().getTotalColumnSize());
        methodBuilder.push(this.resultSetNumber);
        CostEstimate costEstimate = resultSetNode.getFinalCostEstimate();
        methodBuilder.push(costEstimate.rowCount());
        methodBuilder.push(costEstimate.getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getSortResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 9);
    }

    @Override
    public int sortRequired(RowOrdering rowOrdering, OptimizableList optimizableList, int[] nArray) throws StandardException {
        return this.sortRequired(rowOrdering, null, optimizableList, nArray);
    }

    @Override
    public int sortRequired(RowOrdering rowOrdering, JBitSet jBitSet, OptimizableList optimizableList, int[] nArray) throws StandardException {
        if (this.alwaysSort) {
            return 1;
        }
        int n = 0;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            Visitable visitable;
            int n3;
            OrderByColumn orderByColumn = this.getOrderByColumn(i);
            if (orderByColumn.isNullsOrderedLow()) {
                return 1;
            }
            ValueNode valueNode = orderByColumn.getResultColumn().getExpression();
            if (!(valueNode instanceof ColumnReference)) {
                return 1;
            }
            ColumnReference columnReference = (ColumnReference)valueNode;
            if (jBitSet != null && !jBitSet.get(columnReference.getTableNumber())) {
                for (n3 = i + 1; n3 < this.size(); ++n3) {
                    ColumnReference columnReference2;
                    OrderByColumn orderByColumn2 = this.getOrderByColumn(i);
                    visitable = orderByColumn2.getResultColumn();
                    ValueNode valueNode2 = ((ResultColumn)visitable).getExpression();
                    if (!(valueNode2 instanceof ColumnReference) || !jBitSet.get((columnReference2 = (ColumnReference)valueNode2).getTableNumber())) continue;
                    return 1;
                }
                return 3;
            }
            int n4 = jBitSet != null ? (!jBitSet.hasSingleBitSet() ? 1 : 0) : (n3 = 0);
            if (n3 != 0 && !rowOrdering.alwaysOrdered(columnReference.getTableNumber()) && !rowOrdering.isColumnAlwaysOrdered(columnReference.getTableNumber(), columnReference.getColumnNumber())) {
                for (int j = 0; j < nArray.length && nArray[j] != -1 && (visitable = optimizableList.getOptimizable(nArray[j])).getTableNumber() != columnReference.getTableNumber(); ++j) {
                    if (rowOrdering.alwaysOrdered(visitable.getTableNumber())) continue;
                    return 1;
                }
            }
            if (rowOrdering.alwaysOrdered(columnReference.getTableNumber())) continue;
            if (!rowOrdering.orderedOnColumn(orderByColumn.isAscending() ? 1 : 2, n, columnReference.getTableNumber(), columnReference.getColumnNumber())) {
                return 1;
            }
            ++n;
        }
        return 3;
    }

    @Override
    public void estimateCost(double d, RowOrdering rowOrdering, CostEstimate costEstimate) throws StandardException {
        long l;
        if (this.scc == null) {
            this.scc = this.getCompilerContext().getSortCostController();
            this.resultRow = this.resultToSort.getResultColumns().buildEmptyRow().getRowArray();
            this.columnOrdering = this.getColumnOrdering();
            this.estimatedRowSize = this.resultToSort.getResultColumns().getTotalColumnSize();
        }
        long l2 = l = (long)d;
        double d2 = this.scc.getSortCost((DataValueDescriptor[])this.resultRow, this.columnOrdering, false, l, l2, this.estimatedRowSize);
        costEstimate.setCost(d2, d, d);
    }

    @Override
    public void sortNeeded() {
        this.sortNeeded = true;
    }

    @Override
    public void sortNotNeeded() {
        this.sortNeeded = false;
    }

    void remapColumnReferencesToExpressions() throws StandardException {
    }

    @Override
    public boolean getSortNeeded() {
        return this.sortNeeded;
    }

    boolean requiresDescending(ColumnReference columnReference, int n) throws StandardException {
        int n2 = this.size();
        JBitSet jBitSet = new JBitSet(n);
        BaseTableNumbersVisitor baseTableNumbersVisitor = new BaseTableNumbersVisitor(jBitSet);
        columnReference.accept(baseTableNumbersVisitor);
        int n3 = jBitSet.getFirstSetBit();
        int n4 = baseTableNumbersVisitor.getColumnNumber();
        for (int i = 0; i < n2; ++i) {
            OrderByColumn orderByColumn = this.getOrderByColumn(i);
            ResultColumn resultColumn = orderByColumn.getResultColumn();
            baseTableNumbersVisitor.reset();
            resultColumn.accept(baseTableNumbersVisitor);
            int n5 = jBitSet.getFirstSetBit();
            int n6 = baseTableNumbersVisitor.getColumnNumber();
            if (n3 != n5 || n4 != n6) continue;
            return !orderByColumn.isAscending();
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.columnOrdering != null) {
            for (int i = 0; i < this.columnOrdering.length; ++i) {
                stringBuilder.append("[" + i + "] " + String.valueOf(this.columnOrdering[i]) + "\n");
            }
        }
        return "allAscending: " + this.allAscending + "\nalwaysSort:" + this.allAscending + "\nsortNeeded: " + this.sortNeeded + "\ncolumnOrdering: \n" + stringBuilder.toString() + "\n" + super.toString();
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    public boolean isTableValueCtorOrdering() {
        return this.isTableValueCtorOrdering;
    }
}

