/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GeneralMonitorEntry
extends MonitorEntry {
    @NotNull
    static final String GENERAL_MONITOR_OC = "ds-general-monitor-entry";
    @NotNull
    private static final String ATTR_CLUSTER_NAME = "clusterName";
    @NotNull
    private static final String ATTR_CURRENT_CONNECTIONS = "currentConnections";
    @NotNull
    private static final String ATTR_CURRENT_TIME = "currentTime";
    @NotNull
    private static final String ATTR_DEGRADED_ALERT_TYPE = "degraded-alert-type";
    @NotNull
    private static final String ATTR_INSTANCE_NAME = "instanceName";
    @NotNull
    private static final String ATTR_LOCATION_DN = "locationDN";
    @NotNull
    private static final String ATTR_LOCATION_NAME = "locationName";
    @NotNull
    private static final String ATTR_MAX_CONNECTIONS = "maxConnections";
    @NotNull
    private static final String ATTR_PRODUCT_NAME = "productName";
    @NotNull
    private static final String ATTR_SERVER_UUID = "serverUUID";
    @NotNull
    private static final String ATTR_START_TIME = "startTime";
    @NotNull
    private static final String ATTR_STARTUP_ID = "startupID";
    @NotNull
    private static final String ATTR_STARTUP_UUID = "startupUUID";
    @NotNull
    private static final String ATTR_THIRD_PARTY_EXTENSION_DN = "thirdPartyExtensionDN";
    @NotNull
    private static final String ATTR_TOTAL_CONNECTIONS = "totalConnections";
    @NotNull
    private static final String ATTR_UP_TIME = "upTime";
    @NotNull
    private static final String ATTR_VENDOR_NAME = "productVendor";
    @NotNull
    private static final String ATTR_VERSION = "productVersion";
    @NotNull
    private static final String ATTR_UNAVAILABLE_ALERT_TYPE = "unavailable-alert-type";
    private static final long serialVersionUID = 4262569940859462743L;
    @Nullable
    private final Date currentTime;
    @Nullable
    private final Date startTime;
    @NotNull
    private final List<String> degradedAlertTypes;
    @NotNull
    private final List<String> thirdPartyExtensionDNs;
    @NotNull
    private final List<String> unavailableAlertTypes;
    @Nullable
    private final Long currentConnections = this.getLong("currentConnections");
    @Nullable
    private final Long maxConnections;
    @Nullable
    private final Long totalConnections;
    @Nullable
    private final String clusterName;
    @Nullable
    private final String instanceName;
    @Nullable
    private final String locationDN;
    @Nullable
    private final String locationName;
    @Nullable
    private final String productName;
    @Nullable
    private final String serverUUID;
    @Nullable
    private final String startupID;
    @Nullable
    private final String startupUUID;
    @Nullable
    private final String uptime;
    @Nullable
    private final String vendorName;
    @Nullable
    private final String versionString;

    public GeneralMonitorEntry(@NotNull Entry entry) {
        super(entry);
        this.currentTime = this.getDate(ATTR_CURRENT_TIME);
        this.maxConnections = this.getLong(ATTR_MAX_CONNECTIONS);
        this.productName = this.getString(ATTR_PRODUCT_NAME);
        this.startTime = this.getDate(ATTR_START_TIME);
        this.clusterName = this.getString(ATTR_CLUSTER_NAME);
        this.instanceName = this.getString(ATTR_INSTANCE_NAME);
        this.locationDN = this.getString(ATTR_LOCATION_DN);
        this.locationName = this.getString(ATTR_LOCATION_NAME);
        this.serverUUID = this.getString(ATTR_SERVER_UUID);
        this.startupID = this.getString(ATTR_STARTUP_ID);
        this.startupUUID = this.getString(ATTR_STARTUP_UUID);
        this.totalConnections = this.getLong(ATTR_TOTAL_CONNECTIONS);
        this.uptime = this.getString(ATTR_UP_TIME);
        this.vendorName = this.getString(ATTR_VENDOR_NAME);
        this.versionString = this.getString(ATTR_VERSION);
        this.degradedAlertTypes = this.getStrings(ATTR_DEGRADED_ALERT_TYPE);
        this.unavailableAlertTypes = this.getStrings(ATTR_UNAVAILABLE_ALERT_TYPE);
        this.thirdPartyExtensionDNs = this.getStrings(ATTR_THIRD_PARTY_EXTENSION_DN);
    }

    @Nullable
    public Long getCurrentConnections() {
        return this.currentConnections;
    }

    @Nullable
    public Long getMaxConnections() {
        return this.maxConnections;
    }

    @Nullable
    public Long getTotalConnections() {
        return this.totalConnections;
    }

    @Nullable
    public Date getCurrentTime() {
        return this.currentTime;
    }

    @Nullable
    public Date getStartTime() {
        return this.startTime;
    }

    @Nullable
    public String getClusterName() {
        return this.clusterName;
    }

    @Nullable
    public String getInstanceName() {
        return this.instanceName;
    }

    @Nullable
    public String getLocationName() {
        return this.locationName;
    }

    @Nullable
    public String getLocationDN() {
        return this.locationDN;
    }

    @Nullable
    public String getServerUUID() {
        return this.serverUUID;
    }

    @Nullable
    public String getStartupID() {
        return this.startupID;
    }

    @Nullable
    public String getStartupUUID() {
        return this.startupUUID;
    }

    @Nullable
    public Long getUptimeMillis() {
        if (this.currentTime == null || this.startTime == null) {
            return null;
        }
        return this.currentTime.getTime() - this.startTime.getTime();
    }

    @Nullable
    public String getUptimeString() {
        return this.uptime;
    }

    @Nullable
    public String getProductName() {
        return this.productName;
    }

    @Nullable
    public String getVendorName() {
        return this.vendorName;
    }

    @Nullable
    public String getVersionString() {
        return this.versionString;
    }

    @NotNull
    public List<String> getDegradedAlertTypes() {
        return this.degradedAlertTypes;
    }

    @NotNull
    public List<String> getUnavailableAlertTypes() {
        return this.unavailableAlertTypes;
    }

    @NotNull
    public List<String> getThirdPartyExtensionDNs() {
        return this.thirdPartyExtensionDNs;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_GENERAL_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_GENERAL_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(30));
        if (this.productName != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_PRODUCT_NAME, MonitorMessages.INFO_GENERAL_DISPNAME_PRODUCT_NAME.get(), MonitorMessages.INFO_GENERAL_DESC_PRODUCT_NAME.get(), this.productName);
        }
        if (this.vendorName != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_VENDOR_NAME, MonitorMessages.INFO_GENERAL_DISPNAME_VENDOR_NAME.get(), MonitorMessages.INFO_GENERAL_DESC_VENDOR_NAME.get(), this.vendorName);
        }
        if (this.versionString != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_VERSION, MonitorMessages.INFO_GENERAL_DISPNAME_VERSION.get(), MonitorMessages.INFO_GENERAL_DESC_VERSION.get(), this.versionString);
        }
        if (this.clusterName != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_CLUSTER_NAME, MonitorMessages.INFO_GENERAL_DISPNAME_CLUSTER_NAME.get(), MonitorMessages.INFO_GENERAL_DESC_CLUSTER_NAME.get(), this.clusterName);
        }
        if (this.instanceName != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_INSTANCE_NAME, MonitorMessages.INFO_GENERAL_DISPNAME_INSTANCE_NAME.get(), MonitorMessages.INFO_GENERAL_DESC_INSTANCE_NAME.get(), this.instanceName);
        }
        if (this.locationName != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_LOCATION_NAME, MonitorMessages.INFO_GENERAL_DISPNAME_LOCATION_NAME.get(), MonitorMessages.INFO_GENERAL_DESC_LOCATION_NAME.get(), this.locationName);
        }
        if (this.locationDN != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_LOCATION_DN, MonitorMessages.INFO_GENERAL_DISPNAME_LOCATION_DN.get(), MonitorMessages.INFO_GENERAL_DESC_LOCATION_DN.get(), this.locationDN);
        }
        if (this.startTime != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_START_TIME, MonitorMessages.INFO_GENERAL_DISPNAME_START_TIME.get(), MonitorMessages.INFO_GENERAL_DESC_START_TIME.get(), this.startTime);
        }
        if (this.serverUUID != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_SERVER_UUID, MonitorMessages.INFO_GENERAL_DISPNAME_SERVER_UUID.get(), MonitorMessages.INFO_GENERAL_DESC_SERVER_UUID.get(), this.serverUUID);
        }
        if (this.startupID != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_STARTUP_ID, MonitorMessages.INFO_GENERAL_DISPNAME_STARTUP_ID.get(), MonitorMessages.INFO_GENERAL_DESC_STARTUP_ID.get(), this.startupID);
        }
        if (this.startupUUID != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_STARTUP_UUID, MonitorMessages.INFO_GENERAL_DISPNAME_STARTUP_UUID.get(), MonitorMessages.INFO_GENERAL_DESC_STARTUP_UUID.get(), this.startupUUID);
        }
        if (this.currentTime != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_TIME, MonitorMessages.INFO_GENERAL_DISPNAME_CURRENT_TIME.get(), MonitorMessages.INFO_GENERAL_DESC_CURRENT_TIME.get(), this.currentTime);
        }
        if (this.uptime != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_UP_TIME, MonitorMessages.INFO_GENERAL_DISPNAME_UPTIME.get(), MonitorMessages.INFO_GENERAL_DESC_UPTIME.get(), this.uptime);
        }
        if (this.startTime != null && this.currentTime != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, "upTimeMillis", MonitorMessages.INFO_GENERAL_DISPNAME_UPTIME_MILLIS.get(), MonitorMessages.INFO_GENERAL_DESC_UPTIME_MILLIS.get(), this.currentTime.getTime() - this.startTime.getTime());
        }
        if (this.currentConnections != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_CONNECTIONS, MonitorMessages.INFO_GENERAL_DISPNAME_CURRENT_CONNECTIONS.get(), MonitorMessages.INFO_GENERAL_DESC_CURRENT_CONNECTIONS.get(), this.currentConnections);
        }
        if (this.maxConnections != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_CONNECTIONS, MonitorMessages.INFO_GENERAL_DISPNAME_MAX_CONNECTIONS.get(), MonitorMessages.INFO_GENERAL_DESC_MAX_CONNECTIONS.get(), this.maxConnections);
        }
        if (this.totalConnections != null) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_CONNECTIONS, MonitorMessages.INFO_GENERAL_DISPNAME_TOTAL_CONNECTIONS.get(), MonitorMessages.INFO_GENERAL_DESC_TOTAL_CONNECTIONS.get(), this.totalConnections);
        }
        if (!this.degradedAlertTypes.isEmpty()) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_DEGRADED_ALERT_TYPE, MonitorMessages.INFO_GENERAL_DISPNAME_DEGRADED_ALERT_TYPE.get(), MonitorMessages.INFO_GENERAL_DESC_DEGRADED_ALERT_TYPE.get(), this.degradedAlertTypes);
        }
        if (!this.unavailableAlertTypes.isEmpty()) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_UNAVAILABLE_ALERT_TYPE, MonitorMessages.INFO_GENERAL_DISPNAME_UNAVAILABLE_ALERT_TYPE.get(), MonitorMessages.INFO_GENERAL_DESC_UNAVAILABLE_ALERT_TYPE.get(), this.unavailableAlertTypes);
        }
        if (!this.thirdPartyExtensionDNs.isEmpty()) {
            GeneralMonitorEntry.addMonitorAttribute(attrs, ATTR_THIRD_PARTY_EXTENSION_DN, MonitorMessages.INFO_GENERAL_DISPNAME_THIRD_PARTY_EXTENSION_DN.get(), MonitorMessages.INFO_GENERAL_DESC_THIRD_PARTY_EXTENSION_DN.get(), this.thirdPartyExtensionDNs);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

