/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.query_dsl.Intervals;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsFilterVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class IntervalsFilter
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<IntervalsFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IntervalsFilter::setupIntervalsFilterDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public IntervalsFilter(IntervalsFilterVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._intervalsFilterKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private IntervalsFilter(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static IntervalsFilter of(Function<Builder, ObjectBuilder<IntervalsFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isAfter() {
        return this._kind == Kind.After;
    }

    public Intervals after() {
        return (Intervals)TaggedUnionUtils.get(this, Kind.After);
    }

    public boolean isBefore() {
        return this._kind == Kind.Before;
    }

    public Intervals before() {
        return (Intervals)TaggedUnionUtils.get(this, Kind.Before);
    }

    public boolean isContainedBy() {
        return this._kind == Kind.ContainedBy;
    }

    public Intervals containedBy() {
        return (Intervals)TaggedUnionUtils.get(this, Kind.ContainedBy);
    }

    public boolean isContaining() {
        return this._kind == Kind.Containing;
    }

    public Intervals containing() {
        return (Intervals)TaggedUnionUtils.get(this, Kind.Containing);
    }

    public boolean isNotContainedBy() {
        return this._kind == Kind.NotContainedBy;
    }

    public Intervals notContainedBy() {
        return (Intervals)TaggedUnionUtils.get(this, Kind.NotContainedBy);
    }

    public boolean isNotContaining() {
        return this._kind == Kind.NotContaining;
    }

    public Intervals notContaining() {
        return (Intervals)TaggedUnionUtils.get(this, Kind.NotContaining);
    }

    public boolean isNotOverlapping() {
        return this._kind == Kind.NotOverlapping;
    }

    public Intervals notOverlapping() {
        return (Intervals)TaggedUnionUtils.get(this, Kind.NotOverlapping);
    }

    public boolean isOverlapping() {
        return this._kind == Kind.Overlapping;
    }

    public Intervals overlapping() {
        return (Intervals)TaggedUnionUtils.get(this, Kind.Overlapping);
    }

    public boolean isScript() {
        return this._kind == Kind.Script;
    }

    public Script script() {
        return (Script)TaggedUnionUtils.get(this, Kind.Script);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public Builder toBuilder() {
        return new Builder()._kind(this._kind)._value(this._value);
    }

    protected static void setupIntervalsFilterDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::after, Intervals._DESERIALIZER, "after");
        op.add(Builder::before, Intervals._DESERIALIZER, "before");
        op.add(Builder::containedBy, Intervals._DESERIALIZER, "contained_by");
        op.add(Builder::containing, Intervals._DESERIALIZER, "containing");
        op.add(Builder::notContainedBy, Intervals._DESERIALIZER, "not_contained_by");
        op.add(Builder::notContaining, Intervals._DESERIALIZER, "not_containing");
        op.add(Builder::notOverlapping, Intervals._DESERIALIZER, "not_overlapping");
        op.add(Builder::overlapping, Intervals._DESERIALIZER, "overlapping");
        op.add(Builder::script, Script._DESERIALIZER, "script");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IntervalsFilter> {
        private Kind _kind;
        private Object _value;

        protected final Builder _kind(Kind v) {
            this._kind = v;
            return this;
        }

        protected final Builder _value(Object v) {
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsFilter> after(Intervals v) {
            this._kind = Kind.After;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsFilter> after(Function<Intervals.Builder, ObjectBuilder<Intervals>> fn) {
            return this.after(fn.apply(new Intervals.Builder()).build());
        }

        public ObjectBuilder<IntervalsFilter> before(Intervals v) {
            this._kind = Kind.Before;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsFilter> before(Function<Intervals.Builder, ObjectBuilder<Intervals>> fn) {
            return this.before(fn.apply(new Intervals.Builder()).build());
        }

        public ObjectBuilder<IntervalsFilter> containedBy(Intervals v) {
            this._kind = Kind.ContainedBy;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsFilter> containedBy(Function<Intervals.Builder, ObjectBuilder<Intervals>> fn) {
            return this.containedBy(fn.apply(new Intervals.Builder()).build());
        }

        public ObjectBuilder<IntervalsFilter> containing(Intervals v) {
            this._kind = Kind.Containing;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsFilter> containing(Function<Intervals.Builder, ObjectBuilder<Intervals>> fn) {
            return this.containing(fn.apply(new Intervals.Builder()).build());
        }

        public ObjectBuilder<IntervalsFilter> notContainedBy(Intervals v) {
            this._kind = Kind.NotContainedBy;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsFilter> notContainedBy(Function<Intervals.Builder, ObjectBuilder<Intervals>> fn) {
            return this.notContainedBy(fn.apply(new Intervals.Builder()).build());
        }

        public ObjectBuilder<IntervalsFilter> notContaining(Intervals v) {
            this._kind = Kind.NotContaining;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsFilter> notContaining(Function<Intervals.Builder, ObjectBuilder<Intervals>> fn) {
            return this.notContaining(fn.apply(new Intervals.Builder()).build());
        }

        public ObjectBuilder<IntervalsFilter> notOverlapping(Intervals v) {
            this._kind = Kind.NotOverlapping;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsFilter> notOverlapping(Function<Intervals.Builder, ObjectBuilder<Intervals>> fn) {
            return this.notOverlapping(fn.apply(new Intervals.Builder()).build());
        }

        public ObjectBuilder<IntervalsFilter> overlapping(Intervals v) {
            this._kind = Kind.Overlapping;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsFilter> overlapping(Function<Intervals.Builder, ObjectBuilder<Intervals>> fn) {
            return this.overlapping(fn.apply(new Intervals.Builder()).build());
        }

        public ObjectBuilder<IntervalsFilter> script(Script v) {
            this._kind = Kind.Script;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IntervalsFilter> script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Override
        public IntervalsFilter build() {
            this._checkSingleUse();
            return new IntervalsFilter(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        After("after"),
        Before("before"),
        ContainedBy("contained_by"),
        Containing("containing"),
        NotContainedBy("not_contained_by"),
        NotContaining("not_containing"),
        NotOverlapping("not_overlapping"),
        Overlapping("overlapping"),
        Script("script");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

