/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.consumers.ThrowingConsumer;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ExtraFieldUtils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.backup.zip.MessageIdExtraField;
import org.apache.james.mailbox.backup.zip.SizeExtraField;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.vault.DeletedMessage;

public class DeletedMessageZipper {
    @VisibleForTesting
    static final String EML_FILE_EXTENSION = ".eml";

    public DeletedMessageZipper() {
        ExtraFieldUtils.register(MessageIdExtraField.class);
        ExtraFieldUtils.register(SizeExtraField.class);
    }

    public void zip(DeletedMessageContentLoader contentLoader, Stream<DeletedMessage> deletedMessages, OutputStream outputStream) throws IOException {
        try (ZipArchiveOutputStream zipOutputStream = this.newZipArchiveOutputStream(outputStream);){
            ThrowingConsumer putInZip = message -> this.putMessageToEntry(zipOutputStream, (DeletedMessage)message, contentLoader.load((DeletedMessage)message));
            deletedMessages.forEach(Throwing.consumer((ThrowingConsumer)putInZip).sneakyThrow());
            zipOutputStream.finish();
        }
    }

    @VisibleForTesting
    ZipArchiveOutputStream newZipArchiveOutputStream(OutputStream outputStream) {
        return new ZipArchiveOutputStream(outputStream);
    }

    @VisibleForTesting
    void putMessageToEntry(ZipArchiveOutputStream zipOutputStream, DeletedMessage message, Optional<InputStream> maybeContent) throws IOException {
        if (maybeContent.isPresent()) {
            try (InputStream closableMessageContent = maybeContent.get();){
                zipOutputStream.putArchiveEntry((ArchiveEntry)this.createEntry(zipOutputStream, message));
                IOUtils.copy((InputStream)closableMessageContent, (OutputStream)zipOutputStream);
                zipOutputStream.closeArchiveEntry();
            }
        }
    }

    @VisibleForTesting
    ZipArchiveEntry createEntry(ZipArchiveOutputStream zipOutputStream, DeletedMessage message) throws IOException {
        MessageId messageId = message.getMessageId();
        ZipArchiveEntry archiveEntry = (ZipArchiveEntry)zipOutputStream.createArchiveEntry(new File(messageId.serialize()), messageId.serialize() + EML_FILE_EXTENSION);
        archiveEntry.addExtraField((ZipExtraField)new MessageIdExtraField(messageId));
        archiveEntry.addExtraField((ZipExtraField)new SizeExtraField(message.getSize()));
        return archiveEntry;
    }

    public static interface DeletedMessageContentLoader {
        public Optional<InputStream> load(DeletedMessage var1);
    }
}

