/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.io.FileNotFoundException;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.Named;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.cassandra.cache.BlobStoreCache;
import org.apache.james.blob.cassandra.cache.CachedBlobStore;
import org.apache.james.blob.cassandra.cache.CassandraBlobCacheModule;
import org.apache.james.blob.cassandra.cache.CassandraBlobStoreCache;
import org.apache.james.blob.cassandra.cache.CassandraCacheConfiguration;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.modules.mailbox.CassandraCacheSessionModule;
import org.apache.james.modules.mailbox.ConfigurationComponent;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreCacheModulesChooser {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobStoreCacheModulesChooser.class);

    public static List<Module> chooseModules(BlobStoreConfiguration blobStoreConfiguration) {
        if (blobStoreConfiguration.cacheEnabled()) {
            return ImmutableList.of((Object)new CassandraCacheSessionModule(), (Object)((Object)new CacheEnabledModule()));
        }
        return ImmutableList.of((Object)((Object)new CacheDisabledModule()));
    }

    static class CacheEnabledModule
    extends AbstractModule {
        CacheEnabledModule() {
        }

        protected void configure() {
            this.bind(CassandraBlobStoreCache.class).in(Scopes.SINGLETON);
            this.bind(BlobStoreCache.class).to(CassandraBlobStoreCache.class);
            Multibinder.newSetBinder((Binder)this.binder(), CassandraModule.class, (Annotation)Names.named((String)"cache")).addBinding().toInstance((Object)CassandraBlobCacheModule.MODULE);
        }

        @Provides
        @Named(value="blobStoreImplementation")
        @Singleton
        BlobStore provideBlobStore(CachedBlobStore cachedBlobStore) {
            return cachedBlobStore;
        }

        @Provides
        @Singleton
        CassandraCacheConfiguration providesCacheConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
            try {
                Configuration configuration = propertiesProvider.getConfigurations(ConfigurationComponent.NAMES);
                return CassandraCacheConfiguration.from((Configuration)configuration);
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("Could not find blob configuration file, using cassandra cache defaults");
                return CassandraCacheConfiguration.DEFAULT;
            }
        }
    }

    static class CacheDisabledModule
    extends AbstractModule {
        CacheDisabledModule() {
        }

        @Provides
        @Named(value="blobStoreImplementation")
        @Singleton
        BlobStore provideBlobStore(@Named(value="blobStoreBackend") BlobStore blobStore) {
            return blobStore;
        }
    }
}

